/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.AllocationEventFilter;
import com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import com.oracle.truffle.api.instrumentation.NearestNodesCollector;
import com.oracle.truffle.api.instrumentation.NearestSectionFilter;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.Equivalence;

public class EventBinding<T> {
    private final InstrumentationHandler.AbstractInstrumenter instrumenter;
    private final T element;
    private final AtomicReference<Boolean> attached;
    final Semaphore attachedSemaphore = new Semaphore(0);
    volatile boolean disposing;
    private volatile boolean disposed;

    EventBinding(InstrumentationHandler.AbstractInstrumenter instrumenter, T element) {
        this(instrumenter, element, true);
    }

    EventBinding(InstrumentationHandler.AbstractInstrumenter instrumenter, T element, boolean attached) {
        if (element == null) {
            throw new NullPointerException();
        }
        this.instrumenter = instrumenter;
        this.element = element;
        this.attached = new AtomicReference<Boolean>(attached);
        if (attached) {
            this.attachedSemaphore.release();
        }
    }

    final InstrumentationHandler.AbstractInstrumenter getInstrumenter() {
        return this.instrumenter;
    }

    public T getElement() {
        return this.element;
    }

    public final boolean isAttached() {
        return Boolean.TRUE == this.attached.get();
    }

    public final void attach() {
        Boolean wasAttached = this.attached.getAndSet(true);
        if (null == wasAttached) {
            throw new IllegalStateException("The binding is disposed. Create a new binding to attach.");
        }
        if (Boolean.TRUE == wasAttached) {
            throw new IllegalStateException("The binding is attached already.");
        }
        this.doAttach();
        this.attachedSemaphore.release();
    }

    public final boolean tryAttach() {
        Boolean wasAttached = this.attached.getAndSet(true);
        if (Boolean.FALSE != wasAttached) {
            return false;
        }
        this.doAttach();
        this.attachedSemaphore.release();
        return true;
    }

    void doAttach() {
        throw CompilerDirectives.shouldNotReachHere(this.toString() + ".doAttach()");
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public synchronized void dispose() {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.disposed) {
            this.disposing = true;
            Boolean wasSet = this.attached.getAndSet(null);
            if (Boolean.TRUE == wasSet) {
                try {
                    this.attachedSemaphore.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.instrumenter.disposeBinding(this);
            this.disposed = true;
        }
    }

    synchronized void setDisposingBulk() {
        this.disposing = true;
    }

    synchronized void disposeBulk() {
        this.disposed = true;
    }

    static final class Allocation<T>
    extends EventBinding<T> {
        private final AllocationEventFilter filterAllocation;

        Allocation(InstrumentationHandler.AbstractInstrumenter instrumenter, AllocationEventFilter filter, T listener) {
            super(instrumenter, listener);
            this.filterAllocation = filter;
        }

        AllocationEventFilter getAllocationFilter() {
            return this.filterAllocation;
        }
    }

    static abstract class NearestSourceSection<T>
    extends Source<T> {
        private final NearestSectionFilter nearestFilter;
        private final EconomicMap<com.oracle.truffle.api.source.Source, NearestNodesCollector.NodeListSection> nearestSourceSections;

        NearestSourceSection(InstrumentationHandler.AbstractInstrumenter instrumenter, NearestSectionFilter nearestFilter, SourceSectionFilter filterSourceSection, T element, boolean attached) {
            super(instrumenter, filterSourceSection, null, element, attached);
            assert (nearestFilter != null);
            this.nearestFilter = nearestFilter;
            this.nearestSourceSections = EconomicMap.create(Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        }

        @Override
        boolean isInstrumentedFull(Set<Class<?>> providedTags, RootNode rootNode, Node node, SourceSection nodeSourceSection, boolean isProbe) {
            boolean instrumentedLeaf = this.isInstrumentedLeaf(providedTags, node, nodeSourceSection);
            if (!instrumentedLeaf || rootNode == null) {
                return false;
            }
            if (!isProbe || this.nearestSourceSections == null || isProbe && this.isNearestSection(nodeSourceSection)) {
                return this.isInstrumentedRoot(providedTags, rootNode, rootNode.getSourceSection(), 0);
            }
            return false;
        }

        final NearestSectionFilter getNearestFilter() {
            return this.nearestFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<Node> getNearestNodes() {
            if (this.nearestSourceSections == null) {
                return null;
            }
            EconomicMap<com.oracle.truffle.api.source.Source, NearestNodesCollector.NodeListSection> economicMap = this.nearestSourceSections;
            synchronized (economicMap) {
                if (this.nearestSourceSections.isEmpty()) {
                    return null;
                }
                if (this.nearestSourceSections.size() == 1) {
                    NearestNodesCollector.NodeListSection nearestNodes = (NearestNodesCollector.NodeListSection)this.nearestSourceSections.getValues().iterator().next();
                    return NearestSourceSection.resolveReferences(nearestNodes.nodes);
                }
                ArrayList<Node> nodes = new ArrayList<Node>(this.nearestSourceSections.size());
                for (NearestNodesCollector.NodeListSection nearest : this.nearestSourceSections.getValues()) {
                    NearestSourceSection.resolveReferences(nearest.nodes, nodes);
                }
                return nodes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isNearestSection(SourceSection section) {
            if (this.nearestSourceSections != null) {
                NearestNodesCollector.NodeListSection nearest;
                EconomicMap<com.oracle.truffle.api.source.Source, NearestNodesCollector.NodeListSection> economicMap = this.nearestSourceSections;
                synchronized (economicMap) {
                    nearest = (NearestNodesCollector.NodeListSection)this.nearestSourceSections.get(section.getSource());
                }
                return nearest != null && section.equals(nearest.section);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        NearestNodesCollector.NodeListSection setTheNearest(NearestNodesCollector.NodeSection nearest, SourceSection visitingRootSourceSection, Set<Class<? extends Tag>> allTags) {
            assert (this.nearestSourceSections != null);
            SourceSection newSection = nearest.section;
            com.oracle.truffle.api.source.Source source = newSection.getSource();
            EconomicMap<com.oracle.truffle.api.source.Source, NearestNodesCollector.NodeListSection> economicMap = this.nearestSourceSections;
            synchronized (economicMap) {
                NearestNodesCollector.NodeListSection oldNearest = (NearestNodesCollector.NodeListSection)this.nearestSourceSections.get(source);
                if (oldNearest == null) {
                    return this.insertNearest(nearest);
                }
                SourceSection oldSection = oldNearest.section;
                NearestNodesCollector.NodeListSection newNearest = !newSection.equals(oldSection) ? this.updateNearest(nearest, visitingRootSourceSection, allTags, oldNearest) : NearestSourceSection.mergeNearest(nearest, oldNearest);
                return newNearest;
            }
        }

        private NearestNodesCollector.NodeListSection insertNearest(NearestNodesCollector.NodeSection nearest) {
            LinkedList<WeakReference<Node>> list = new LinkedList<WeakReference<Node>>();
            list.add(new WeakReference<Node>(nearest.node));
            SourceSection newSection = nearest.section;
            com.oracle.truffle.api.source.Source source = newSection.getSource();
            this.nearestSourceSections.put(source, new NearestNodesCollector.NodeListSection(list, newSection));
            return new NearestNodesCollector.NodeListSection(Collections.emptyList(), null);
        }

        private NearestNodesCollector.NodeListSection updateNearest(NearestNodesCollector.NodeSection nearest, SourceSection visitingRootSourceSection, Set<Class<? extends Tag>> allTags, NearestNodesCollector.NodeListSection oldNearest) {
            List<WeakReference<Node>> oldNodes = oldNearest.nodes;
            SourceSection oldSection = oldNearest.section;
            Node oldNode = NearestSourceSection.getFirstReferencedNode(oldNodes);
            if (oldNode == null || NearestNodesCollector.isCloser(nearest, visitingRootSourceSection, oldNode, oldSection, this.nearestFilter, allTags)) {
                ArrayList<WeakReference<Node>> oldNodesCopy = new ArrayList<WeakReference<Node>>(oldNodes);
                oldNodes.clear();
                oldNodes.add(new WeakReference<Node>(nearest.node));
                SourceSection newSection = nearest.section;
                com.oracle.truffle.api.source.Source source = newSection.getSource();
                this.nearestSourceSections.put(source, new NearestNodesCollector.NodeListSection(oldNodes, newSection));
                return new NearestNodesCollector.NodeListSection(oldNodesCopy, oldSection);
            }
            return null;
        }

        private static NearestNodesCollector.NodeListSection mergeNearest(NearestNodesCollector.NodeSection nearest, NearestNodesCollector.NodeListSection oldNearest) {
            List<WeakReference<Node>> oldNodes = oldNearest.nodes;
            Node newNode = nearest.node;
            boolean contains = false;
            for (WeakReference<Node> nodeRef : oldNodes) {
                if (newNode != nodeRef.get()) continue;
                contains = true;
                break;
            }
            if (!contains) {
                oldNodes.add(new WeakReference<Node>(newNode));
            }
            return new NearestNodesCollector.NodeListSection(Collections.emptyList(), oldNearest.section);
        }

        private static Node getFirstReferencedNode(List<WeakReference<Node>> nodes) {
            Node node = null;
            Iterator<WeakReference<Node>> nodesIt = nodes.iterator();
            while (nodesIt.hasNext()) {
                WeakReference<Node> nodeRef = nodesIt.next();
                Node n2 = (Node)nodeRef.get();
                if (n2 == null) {
                    nodesIt.remove();
                    continue;
                }
                node = n2;
            }
            return node;
        }

        private static List<Node> resolveReferences(List<WeakReference<Node>> nodes) {
            ArrayList<Node> resolved = new ArrayList<Node>(nodes.size());
            NearestSourceSection.resolveReferences(nodes, resolved);
            return resolved;
        }

        private static void resolveReferences(List<WeakReference<Node>> nodes, List<Node> resolved) {
            for (WeakReference<Node> ref : nodes) {
                Node n2 = (Node)ref.get();
                if (n2 == null) continue;
                resolved.add(n2);
            }
        }
    }

    static abstract class Source<T>
    extends EventBinding<T> {
        private final SourceSectionFilter filterSourceSection;
        private final SourceSectionFilter inputFilter;

        Source(InstrumentationHandler.AbstractInstrumenter instrumenter, SourceSectionFilter filterSourceSection, SourceSectionFilter inputFilter, T element) {
            this(instrumenter, filterSourceSection, inputFilter, element, true);
        }

        Source(InstrumentationHandler.AbstractInstrumenter instrumenter, SourceSectionFilter filterSourceSection, SourceSectionFilter inputFilter, T element, boolean attached) {
            super(instrumenter, element, attached);
            this.inputFilter = inputFilter;
            this.filterSourceSection = filterSourceSection;
        }

        final SourceSectionFilter getInputFilter() {
            return this.inputFilter;
        }

        final Set<Class<?>> getLimitedTags() {
            Set<Class<?>> tags = this.filterSourceSection.getLimitedTags();
            if (this.inputFilter != null) {
                Set<Class<?>> inputTags = this.inputFilter.getLimitedTags();
                if (tags == null) {
                    return inputTags;
                }
                if (inputTags == null) {
                    return tags;
                }
                if (inputTags.equals(tags)) {
                    return tags;
                }
                HashSet compoundTags = new HashSet();
                compoundTags.addAll(tags);
                compoundTags.addAll(inputTags);
                return compoundTags;
            }
            return tags;
        }

        final SourceSectionFilter getFilter() {
            return this.filterSourceSection;
        }

        boolean isInstrumentedFull(Set<Class<?>> providedTags, RootNode rootNode, Node node, SourceSection nodeSourceSection, boolean isProbe) {
            boolean instrumentedLeaf = this.isInstrumentedLeaf(providedTags, node, nodeSourceSection);
            if (!instrumentedLeaf || rootNode == null) {
                return false;
            }
            return this.isInstrumentedRoot(providedTags, rootNode, rootNode.getSourceSection(), 0);
        }

        boolean isChildInstrumentedFull(Set<Class<?>> providedTags, RootNode rootNode, Node parent, SourceSection parentSourceSection, Node current, SourceSection currentSourceSection) {
            if (this.inputFilter == null) {
                return false;
            }
            if (rootNode == null) {
                return false;
            }
            if (!InstrumentationHandler.isInstrumentableNode(parent)) {
                return false;
            }
            if (this.isInstrumentedLeaf(providedTags, parent, parentSourceSection) && this.isInstrumentedNodeWithInputFilter(providedTags, current, currentSourceSection)) {
                return this.isInstrumentedRoot(providedTags, rootNode, rootNode.getSourceSection(), 0);
            }
            return false;
        }

        boolean isChildInstrumentedLeaf(Set<Class<?>> providedTags, RootNode rootNode, Node parent, SourceSection parentSourceSection, Node current, SourceSection currentSourceSection) {
            if (this.inputFilter == null) {
                return false;
            }
            if (rootNode == null) {
                return false;
            }
            if (!InstrumentationHandler.isInstrumentableNode(parent)) {
                return false;
            }
            return this.isInstrumentedLeaf(providedTags, parent, parentSourceSection) && this.isInstrumentedNodeWithInputFilter(providedTags, current, currentSourceSection);
        }

        private boolean isInstrumentedNodeWithInputFilter(Set<Class<?>> providedTags, Node current, SourceSection currentSourceSection) {
            try {
                return this.inputFilter.isInstrumentedNode(providedTags, current, currentSourceSection);
            }
            catch (Throwable t2) {
                if (this.isLanguageBinding()) {
                    throw t2;
                }
                ProbeNode.exceptionEventForClientInstrument(this, this.inputFilter.toString(), t2);
                return false;
            }
        }

        boolean isInstrumentedRoot(Set<Class<?>> providedTags, RootNode rootNode, SourceSection rootSourceSection, int rootNodeBits) {
            if (!this.getInstrumenter().isInstrumentableRoot(rootNode)) {
                return false;
            }
            try {
                return this.getFilter().isInstrumentedRoot(providedTags, rootSourceSection, rootNode, rootNodeBits);
            }
            catch (Throwable t2) {
                if (this.isLanguageBinding()) {
                    throw t2;
                }
                ProbeNode.exceptionEventForClientInstrument(this, this.getFilter().toString(), t2);
                return false;
            }
        }

        boolean isInstrumentedLeaf(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection section) {
            try {
                boolean instrumented = this.getFilter().isInstrumentedNode(providedTags, instrumentedNode, section);
                return instrumented;
            }
            catch (Throwable t2) {
                if (this.isLanguageBinding()) {
                    throw t2;
                }
                ProbeNode.exceptionEventForClientInstrument(this, this.getFilter().toString(), t2);
                return false;
            }
        }

        boolean isInstrumentedSource(com.oracle.truffle.api.source.Source source) {
            if (!this.getInstrumenter().isInstrumentableSource(source)) {
                return false;
            }
            try {
                return this.getFilter().isInstrumentedSource(source);
            }
            catch (Throwable t2) {
                if (this.isLanguageBinding()) {
                    throw t2;
                }
                ProbeNode.exceptionEventForClientInstrument(this, this.getFilter().toString(), t2);
                return false;
            }
        }

        abstract boolean isExecutionEvent();

        boolean isLanguageBinding() {
            return this.getInstrumenter() instanceof InstrumentationHandler.LanguageClientInstrumenter;
        }
    }

    static final class NearestExecution<T>
    extends NearestSourceSection<T> {
        NearestExecution(InstrumentationHandler.AbstractInstrumenter instrumenter, NearestSectionFilter nearestFilter, SourceSectionFilter filterSourceSection, T element) {
            super(instrumenter, nearestFilter, filterSourceSection, element, true);
        }

        @Override
        boolean isExecutionEvent() {
            return true;
        }
    }

    static final class Execution<T>
    extends Source<T> {
        Execution(InstrumentationHandler.AbstractInstrumenter instrumenter, SourceSectionFilter filterSourceSection, SourceSectionFilter inputFilter, T element) {
            super(instrumenter, filterSourceSection, inputFilter, element);
        }

        @Override
        boolean isExecutionEvent() {
            return true;
        }
    }

    static abstract class LoadSource<T>
    extends Source<T>
    implements LoadedNotifier {
        private final boolean notifyLoaded;

        LoadSource(InstrumentationHandler.AbstractInstrumenter instrumenter, SourceSectionFilter filterSourceSection, SourceSectionFilter inputFilter, T element, boolean attached, boolean notifyLoaded) {
            super(instrumenter, filterSourceSection, inputFilter, element, attached);
            this.notifyLoaded = notifyLoaded;
        }

        @Override
        public final boolean isNotifyLoaded() {
            return this.notifyLoaded;
        }

        @Override
        final boolean isExecutionEvent() {
            return false;
        }
    }

    static final class LoadNearestSection<T>
    extends NearestSourceSection<T>
    implements LoadedNotifier {
        private final boolean notifyLoaded;

        LoadNearestSection(InstrumentationHandler.AbstractInstrumenter instrumenter, NearestSectionFilter nearestFilter, SourceSectionFilter filterSourceSection, T element, boolean attached, boolean notifyLoaded) {
            super(instrumenter, nearestFilter, filterSourceSection, element, attached);
            this.notifyLoaded = notifyLoaded;
        }

        @Override
        void doAttach() {
            this.getInstrumenter().attachSourceSectionBinding(this);
        }

        @Override
        public boolean isNotifyLoaded() {
            return this.notifyLoaded;
        }

        @Override
        boolean isExecutionEvent() {
            return false;
        }
    }

    static interface LoadedNotifier {
        public boolean isNotifyLoaded();
    }

    static final class SourceSectionLoaded<T>
    extends LoadSource<T> {
        SourceSectionLoaded(InstrumentationHandler.AbstractInstrumenter instrumenter, SourceSectionFilter filterSourceSection, SourceSectionFilter inputFilter, T element, boolean attached, boolean notifyLoaded) {
            super(instrumenter, filterSourceSection, inputFilter, element, attached, notifyLoaded);
        }

        @Override
        void doAttach() {
            this.getInstrumenter().attachSourceSectionBinding(this);
        }
    }

    static final class SourceExecuted<T>
    extends LoadSource<T> {
        SourceExecuted(InstrumentationHandler.AbstractInstrumenter instrumenter, SourceSectionFilter filterSourceSection, SourceSectionFilter inputFilter, T element, boolean attached, boolean notifyLoaded) {
            super(instrumenter, filterSourceSection, inputFilter, element, attached, notifyLoaded);
        }

        @Override
        void doAttach() {
            this.getInstrumenter().attachSourceExecutedBinding(this);
        }
    }

    static final class SourceLoaded<T>
    extends LoadSource<T> {
        SourceLoaded(InstrumentationHandler.AbstractInstrumenter instrumenter, SourceSectionFilter filterSourceSection, SourceSectionFilter inputFilter, T element, boolean attached, boolean notifyLoaded) {
            super(instrumenter, filterSourceSection, inputFilter, element, attached, notifyLoaded);
        }

        @Override
        void doAttach() {
            this.getInstrumenter().attachSourceLoadedBinding(this);
        }
    }
}

