/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.js.nodes.array.ArrayCreateNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

@GeneratedBy(value=ArrayCreateNode.class)
public final class ArrayCreateNodeGen
extends ArrayCreateNode {
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private ArrayCreateNodeGen(JSContext context) {
        super(context);
    }

    @Override
    public JSArrayObject execute(long arg0Value, JSRealm arg1Value, JSDynamicObject arg2Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && JSRuntime.isValidArrayLength(arg0Value) && arg0Value <= Integer.MAX_VALUE) {
                return this.doDefault(arg0Value, arg1Value, arg2Value);
            }
            if ((state_0 & 2) != 0 && JSRuntime.isValidArrayLength(arg0Value) && arg0Value > Integer.MAX_VALUE) {
                return this.doLargeLength(arg0Value, arg1Value, arg2Value);
            }
            if ((state_0 & 4) != 0 && !JSRuntime.isValidArrayLength(arg0Value)) {
                return this.doInvalidLength(arg0Value, arg1Value, arg2Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private JSArrayObject executeAndSpecialize(long arg0Value, JSRealm arg1Value, JSDynamicObject arg2Value) {
        int state_0 = this.state_0_;
        if (JSRuntime.isValidArrayLength(arg0Value) && arg0Value <= Integer.MAX_VALUE) {
            this.state_0_ = state_0 |= 1;
            return this.doDefault(arg0Value, arg1Value, arg2Value);
        }
        if (JSRuntime.isValidArrayLength(arg0Value) && arg0Value > Integer.MAX_VALUE) {
            this.state_0_ = state_0 |= 2;
            return this.doLargeLength(arg0Value, arg1Value, arg2Value);
        }
        if (!JSRuntime.isValidArrayLength(arg0Value)) {
            this.state_0_ = state_0 |= 4;
            return this.doInvalidLength(arg0Value, arg1Value, arg2Value);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
    }

    @NeverDefault
    public static ArrayCreateNode create(JSContext context) {
        return new ArrayCreateNodeGen(context);
    }
}

