/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.array.JSArrayNextElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayToDenseObjectArrayNode;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

@GeneratedBy(value=JSArrayToDenseObjectArrayNode.class)
public final class JSArrayToDenseObjectArrayNodeGen
extends JSArrayToDenseObjectArrayNode {
    private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_0_");
    static final InlineSupport.ReferenceField<FromDenseArrayData> FROM_DENSE_ARRAY_CACHE_UPDATER = InlineSupport.ReferenceField.create(MethodHandles.lookup(), "fromDenseArray_cache", FromDenseArrayData.class);
    static final InlineSupport.ReferenceField<FromSparseArrayData> FROM_SPARSE_ARRAY_CACHE_UPDATER = InlineSupport.ReferenceField.create(MethodHandles.lookup(), "fromSparseArray_cache", FromSparseArrayData.class);
    private static final InlinedBranchProfile INLINED_GROW_PROFILE = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(3, 1)));
    @CompilerDirectives.CompilationFinal
    @InlineSupport.UnsafeAccessedField
    private int state_0_;
    @Node.Child
    private ReadElementNode readNode;
    @Node.Child
    private JSArrayNextElementIndexNode nextElementIndexNode;
    @CompilerDirectives.CompilationFinal
    @InlineSupport.UnsafeAccessedField
    private FromDenseArrayData fromDenseArray_cache;
    @Node.Child
    @InlineSupport.UnsafeAccessedField
    private FromSparseArrayData fromSparseArray_cache;

    private JSArrayToDenseObjectArrayNodeGen() {
    }

    @Override
    @ExplodeLoop
    public Object[] executeObjectArray(JSArrayObject arg0Value, ScriptArray arg1Value, long arg2Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 7) != 0) {
            ReadElementNode readNode_1;
            JSArrayNextElementIndexNode nextElementIndexNode_1;
            if ((state_0 & 1) != 0) {
                FromDenseArrayData s0_ = this.fromDenseArray_cache;
                while (s0_ != null) {
                    ReadElementNode readNode_ = this.readNode;
                    if (readNode_ != null && s0_.cachedArrayType_.isInstance(arg1Value)) {
                        assert (DSLSupport.assertIdempotence(!s0_.cachedArrayType_.isHolesType()));
                        return JSArrayToDenseObjectArrayNode.fromDenseArray(arg0Value, arg1Value, arg2Value, s0_.cachedArrayType_, readNode_);
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 4) != 0) {
                FromSparseArrayData s1_ = this.fromSparseArray_cache;
                while (s1_ != null) {
                    JSArrayNextElementIndexNode nextElementIndexNode_ = this.nextElementIndexNode;
                    if (nextElementIndexNode_ != null && s1_.cachedArrayType_.isInstance(arg1Value)) {
                        JSArrayToDenseObjectArrayNodeGen node__ = this;
                        assert (DSLSupport.assertIdempotence(s1_.cachedArrayType_.isHolesType()));
                        return JSArrayToDenseObjectArrayNode.fromSparseArray(arg0Value, arg1Value, arg2Value, s1_.cachedArrayType_, node__, nextElementIndexNode_, INLINED_GROW_PROFILE);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0 && (nextElementIndexNode_1 = this.nextElementIndexNode) != null && (readNode_1 = this.readNode) != null) {
                return this.doUncached(arg0Value, arg1Value, arg2Value, nextElementIndexNode_1, readNode_1, INLINED_GROW_PROFILE);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Object[] executeAndSpecialize(JSArrayObject arg0Value, ScriptArray arg1Value, long arg2Value) {
        ReadElementNode readNode_1;
        ReadElementNode readNode_1_shared;
        JSArrayNextElementIndexNode nextElementIndexNode_1;
        JSArrayNextElementIndexNode nextElementIndexNode_1_shared;
        int state_0 = this.state_0_;
        if ((state_0 & 2) == 0) {
            FromDenseArrayData s0_;
            block26: {
                FromDenseArrayData s0_original;
                do {
                    ReadElementNode readNode_;
                    ScriptArray cachedArrayType__;
                    int count0_ = 0;
                    s0_original = s0_ = FROM_DENSE_ARRAY_CACHE_UPDATER.getVolatile(this);
                    while (s0_ != null) {
                        ReadElementNode readNode_2 = this.readNode;
                        if (readNode_2 != null && s0_.cachedArrayType_.isInstance(arg1Value)) {
                            assert (DSLSupport.assertIdempotence(!s0_.cachedArrayType_.isHolesType()));
                            break;
                        }
                        ++count0_;
                        s0_ = s0_.next_;
                    }
                    if (s0_ != null || !(cachedArrayType__ = arg1Value).isInstance(arg1Value) || cachedArrayType__.isHolesType() || count0_ >= 5) break block26;
                    s0_ = new FromDenseArrayData(s0_original);
                    s0_.cachedArrayType_ = cachedArrayType__;
                    ReadElementNode readNode__shared = this.readNode;
                    if (readNode__shared != null) {
                        readNode_ = readNode__shared;
                    } else {
                        readNode_ = this.insert(ReadElementNode.create(this.getJSContext()));
                        if (readNode_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.readNode != null) continue;
                    this.readNode = readNode_;
                } while (!FROM_DENSE_ARRAY_CACHE_UPDATER.compareAndSet(this, s0_original, s0_));
                this.state_0_ = state_0 |= 1;
            }
            if (s0_ != null) {
                return JSArrayToDenseObjectArrayNode.fromDenseArray(arg0Value, arg1Value, arg2Value, s0_.cachedArrayType_, this.readNode);
            }
        }
        JSArrayToDenseObjectArrayNodeGen node__ = null;
        if ((state_0 & 2) == 0) {
            FromSparseArrayData s1_;
            block27: {
                FromSparseArrayData s1_original;
                do {
                    JSArrayNextElementIndexNode nextElementIndexNode_;
                    ScriptArray cachedArrayType__1;
                    int count1_ = 0;
                    s1_original = s1_ = FROM_SPARSE_ARRAY_CACHE_UPDATER.getVolatile(this);
                    while (s1_ != null) {
                        JSArrayNextElementIndexNode nextElementIndexNode_2 = this.nextElementIndexNode;
                        if (nextElementIndexNode_2 != null && s1_.cachedArrayType_.isInstance(arg1Value)) {
                            assert (DSLSupport.assertIdempotence(s1_.cachedArrayType_.isHolesType()));
                            node__ = this;
                            break;
                        }
                        ++count1_;
                        s1_ = s1_.next_;
                    }
                    if (s1_ != null || !(cachedArrayType__1 = arg1Value).isInstance(arg1Value) || !cachedArrayType__1.isHolesType() || count1_ >= 5) break block27;
                    s1_ = this.insert(new FromSparseArrayData(s1_original));
                    s1_.cachedArrayType_ = cachedArrayType__1;
                    node__ = this;
                    JSArrayNextElementIndexNode nextElementIndexNode__shared = this.nextElementIndexNode;
                    if (nextElementIndexNode__shared != null) {
                        nextElementIndexNode_ = nextElementIndexNode__shared;
                    } else {
                        nextElementIndexNode_ = s1_.insert(JSArrayNextElementIndexNode.create(this.getJSContext()));
                        if (nextElementIndexNode_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.nextElementIndexNode != null) continue;
                    this.nextElementIndexNode = nextElementIndexNode_;
                } while (!FROM_SPARSE_ARRAY_CACHE_UPDATER.compareAndSet(this, s1_original, s1_));
                this.state_0_ = state_0 |= 4;
            }
            if (s1_ != null) {
                return JSArrayToDenseObjectArrayNode.fromSparseArray(arg0Value, arg1Value, arg2Value, s1_.cachedArrayType_, node__, this.nextElementIndexNode, INLINED_GROW_PROFILE);
            }
        }
        if ((nextElementIndexNode_1_shared = this.nextElementIndexNode) != null) {
            nextElementIndexNode_1 = nextElementIndexNode_1_shared;
        } else {
            nextElementIndexNode_1 = this.insert(JSArrayNextElementIndexNode.create(this.getJSContext()));
            if (nextElementIndexNode_1 == null) {
                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
            }
        }
        if (this.nextElementIndexNode == null) {
            VarHandle.storeStoreFence();
            this.nextElementIndexNode = nextElementIndexNode_1;
        }
        if ((readNode_1_shared = this.readNode) != null) {
            readNode_1 = readNode_1_shared;
        } else {
            readNode_1 = this.insert(ReadElementNode.create(this.getJSContext()));
            if (readNode_1 == null) {
                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
            }
        }
        if (this.readNode == null) {
            VarHandle.storeStoreFence();
            this.readNode = readNode_1;
        }
        this.fromDenseArray_cache = null;
        this.fromSparseArray_cache = null;
        state_0 &= 0xFFFFFFFA;
        this.state_0_ = state_0 |= 2;
        return this.doUncached(arg0Value, arg1Value, arg2Value, nextElementIndexNode_1, readNode_1, INLINED_GROW_PROFILE);
    }

    @NeverDefault
    public static JSArrayToDenseObjectArrayNode create() {
        return new JSArrayToDenseObjectArrayNodeGen();
    }

    @GeneratedBy(value=JSArrayToDenseObjectArrayNode.class)
    @DenyReplace
    private static final class FromDenseArrayData
    implements DSLSupport.SpecializationDataNode {
        @CompilerDirectives.CompilationFinal
        final FromDenseArrayData next_;
        @CompilerDirectives.CompilationFinal
        ScriptArray cachedArrayType_;

        FromDenseArrayData(FromDenseArrayData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=JSArrayToDenseObjectArrayNode.class)
    @DenyReplace
    private static final class FromSparseArrayData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        FromSparseArrayData next_;
        @CompilerDirectives.CompilationFinal
        ScriptArray cachedArrayType_;

        FromSparseArrayData(FromSparseArrayData next_) {
            this.next_ = next_;
        }
    }
}

