/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Locale;

public final class Strings {
    public static final TruffleString EMPTY_STRING = TruffleString.Encoding.UTF_16.getEmpty();
    public static final String LINE_SEPARATOR_JLS = "\n";
    public static final TruffleString LINE_SEPARATOR = Strings.constant("\n");
    public static final TruffleString ZERO = Strings.constant("0");
    public static final TruffleString NEGATIVE_ZERO = Strings.constant("-0");
    public static final TruffleString INFINITY = Strings.constant("Infinity");
    public static final TruffleString NEGATIVE_INFINITY = Strings.constant("-Infinity");
    public static final TruffleString POSITIVE_INFINITY = Strings.constant("+Infinity");
    public static final TruffleString NAN = Strings.constant("NaN");
    public static final TruffleString CAPS_POSITIVE_INFINITY = Strings.constant("POSITIVE_INFINITY");
    public static final TruffleString CAPS_NEGATIVE_INFINITY = Strings.constant("NEGATIVE_INFINITY");
    public static final TruffleString CAPS_MAX_VALUE = Strings.constant("MAX_VALUE");
    public static final TruffleString CAPS_MIN_VALUE = Strings.constant("MIN_VALUE");
    public static final TruffleString CAPS_EPSILON = Strings.constant("EPSILON");
    public static final TruffleString CAPS_MAX_SAFE_INTEGER = Strings.constant("MAX_SAFE_INTEGER");
    public static final TruffleString CAPS_MIN_SAFE_INTEGER = Strings.constant("MIN_SAFE_INTEGER");
    public static final TruffleString E = Strings.constant("E");
    public static final TruffleString PI = Strings.constant("PI");
    public static final TruffleString LN_10 = Strings.constant("LN10");
    public static final TruffleString LN_2 = Strings.constant("LN2");
    public static final TruffleString LOG_2_E = Strings.constant("LOG2E");
    public static final TruffleString LOG_10_E = Strings.constant("LOG10E");
    public static final TruffleString SQRT_1_2 = Strings.constant("SQRT1_2");
    public static final TruffleString SQRT_2 = Strings.constant("SQRT2");
    public static final TruffleString ANGLE_BRACKET_OPEN = Strings.constant("<");
    public static final TruffleString ANGLE_BRACKET_OPEN_2 = Strings.constant("<<");
    public static final TruffleString ANGLE_BRACKET_CLOSE = Strings.constant(">");
    public static final TruffleString ANGLE_BRACKET_CLOSE_2 = Strings.constant(">>");
    public static final TruffleString ANGLE_BRACKET_CLOSE_3 = Strings.constant(">>>");
    public static final TruffleString ANGLE_BRACKET_OPEN_SLASH = Strings.constant("</");
    public static final TruffleString BACKSLASH = Strings.constant("\\");
    public static final TruffleString BIG_ARROW_SPACES = Strings.constant(" => ");
    public static final TruffleString BRACKET_OPEN = Strings.constant("[");
    public static final TruffleString BRACKET_OPEN_2 = Strings.constant("[[");
    public static final TruffleString BRACKET_CLOSE = Strings.constant("]");
    public static final TruffleString BRACKET_CLOSE_2_COLON = Strings.constant("]]: ");
    public static final TruffleString COMMA = Strings.constant(",");
    public static final TruffleString COMMA_SPC = Strings.constant(", ");
    public static final TruffleString COMMA_NEWLINE = Strings.constant(",\n");
    public static final TruffleString COLON = Strings.constant(":");
    public static final TruffleString COLON_SPACE = Strings.constant(": ");
    public static final TruffleString DASH = Strings.constant("-");
    public static final TruffleString DOUBLE_QUOTE = Strings.constant("\"");
    public static final TruffleString DOT = Strings.constant(".");
    public static final TruffleString DOT_SLASH = Strings.constant("./");
    public static final TruffleString DOT_DOT_SLASH = Strings.constant("../");
    public static final TruffleString DOT_DOT_DOT = Strings.constant("...");
    public static final TruffleString EMPTY_ARRAY = Strings.constant("[]");
    public static final TruffleString EMPTY_ARRAY_DOTS = Strings.constant("[...]");
    public static final TruffleString EMPTY_OBJECT = Strings.constant("{}");
    public static final TruffleString EMPTY_OBJECT_DOTS = Strings.constant("{...}");
    public static final TruffleString EQUALS_DOUBLE_QUOTE = Strings.constant("=\"");
    public static final TruffleString EXCLAMATION_MARK = Strings.constant("!");
    public static final TruffleString GET_DOLLAR_UNDERSCORE = Strings.constant("get $_");
    public static final TruffleString PAREN_OPEN = Strings.constant("(");
    public static final TruffleString PAREN_CLOSE = Strings.constant(")");
    public static final TruffleString UNDERSCORE = Strings.constant("_");
    public static final TruffleString UNDERSCORE_2 = Strings.constant("__");
    public static final TruffleString SLASH = Strings.constant("/");
    public static final TruffleString SPACE = Strings.constant(" ");
    public static final TruffleString SINGLE_QUOTE = Strings.constant("'");
    public static final TruffleString SYMBOL_PLUS = Strings.constant("+");
    public static final TruffleString SYMBOL_PLUS_PLUS = Strings.constant("++");
    public static final TruffleString SYMBOL_MINUS = DASH;
    public static final TruffleString SYMBOL_MINUS_MINUS = Strings.constant("--");
    public static final TruffleString SYMBOL_AMPERSAND = Strings.constant("&");
    public static final TruffleString SYMBOL_PIPE = Strings.constant("|");
    public static final TruffleString SYMBOL_PERCENT = Strings.constant("%");
    public static final TruffleString SYMBOL_CARET = Strings.constant("^");
    public static final TruffleString SYMBOL_TILDE = Strings.constant("~");
    public static final TruffleString SYMBOL_EQUALS_EQUALS = Strings.constant("==");
    public static final TruffleString SYMBOL_STAR = Strings.constant("*");
    public static final TruffleString SYMBOL_STAR_STAR = Strings.constant("**");
    public static final TruffleString BRACKET_SYMBOL_DOT = Strings.constant("[Symbol.");
    public static final TruffleString ACCESSOR = Strings.constant("accessor");
    public static final TruffleString ADD = Strings.constant("add");
    public static final TruffleString ALL = Strings.constant("all");
    public static final TruffleString ANY = Strings.constant("any");
    public static final TruffleString APPLY = Strings.constant("apply");
    public static final TruffleString ARGUMENTS = Strings.constant("arguments");
    public static final TruffleString BOUND = Strings.constant("bound");
    public static final TruffleString CALL = Strings.constant("call");
    public static final TruffleString CALLEE = Strings.constant("callee");
    public static final TruffleString CALLER = Strings.constant("caller");
    public static final TruffleString CAUSE = Strings.constant("cause");
    public static final TruffleString COMPARE = Strings.constant("compare");
    public static final TruffleString CONSTRUCT = Strings.constant("construct");
    public static final TruffleString DEFAULT = Strings.constant("default");
    public static final TruffleString DEFAULT_VALUE = Strings.constant("defaultValue");
    public static final TruffleString DELETE = Strings.constant("delete");
    public static final TruffleString DONE = Strings.constant("done");
    public static final TruffleString EMPTY = Strings.constant("empty");
    public static final TruffleString EMPTY_X = Strings.constant("empty \u00d7 ");
    public static final TruffleString ENTRIES = Strings.constant("entries");
    public static final TruffleString UC_ERROR = Strings.constant("Error");
    public static final TruffleString FILE = Strings.constant("file");
    public static final TruffleString FORMAT = Strings.constant("format");
    public static final TruffleString FUNCTION = Strings.constant("function");
    public static final TruffleString GLOBAL = Strings.constant("global");
    public static final TruffleString HAS = Strings.constant("has");
    public static final TruffleString INDEX = Strings.constant("index");
    public static final TruffleString INPUT = Strings.constant("input");
    public static final TruffleString INSTANCE = Strings.constant("instance");
    public static final TruffleString JOIN = Strings.constant("join");
    public static final String JOIN_JLS = Strings.toJavaString(JOIN);
    public static final TruffleString JSON = Strings.constant("json");
    public static final TruffleString KEY = Strings.constant("key");
    public static final TruffleString KEYS = Strings.constant("keys");
    public static final TruffleString LENGTH = Strings.constant("length");
    public static final TruffleString MESSAGE = Strings.constant("message");
    public static final TruffleString MODULE = Strings.constant("module");
    public static final TruffleString NAME = Strings.constant("name");
    public static final TruffleString NATIVE = Strings.constant("native");
    public static final TruffleString NEG = Strings.constant("neg");
    public static final TruffleString NEXT = Strings.constant("next");
    public static final TruffleString NOW = Strings.constant("now");
    public static final TruffleString NULL = Strings.constant("null");
    public static final TruffleString UC_NUMBER = Strings.constant("Number");
    public static final TruffleString OBJECT = Strings.constant("object");
    public static final TruffleString PARSE = Strings.constant("parse");
    public static final TruffleString POS = Strings.constant("pos");
    public static final TruffleString PRIMITIVE_VALUE = Strings.constant("PrimitiveValue");
    public static final TruffleString PROMISE = Strings.constant("promise");
    public static final TruffleString RAW = Strings.constant("raw");
    public static final TruffleString RAW_JSON = Strings.constant("rawJSON");
    public static final TruffleString REJECT = Strings.constant("reject");
    public static final TruffleString RESOLVE = Strings.constant("resolve");
    public static final TruffleString RETURN = Strings.constant("return");
    public static final TruffleString SCRIPT = Strings.constant("script");
    public static final TruffleString SOURCE = Strings.constant("source");
    public static final TruffleString STRING = Strings.constant("string");
    public static final TruffleString UC_STRING = Strings.constant("String");
    public static final TruffleString SUPER = Strings.constant("super");
    public static final TruffleString SWITCH = Strings.constant("switch");
    public static final TruffleString SYMBOL = Strings.constant("symbol");
    public static final TruffleString UC_SYMBOL = Strings.constant("Symbol");
    public static final TruffleString THEN = Strings.constant("then");
    public static final TruffleString THIS = Strings.constant("this");
    public static final TruffleString THROW = Strings.constant("throw");
    public static final TruffleString TYPE = Strings.constant("type");
    public static final TruffleString UNDEFINED = Strings.constant("undefined");
    public static final TruffleString UNKNOWN = Strings.constant("unknown");
    public static final TruffleString URL = Strings.constant("url");
    public static final String VALUE_JLS = "value";
    public static final TruffleString VALUE = Strings.constant("value");
    public static final TruffleString VALUES = Strings.constant("values");
    public static final TruffleString WITH = Strings.constant("with");
    public static final TruffleString ANYFUNC = Strings.constant("anyfunc");
    public static final TruffleString AT = Strings.constant("at");
    public static final TruffleString COPY_WITHIN = Strings.constant("copyWithin");
    public static final TruffleString EVAL_FILE = Strings.constant("evalFile");
    public static final TruffleString EXTERNREF = Strings.constant("externref");
    public static final TruffleString FILL = Strings.constant("fill");
    public static final TruffleString FIND = Strings.constant("find");
    public static final TruffleString FIND_INDEX = Strings.constant("findIndex");
    public static final TruffleString FIND_LAST = Strings.constant("findLast");
    public static final TruffleString FIND_LAST_INDEX = Strings.constant("findLastIndex");
    public static final TruffleString FLAT = Strings.constant("flat");
    public static final TruffleString FLAT_MAP = Strings.constant("flatMap");
    public static final TruffleString INCLUDES = Strings.constant("includes");
    public static final TruffleString IS_VIEW = Strings.constant("isView");
    public static final TruffleString PARSE_INT = Strings.constant("parseInt");
    public static final TruffleString PARSE_FLOAT = Strings.constant("parseFloat");
    public static final TruffleString SLICE = Strings.constant("slice");
    public static final TruffleString STRING_MAX_LENGTH = Strings.constant("stringMaxLength");
    public static final TruffleString TO_JSON = Strings.constant("toJSON");
    public static final TruffleString TO_ISO_STRING = Strings.constant("toISOString");
    public static final TruffleString TO_LOCALE_STRING = Strings.constant("toLocaleString");
    public static final String TO_STRING_JLS = "toString";
    public static final TruffleString TO_STRING = Strings.constant("toString");
    public static final TruffleString TO_UTC_STRING = Strings.constant("toUTCString");
    public static final TruffleString TO_GMT_STRING = Strings.constant("toGMTString");
    public static final String VALUE_OF_JLS = "valueOf";
    public static final TruffleString VALUE_OF = Strings.constant("valueOf");
    public static final TruffleString IMPORT_SCRIPT_ENGINE_GLOBAL_BINDINGS = Strings.constant("importScriptEngineGlobalBindings");
    public static final TruffleString HAS_INSTANCE = Strings.constant("hasInstance");
    public static final TruffleString IS_CONCAT_SPREADABLE = Strings.constant("isConcatSpreadable");
    public static final TruffleString ITERATOR = Strings.constant("iterator");
    public static final TruffleString ASYNC_ITERATOR = Strings.constant("asyncIterator");
    public static final TruffleString MATCH = Strings.constant("match");
    public static final TruffleString MATCH_ALL = Strings.constant("matchAll");
    public static final TruffleString REPLACE = Strings.constant("replace");
    public static final TruffleString SEARCH = Strings.constant("search");
    public static final TruffleString SPECIES = Strings.constant("species");
    public static final TruffleString SPLIT = Strings.constant("split");
    public static final TruffleString TO_STRING_TAG = Strings.constant("toStringTag");
    public static final TruffleString TO_PRIMITIVE = Strings.constant("toPrimitive");
    public static final TruffleString UNSCOPABLES = Strings.constant("unscopables");
    public static final TruffleString TO_REVERSED = Strings.constant("toReversed");
    public static final TruffleString TO_SORTED = Strings.constant("toSorted");
    public static final TruffleString TO_SPLICED = Strings.constant("toSpliced");
    public static final TruffleString UC_ARRAY = Strings.constant("Array");
    public static final TruffleString UC_OBJECT = Strings.constant("Object");
    public static final TruffleString UC_MODULE = Strings.constant("Module");
    public static final TruffleString CAPS_ID = Strings.constant("ID");
    public static final TruffleString CAPS_PWD = Strings.constant("PWD");
    public static final TruffleString DOLLAR_ENV = Strings.constant("$ENV");
    public static final TruffleString HINT_STRING = STRING;
    public static final TruffleString HINT_NUMBER = Strings.constant("number");
    public static final TruffleString HINT_DEFAULT = DEFAULT;
    public static final TruffleString HTML_QUOT = Strings.constant("&quot;");
    public static final TruffleString UC_0X = Strings.constant("0X");
    public static final TruffleString LC_0X = Strings.constant("0x");
    public static final TruffleString PARENS_THIS = Strings.constant("(this)");
    public static final TruffleString SYMBOL_PAREN_OPEN = Strings.constant("Symbol(");
    public static final TruffleString LC_BOOLEAN = Strings.constant("boolean");
    public static final TruffleString UC_BOOLEAN = Strings.constant("Boolean");
    public static final TruffleString BOOLEAN_PROTOTYPE = Strings.constant("Boolean.prototype");
    public static final TruffleString TRUE = Strings.constant("true");
    public static final TruffleString FALSE = Strings.constant("false");
    public static final TruffleString GET = Strings.constant("get");
    public static final TruffleString SET = Strings.constant("set");
    public static final TruffleString GET_SPC = Strings.constant("get ");
    public static final TruffleString SET_SPC = Strings.constant("set ");
    public static final TruffleString IS = Strings.constant("is");
    public static final TruffleString G = Strings.constant("g");
    public static final TruffleString N = Strings.constant("n");
    public static final TruffleString NFC = Strings.constant("NFC");
    public static final TruffleString NFD = Strings.constant("NFD");
    public static final TruffleString NFKC = Strings.constant("NFKC");
    public static final TruffleString NFKD = Strings.constant("NFKD");
    public static final TruffleString MS = Strings.constant("ms");
    public static final TruffleString Y = Strings.constant("y");
    public static final TruffleString OK = Strings.constant("ok");
    public static final TruffleString NOT_EQUAL = Strings.constant("not-equal");
    public static final TruffleString TIMED_OUT = Strings.constant("timed-out");
    public static final TruffleString ARRAY_PAREN_OPEN = Strings.constant("Array(");
    public static final TruffleString BOUND_SPC = Strings.constant("bound ");
    public static final TruffleString BRACKET_OBJECT_SPC = Strings.constant("[object ");
    public static final TruffleString BRACKET_BOOLEAN_SPC = Strings.constant("[Boolean ");
    public static final TruffleString BRACKET_DATE_SPC = Strings.constant("[Date ");
    public static final TruffleString COMMA_ANONYMOUS_BRACKETS = Strings.constant(", <anonymous>");
    public static final TruffleString FUNCTION_NATIVE_CODE_BODY = Strings.constant("() { [native code] }");
    public static final TruffleString FUNCTION_BODY_DOTS = Strings.constant("() {...}");
    public static final TruffleString FUNCTION_BODY_OMITTED = Strings.constant("...<omitted>...\n}");
    public static final TruffleString FUNCTION_SPC = Strings.constant("function ");
    public static final TruffleString FUNCTION_NATIVE_CODE = Strings.constant("function () { [native code] }");
    public static final TruffleString PROXY_PAREN = Strings.constant("Proxy(");
    public static final TruffleString ASYNC_SPC = Strings.constant("async ");
    public static final TruffleString ASYNC_PROMISE_ALL_BEGIN = Strings.constant("async Promise.all (index ");
    public static final TruffleString SPACE_PAREN_OPEN = Strings.constant(" (");
    public static final TruffleString NEW_SPACE = Strings.constant("new ");
    public static final TruffleString BACKSLASH_U = Strings.constant("\\u");
    public static final TruffleString BACKSLASH_U00 = Strings.constant("\\u00");
    public static final TruffleString BACKSLASH_UD = Strings.constant("\\ud");
    public static final TruffleString BACKSLASH_B = Strings.constant("\\b");
    public static final TruffleString BACKSLASH_F = Strings.constant("\\f");
    public static final TruffleString BACKSLASH_N = Strings.constant("\\n");
    public static final TruffleString BACKSLASH_R = Strings.constant("\\r");
    public static final TruffleString BACKSLASH_T = Strings.constant("\\t");
    public static final TruffleString BACKSLASH_BACKSLASH = Strings.constant("\\\\");
    public static final TruffleString BACKSLASH_DOUBLE_QUOTE = Strings.constant("\\\"");
    public static final TruffleString I_64 = Strings.constant("i64");
    public static final TruffleString I_32 = Strings.constant("i32");
    public static final TruffleString F_32 = Strings.constant("f32");
    public static final TruffleString F_64 = Strings.constant("f64");
    public static final TruffleString V_128 = Strings.constant("v128");
    public static final TruffleString PROXY = Strings.constant("proxy");
    public static final TruffleString REVOKE = Strings.constant("revoke");
    public static final TruffleString REVOCABLE = Strings.constant("revocable");
    public static final TruffleString EVAL_OBJ_FILE_NAME = NAME;
    public static final TruffleString EVAL_OBJ_SOURCE = SCRIPT;
    public static final TruffleString FILENAME_VAR_NAME = Strings.constant("__filename");
    public static final TruffleString DIRNAME_VAR_NAME = Strings.constant("__dirname");
    public static final TruffleString MODULE_PROPERTY_NAME = MODULE;
    public static final TruffleString EXPORTS_PROPERTY_NAME = Strings.constant("exports");
    public static final TruffleString REQUIRE_PROPERTY_NAME = Strings.constant("require");
    public static final TruffleString RESOLVE_PROPERTY_NAME = RESOLVE;
    public static final TruffleString LOADED_PROPERTY_NAME = Strings.constant("loaded");
    public static final TruffleString FILENAME_PROPERTY_NAME = Strings.constant("filename");
    public static final TruffleString ID_PROPERTY_NAME = Strings.constant("id");
    public static final TruffleString ENV_PROPERTY_NAME = Strings.constant("env");
    public static final TruffleString PACKAGE_JSON_MAIN_PROPERTY_NAME = Strings.constant("main");
    public static final TruffleString PACKAGE_JSON_TYPE_PROPERTY_NAME = TYPE;
    public static final TruffleString CREATE_REALM = Strings.constant("createRealm");
    public static final TruffleString DETACH_ARRAY_BUFFER = Strings.constant("detachArrayBuffer");
    public static final TruffleString EVAL_SCRIPT = Strings.constant("evalScript");
    public static final TruffleString GC = Strings.constant("gc");
    public static final TruffleString AGENT = Strings.constant("agent");
    public static final TruffleString START = Strings.constant("start");
    public static final TruffleString BROADCAST = Strings.constant("broadcast");
    public static final TruffleString GET_REPORT = Strings.constant("getReport");
    public static final TruffleString SLEEP = Strings.constant("sleep");
    public static final TruffleString MONOTONIC_NOW = Strings.constant("monotonicNow");
    public static final TruffleString RECEIVE_BROADCAST = Strings.constant("receiveBroadcast");
    public static final TruffleString REPORT = Strings.constant("report");
    public static final TruffleString LEAVING = Strings.constant("leaving");
    public static final TruffleString AGENT_START = Strings.constant("agentStart");
    public static final TruffleString AGENT_BROADCAST = Strings.constant("agentBroadcast");
    public static final TruffleString AGENT_GET_REPORT = Strings.constant("agentGetReport");
    public static final TruffleString AGENT_SLEEP = Strings.constant("agentSleep");
    public static final TruffleString AGENT_RECEIVE_BROADCAST = Strings.constant("agentReceiveBroadcast");
    public static final TruffleString AGENT_REPORT = Strings.constant("agentReport");
    public static final TruffleString AGENT_LEAVING = Strings.constant("agentLeaving");
    public static final TruffleString LOAD = Strings.constant("load");
    public static final TruffleString LOAD_WITH_NEW_GLOBAL = Strings.constant("loadWithNewGlobal");
    public static final TruffleString GLOBAL_THIS = Strings.constant("globalThis");
    public static final TruffleString EXIT = Strings.constant("exit");
    public static final TruffleString QUIT = Strings.constant("quit");
    public static final TruffleString PARSE_TO_JSON = Strings.constant("parseToJSON");
    public static final TruffleString PRINT = Strings.constant("print");
    public static final TruffleString PRINT_ERR = Strings.constant("printErr");
    public static final TruffleString GRAAL = Strings.constant("Graal");
    public static final TruffleString LANGUAGE = Strings.constant("language");
    public static final TruffleString VERSION_GRAAL_VM = Strings.constant("versionGraalVM");
    public static final TruffleString VERSION_ECMA_SCRIPT = Strings.constant("versionECMAScript");
    public static final TruffleString IS_GRAAL_RUNTIME = Strings.constant("isGraalRuntime");
    public static final TruffleString SET_UNHANDLED_PROMISE_REJECTION_HANDLER = Strings.constant("setUnhandledPromiseRejectionHandler");
    public static final TruffleString UC_PACKAGES = Strings.constant("Packages");
    public static final TruffleString JAVA = Strings.constant("java");
    public static final TruffleString JAVAFX = Strings.constant("javafx");
    public static final TruffleString JAVAX = Strings.constant("javax");
    public static final TruffleString COM = Strings.constant("com");
    public static final TruffleString ORG = Strings.constant("org");
    public static final TruffleString EDU = Strings.constant("edu");
    public static final TruffleString CONSOLE = Strings.constant("console");
    public static final TruffleString EXEC = Strings.constant("exec");
    public static final TruffleString READ_FULLY = Strings.constant("readFully");
    public static final TruffleString READ_LINE = Strings.constant("readLine");
    public static final TruffleString $_EXEC = Strings.constant("$EXEC");
    public static final TruffleString $_EXIT = Strings.constant("$EXIT");
    public static final TruffleString $_OUT = Strings.constant("$OUT");
    public static final TruffleString $_ERR = Strings.constant("$ERR");
    public static final TruffleString GLOBAL__LINE__ = Strings.constant("__LINE__");
    public static final TruffleString GLOBAL__FILE__ = Strings.constant("__FILE__");
    public static final TruffleString GLOBAL__DIR__ = Strings.constant("__DIR__");
    public static final TruffleString _TIMEZONE = Strings.constant("_timezone");
    public static final TruffleString _SCRIPTING = Strings.constant("_scripting");
    public static final TruffleString _COMPILE_ONLY = Strings.constant("_compile_only");
    public static final TruffleString $_OPTIONS = Strings.constant("$OPTIONS");
    public static final TruffleString $_ARG = Strings.constant("$ARG");
    public static final TruffleString MEMORY = Strings.constant("memory");
    public static final TruffleString TABLE = Strings.constant("table");
    public static final TruffleString STATUS = Strings.constant("status");
    public static final TruffleString REASON = Strings.constant("reason");
    public static final TruffleString DOT_PROTOTYPE = Strings.constant(".prototype");
    public static final TruffleString EVAL = Strings.constant("eval");
    public static final TruffleString A = Strings.constant("a");
    public static final TruffleString BIG = Strings.constant("big");
    public static final TruffleString BLINK = Strings.constant("blink");
    public static final TruffleString B = Strings.constant("b");
    public static final TruffleString TT = Strings.constant("tt");
    public static final TruffleString FONT = Strings.constant("font");
    public static final TruffleString COLOR = Strings.constant("color");
    public static final TruffleString I = Strings.constant("i");
    public static final TruffleString HREF = Strings.constant("href");
    public static final TruffleString SIZE = Strings.constant("size");
    public static final TruffleString SMALL = Strings.constant("small");
    public static final TruffleString STRIKE = Strings.constant("strike");
    public static final TruffleString SUB = Strings.constant("sub");
    public static final TruffleString SUP = Strings.constant("sup");
    public static final TruffleString TO_STRING_VALUE_NULL = Strings.constant("[object Null]");
    public static final TruffleString TO_STRING_VALUE_UNDEFINED = Strings.constant("[object Undefined]");
    public static final TruffleString TO_STRING_VALUE_ARRAY = Strings.constant("[object Array]");
    public static final TruffleString TO_STRING_VALUE_FUNCTION = Strings.constant("[object Function]");
    public static final TruffleString TO_STRING_VALUE_DATE = Strings.constant("[object Date]");
    public static final TruffleString TO_STRING_VALUE_OBJECT = Strings.constant("[object Object]");
    public static final TruffleString FULFILLED = Strings.constant("fulfilled");
    public static final TruffleString REJECTED = Strings.constant("rejected");
    public static final TruffleString CAPTURE_STACK_TRACE = Strings.constant("captureStackTrace");
    public static final TruffleString JAVA_CLASS_BRACKET = Strings.constant("JavaClass[");
    public static final TruffleString JAVA_OBJECT_BRACKET = Strings.constant("JavaObject[");
    public static final TruffleString RESOLVED = Strings.constant("resolved");
    public static final TruffleString PENDING = Strings.constant("pending");
    public static final TruffleString PROMISE_STATUS = Strings.constant("PromiseStatus");
    public static final TruffleString PROMISE_VALUE = Strings.constant("PromiseValue");
    public static final TruffleString TEST = Strings.constant("test");
    public static final TruffleString UNKNOWN_FILENAME = Strings.constant("<unknown>");
    public static final TruffleString DYNAMIC_FUNCTION_NAME = Strings.constant("anonymous");
    public static final TruffleString ASYNC = Strings.constant("async");
    public static final TruffleString UC_M = Strings.constant("M");
    public static final TruffleString UC_M0 = Strings.constant("M0");
    public static final TruffleString UC_Z = Strings.constant("Z");
    public static final TruffleString Z = Strings.constant("z");
    public static final TruffleString UC_ETC = Strings.constant("Etc");
    public static final TruffleString UNICODE_MINUS_SIGN = Strings.constant("\u2212");
    public static final TruffleString MUTABLE = Strings.constant("mutable");
    public static final TruffleString ELEMENT = Strings.constant("element");
    public static final TruffleString INITIAL = Strings.constant("initial");
    public static final TruffleString MAXIMUM = Strings.constant("maximum");
    public static final TruffleString SHARED = Strings.constant("shared");
    public static final TruffleString STATIC = Strings.constant("static");
    public static final TruffleString PRIVATE = Strings.constant("private");
    public static final TruffleString INIT = Strings.constant("init");
    public static final TruffleString CALENDAR = Strings.constant("calendar");
    public static final TruffleString ERA = Strings.constant("era");
    public static final TruffleString YEAR = Strings.constant("year");
    public static final TruffleString MONTH = Strings.constant("month");
    public static final TruffleString DAY = Strings.constant("day");
    public static final TruffleString HOUR = Strings.constant("hour");
    public static final TruffleString MINUTE = Strings.constant("minute");
    public static final TruffleString SECOND = Strings.constant("second");
    public static final TruffleString UNIT = Strings.constant("unit");
    public static final TruffleString FRACTIONAL_SECOND_DIGITS = Strings.constant("fractionalSecondDigits");
    public static final TruffleString ROUNDING_INCREMENT = Strings.constant("roundingIncrement");
    public static final TruffleString ROUNDING_MODE = Strings.constant("roundingMode");
    public static final TruffleString TIME_ZONE = Strings.constant("timeZone");
    public static final TruffleString TIME_ZONE_NAME = Strings.constant("timeZoneName");

    private Strings() {
    }

    public static boolean isTString(Object string) {
        return string instanceof TruffleString;
    }

    public static TruffleString constant(String s2) {
        TruffleString ret = Strings.fromJavaString(s2);
        ret.hashCodeUncached(TruffleString.Encoding.UTF_16);
        return ret;
    }

    public static TruffleString fromJavaString(String str) {
        return Strings.fromJavaString(TruffleString.FromJavaStringNode.getUncached(), str);
    }

    public static TruffleString fromJavaString(TruffleString.FromJavaStringNode node, String str) {
        return node.execute(str, TruffleString.Encoding.UTF_16);
    }

    public static TruffleString fromLong(long longValue) {
        return Strings.fromLong(TruffleString.FromLongNode.getUncached(), longValue);
    }

    public static TruffleString fromLong(TruffleString.FromLongNode node, long longValue) {
        return node.execute(longValue, TruffleString.Encoding.UTF_16, true);
    }

    public static TruffleString[] fromJavaStringArray(String ... strings) {
        TruffleString[] ret = new TruffleString[strings.length];
        for (int i2 = 0; i2 < strings.length; ++i2) {
            ret[i2] = Strings.fromJavaString(strings[i2]);
        }
        return ret;
    }

    public static int length(TruffleString s2) {
        return s2.byteLength(TruffleString.Encoding.UTF_16) >> 1;
    }

    public static boolean isEmpty(TruffleString s2) {
        return Strings.length(s2) == 0;
    }

    public static char charAt(TruffleString s2, int i2) {
        return Strings.charAt(TruffleString.ReadCharUTF16Node.getUncached(), s2, i2);
    }

    public static char charAt(TruffleString.ReadCharUTF16Node readRawNode, TruffleString s2, int i2) {
        return readRawNode.execute(s2, i2);
    }

    public static int codePointAt(TruffleString.CodePointAtByteIndexNode node, TruffleString s2, int i2) {
        return node.execute(s2, i2 << 1, TruffleString.Encoding.UTF_16);
    }

    public static TruffleString concat(TruffleString s1, TruffleString s2) {
        return Strings.concat(TruffleString.ConcatNode.getUncached(), s1, s2);
    }

    public static TruffleString concat(TruffleString.ConcatNode node, TruffleString s1, TruffleString s2) {
        return node.execute(s1, s2, TruffleString.Encoding.UTF_16, true);
    }

    public static TruffleString concatAll(TruffleString s2, TruffleString ... concat) {
        int len = Strings.length(s2);
        for (TruffleString c2 : concat) {
            len += Strings.length(c2);
        }
        TruffleStringBuilderUTF16 sb = Strings.builderCreate(len);
        TruffleStringBuilder.AppendStringNode.getUncached().execute(sb, s2);
        for (TruffleString c3 : concat) {
            TruffleStringBuilder.AppendStringNode.getUncached().execute(sb, c3);
        }
        return TruffleStringBuilder.ToStringNode.getUncached().execute(sb);
    }

    public static TruffleString lazySubstring(TruffleString s2, int fromIndex) {
        return Strings.lazySubstring(s2, fromIndex, Strings.length(s2) - fromIndex);
    }

    public static TruffleString lazySubstring(TruffleString s2, int fromIndex, int length) {
        return Strings.lazySubstring(TruffleString.SubstringByteIndexNode.getUncached(), s2, fromIndex, length);
    }

    public static TruffleString lazySubstring(TruffleString.SubstringByteIndexNode node, TruffleString s2, int fromIndex, int length) {
        return Strings.substring(true, node, s2, fromIndex, length);
    }

    public static TruffleString substring(JSContext context, TruffleString s2, int fromIndex) {
        return Strings.substring(context, s2, fromIndex, Strings.length(s2) - fromIndex);
    }

    public static TruffleString substring(JSContext context, TruffleString.SubstringByteIndexNode node, TruffleString s2, int fromIndex) {
        return Strings.substring(context, node, s2, fromIndex, Strings.length(s2) - fromIndex);
    }

    public static TruffleString substring(JSContext context, TruffleString s2, int fromIndex, int length) {
        return Strings.substring(context, TruffleString.SubstringByteIndexNode.getUncached(), s2, fromIndex, length);
    }

    public static TruffleString substring(JSContext context, TruffleString.SubstringByteIndexNode node, TruffleString s2, int fromIndex, int length) {
        return Strings.substring(context.getLanguageOptions().stringLazySubstrings(), node, s2, fromIndex, length);
    }

    public static TruffleString substring(boolean lazy, TruffleString.SubstringByteIndexNode node, TruffleString s2, int fromIndex, int length) {
        return length == 0 ? EMPTY_STRING : node.execute(s2, fromIndex << 1, length << 1, TruffleString.Encoding.UTF_16, lazy);
    }

    public static boolean startsWith(TruffleString s1, TruffleString s2) {
        return Strings.startsWith(s1, s2, 0);
    }

    public static boolean startsWith(TruffleString s1, TruffleString s2, int startPos) {
        return Strings.startsWith(TruffleString.RegionEqualByteIndexNode.getUncached(), s1, s2, startPos);
    }

    public static boolean startsWith(TruffleString.RegionEqualByteIndexNode regionEqualsNode, TruffleString s1, TruffleString s2) {
        return Strings.startsWith(regionEqualsNode, s1, s2, 0);
    }

    public static boolean startsWith(TruffleString.RegionEqualByteIndexNode regionEqualsNode, TruffleString s1, TruffleString s2, int startPos) {
        return Strings.length(s1) - startPos >= Strings.length(s2) && Strings.regionEquals(regionEqualsNode, s1, startPos, s2, 0, Strings.length(s2));
    }

    public static boolean regionEquals(TruffleString s1, int offset1, TruffleString s2, int offset2, int length) {
        return Strings.regionEquals(TruffleString.RegionEqualByteIndexNode.getUncached(), s1, offset1, s2, offset2, length);
    }

    public static boolean regionEquals(TruffleString.RegionEqualByteIndexNode regionEqualsNode, TruffleString s1, int offset1, TruffleString s2, int offset2, int length) {
        return regionEqualsNode.execute((AbstractTruffleString)s1, offset1 << 1, s2, offset2 << 1, length << 1, TruffleString.Encoding.UTF_16);
    }

    public static boolean endsWith(TruffleString s1, TruffleString s2) {
        return Strings.endsWith(TruffleString.RegionEqualByteIndexNode.getUncached(), s1, s2);
    }

    public static boolean endsWith(TruffleString.RegionEqualByteIndexNode regionEqualsNode, TruffleString s1, TruffleString s2) {
        return Strings.length(s1) >= Strings.length(s2) && Strings.regionEquals(regionEqualsNode, s1, Strings.length(s1) - Strings.length(s2), s2, 0, Strings.length(s2));
    }

    public static boolean contains(TruffleString s2, char c2) {
        return Strings.indexOf(s2, c2) >= 0;
    }

    public static int indexOf(TruffleString string, char c2) {
        return string.charIndexOfAnyCharUTF16Uncached(0, Strings.length(string), new char[]{c2});
    }

    public static int indexOfAny(TruffleString.CharIndexOfAnyCharUTF16Node node, TruffleString s2, char ... chars) {
        return node.execute(s2, 0, Strings.length(s2), chars);
    }

    public static int indexOf(TruffleString.ByteIndexOfCodePointNode node, TruffleString s2, int codepoint) {
        return Strings.indexOf(node, s2, codepoint, 0);
    }

    public static int indexOf(TruffleString s2, int codepoint, int fromIndex) {
        return Strings.indexOf(TruffleString.ByteIndexOfCodePointNode.getUncached(), s2, codepoint, fromIndex);
    }

    public static int indexOf(TruffleString.ByteIndexOfCodePointNode node, TruffleString s2, int codepoint, int fromIndex) {
        if (fromIndex >= Strings.length(s2)) {
            return -1;
        }
        return node.execute(s2, codepoint, fromIndex << 1, Strings.length(s2) << 1, TruffleString.Encoding.UTF_16) >> 1;
    }

    public static int indexOf(TruffleString s1, TruffleString s2) {
        return Strings.indexOf(s1, s2, 0);
    }

    public static int indexOf(TruffleString.ByteIndexOfStringNode node, TruffleString s1, TruffleString s2) {
        return Strings.indexOf(node, s1, s2, 0);
    }

    public static int indexOf(TruffleString s1, TruffleString s2, int fromIndex) {
        return Strings.indexOf(TruffleString.ByteIndexOfStringNode.getUncached(), s1, s2, fromIndex);
    }

    public static int indexOf(TruffleString s1, TruffleString s2, int fromIndex, int toIndex) {
        return Strings.indexOf(TruffleString.ByteIndexOfStringNode.getUncached(), s1, s2, fromIndex, toIndex);
    }

    public static int indexOf(TruffleString.ByteIndexOfStringNode node, TruffleString s1, TruffleString s2, int fromIndex) {
        return Strings.indexOf(node, s1, s2, fromIndex, Strings.length(s1));
    }

    public static int indexOf(TruffleString.ByteIndexOfStringNode node, TruffleString s1, TruffleString s2, int fromIndex, int toIndex) {
        int fromIndexPos = Math.max(fromIndex, 0);
        if (Strings.length(s2) == 0) {
            return fromIndexPos;
        }
        return Strings.length(s1) - fromIndexPos >= Strings.length(s2) ? node.execute((AbstractTruffleString)s1, s2, fromIndexPos << 1, toIndex << 1, TruffleString.Encoding.UTF_16) >> 1 : -1;
    }

    public static int lastIndexOf(TruffleString.LastByteIndexOfStringNode lastIndexOfNode, TruffleString s1, TruffleString s2, int fromIndex) {
        return lastIndexOfNode.execute((AbstractTruffleString)s1, s2, Math.min(fromIndex + Strings.length(s2), Strings.length(s1)) << 1, 0, TruffleString.Encoding.UTF_16) >> 1;
    }

    public static int lastIndexOf(TruffleString s2, int codePoint) {
        return Strings.lastIndexOf(TruffleString.LastByteIndexOfCodePointNode.getUncached(), s2, codePoint);
    }

    public static int lastIndexOf(TruffleString.LastByteIndexOfCodePointNode node, TruffleString s2, int codePoint) {
        return node.execute(s2, codePoint, Strings.length(s2) << 1, 0, TruffleString.Encoding.UTF_16) >> 1;
    }

    public static boolean equals(TruffleString s1, TruffleString s2) {
        return Strings.equals(TruffleString.EqualNode.getUncached(), s1, s2);
    }

    public static boolean equals(TruffleString.EqualNode node, TruffleString s1, TruffleString s2) {
        return node.execute(s1, s2, TruffleString.Encoding.UTF_16);
    }

    public static TruffleString replace(TruffleString s2, TruffleString search, TruffleString replace) {
        int pos = Strings.indexOf(s2, search);
        if (pos < 0) {
            return s2;
        }
        if (Strings.length(s2) == Strings.length(search)) {
            return replace;
        }
        TruffleStringBuilderUTF16 sb = Strings.builderCreate(Strings.length(s2));
        int lastEndPos = 0;
        do {
            Strings.builderAppend(sb, s2, lastEndPos, pos);
            Strings.builderAppend(sb, replace);
        } while ((pos = Strings.indexOf(s2, search, lastEndPos = pos + Strings.length(search))) >= 0);
        Strings.builderAppend(sb, s2, lastEndPos, Strings.length(s2));
        return Strings.builderToString(sb);
    }

    public static int compareTo(TruffleString a2, TruffleString b2) {
        return TruffleString.CompareCharsUTF16Node.getUncached().execute(a2, b2);
    }

    public static int compareTo(TruffleString.CompareCharsUTF16Node node, TruffleString a2, TruffleString b2) {
        return node.execute(a2, b2);
    }

    public static String toJavaString(TruffleString s2) {
        return Strings.toJavaString(TruffleString.ToJavaStringNode.getUncached(), s2);
    }

    public static String toJavaString(TruffleString.ToJavaStringNode node, TruffleString s2) {
        return node.execute(s2);
    }

    public static TruffleString toUpperCase(TruffleString s2, Locale locale) {
        return Strings.fromJavaString(Strings.javaStringToUpperCase(Strings.toJavaString(s2), locale));
    }

    @CompilerDirectives.TruffleBoundary
    public static String javaStringToLowerCase(String s2, Locale locale) {
        return s2.toLowerCase(locale);
    }

    @CompilerDirectives.TruffleBoundary
    public static String javaStringToUpperCase(String s2, Locale locale) {
        return s2.toUpperCase(locale);
    }

    public static TruffleString lazyTrim(TruffleString s2) {
        int start;
        int end = Strings.length(s2);
        for (start = 0; start < end && Strings.charAt(s2, start) <= ' '; ++start) {
        }
        while (start < end && Strings.charAt(s2, end - 1) <= ' ') {
            --end;
        }
        return start > 0 || end < Strings.length(s2) ? Strings.lazySubstring(s2, start, end - start) : s2;
    }

    public static long parseLong(TruffleString s2) throws TruffleString.NumberFormatException {
        return Strings.parseLong(s2, 10);
    }

    public static long parseLong(TruffleString s2, int radix) throws TruffleString.NumberFormatException {
        return Strings.parseLong(TruffleString.ParseLongNode.getUncached(), s2, radix);
    }

    public static long parseLong(TruffleString.ParseLongNode node, TruffleString s2, int radix) throws TruffleString.NumberFormatException {
        return node.execute(s2, radix);
    }

    public static double parseDouble(TruffleString s2) throws TruffleString.NumberFormatException {
        return Strings.parseDouble(TruffleString.ParseDoubleNode.getUncached(), s2);
    }

    public static double parseDouble(TruffleString.ParseDoubleNode node, TruffleString s2) throws TruffleString.NumberFormatException {
        return node.execute(s2);
    }

    public static TruffleString fromCodePoint(TruffleString.FromCodePointNode node, int c2) {
        assert (c2 >= 0);
        return node.execute(c2, TruffleString.Encoding.UTF_16, true);
    }

    public static TruffleString fromBoolean(boolean b2) {
        return b2 ? TRUE : FALSE;
    }

    public static TruffleString fromInt(int intValue) {
        return Strings.fromLong(intValue);
    }

    public static TruffleString fromDouble(double d2) {
        return TruffleString.FromJavaStringNode.getUncached().execute(Strings.doubleToJavaString(d2), TruffleString.Encoding.UTF_16);
    }

    @CompilerDirectives.TruffleBoundary
    private static String doubleToJavaString(double d2) {
        return String.valueOf(d2);
    }

    public static TruffleString fromNumber(Number number) {
        if (number instanceof Integer) {
            return Strings.fromInt(number.intValue());
        }
        if (number instanceof Long) {
            return Strings.fromLong(number.longValue());
        }
        if (number instanceof Double) {
            return Strings.fromDouble(number.doubleValue());
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public static TruffleString fromBigInt(BigInt bi) {
        return Strings.fromJavaString(bi.toString());
    }

    public static TruffleString fromBigInt(BigInt bi, int radix) {
        return Strings.fromJavaString(bi.toString(radix));
    }

    public static TruffleString fromObject(Object o2) {
        return Strings.fromJavaString(Strings.objectToJavaString(o2));
    }

    @CompilerDirectives.TruffleBoundary
    private static String objectToJavaString(Object o2) {
        return String.valueOf(o2);
    }

    public static TruffleString fromCharArray(TruffleString.FromCharArrayUTF16Node node, char[] chars) {
        return Strings.fromCharArray(node, chars, 0, chars.length);
    }

    public static TruffleString fromCharArray(char[] chars, int fromIndex, int length) {
        return Strings.fromCharArray(TruffleString.FromCharArrayUTF16Node.getUncached(), chars, fromIndex, length);
    }

    public static TruffleString fromCharArray(TruffleString.FromCharArrayUTF16Node node, char[] chars, int fromIndex, int length) {
        return node.execute(chars, fromIndex, length);
    }

    public static TruffleString flatten(TruffleString.MaterializeNode materializeNode, TruffleString value) {
        materializeNode.execute(value, TruffleString.Encoding.UTF_16);
        return value;
    }

    public static String interopAsString(Object key) throws UnsupportedMessageException {
        return Strings.interopAsString(InteropLibrary.getUncached(), key);
    }

    public static String interopAsString(InteropLibrary stringInterop, Object key) throws UnsupportedMessageException {
        return key instanceof String ? (String)key : stringInterop.asString(key);
    }

    public static TruffleString interopAsTruffleString(Object key) {
        return Strings.interopAsTruffleString(key, InteropLibrary.getUncached(), TruffleString.SwitchEncodingNode.getUncached());
    }

    public static TruffleString interopAsTruffleString(Object key, InteropLibrary stringInterop) {
        return Strings.interopAsTruffleString(key, stringInterop, TruffleString.SwitchEncodingNode.getUncached());
    }

    public static TruffleString interopAsTruffleString(Object key, InteropLibrary stringInterop, TruffleString.SwitchEncodingNode switchEncodingNode) {
        TruffleString truffleString;
        assert (stringInterop.isString(key)) : key;
        if (key instanceof TruffleString) {
            truffleString = (TruffleString)key;
        } else {
            try {
                truffleString = stringInterop.asTruffleString(key);
            }
            catch (UnsupportedMessageException e2) {
                throw Errors.createTypeErrorInteropException(key, e2, "asTruffleString", stringInterop);
            }
        }
        return switchEncodingNode.execute(truffleString, TruffleString.Encoding.UTF_16);
    }

    public static BigInt parseBigInt(TruffleString s2) {
        return BigInt.valueOf(Strings.toJavaString(s2));
    }

    public static BigInteger parseBigInteger(TruffleString s2, int radix) {
        return new BigInteger(Strings.toJavaString(s2), radix);
    }

    public static TruffleStringBuilderUTF16 builderCreate() {
        return TruffleStringBuilder.createUTF16();
    }

    public static TruffleStringBuilderUTF16 builderCreate(int capacity) {
        return TruffleStringBuilder.createUTF16(capacity);
    }

    public static void builderAppend(TruffleStringBuilderUTF16 sb, char chr) {
        TruffleStringBuilder.AppendCharUTF16Node.getUncached().execute(sb, chr);
    }

    public static void builderAppend(TruffleStringBuilder.AppendCharUTF16Node node, TruffleStringBuilderUTF16 sb, char chr) {
        node.execute(sb, chr);
    }

    public static void builderAppend(TruffleStringBuilderUTF16 sb, int i2) {
        TruffleStringBuilder.AppendIntNumberNode.getUncached().execute(sb, i2);
    }

    public static void builderAppend(TruffleStringBuilder.AppendIntNumberNode node, TruffleStringBuilderUTF16 sb, int i2) {
        node.execute(sb, i2);
    }

    public static void builderAppend(TruffleStringBuilderUTF16 sb, long i2) {
        TruffleStringBuilder.AppendLongNumberNode.getUncached().execute(sb, i2);
    }

    public static void builderAppend(TruffleStringBuilder.AppendLongNumberNode node, TruffleStringBuilderUTF16 sb, long i2) {
        node.execute(sb, i2);
    }

    public static void builderAppend(TruffleStringBuilderUTF16 sb, String str) {
        TruffleStringBuilder.AppendJavaStringUTF16Node.getUncached().execute(sb, str, 0, str.length());
    }

    public static void builderAppend(TruffleStringBuilderUTF16 sb, TruffleString str) {
        Strings.builderAppendLen(sb, str, 0, Strings.length(str));
    }

    public static void builderAppend(TruffleStringBuilder.AppendStringNode node, TruffleStringBuilderUTF16 sb, TruffleString str) {
        node.execute(sb, str);
    }

    public static void builderAppend(TruffleStringBuilderUTF16 sb, TruffleString str, int start, int end) {
        Strings.builderAppendLen(sb, str, start, end - start);
    }

    public static void builderAppend(TruffleStringBuilder.AppendSubstringByteIndexNode node, TruffleStringBuilderUTF16 sb, TruffleString str, int start, int end) {
        Strings.builderAppendLen(node, sb, str, start, end - start);
    }

    public static void builderAppendLen(TruffleStringBuilderUTF16 sb, TruffleString str, int start, int len) {
        Strings.builderAppendLen(TruffleStringBuilder.AppendSubstringByteIndexNode.getUncached(), sb, str, start, len);
    }

    public static void builderAppendLen(TruffleStringBuilder.AppendSubstringByteIndexNode node, TruffleStringBuilderUTF16 sb, TruffleString str, int start, int len) {
        node.execute(sb, str, start << 1, len << 1);
    }

    public static TruffleString builderToString(TruffleStringBuilderUTF16 sb) {
        return Strings.builderToString(TruffleStringBuilder.ToStringNode.getUncached(), sb);
    }

    public static TruffleString builderToString(TruffleStringBuilder.ToStringNode node, TruffleStringBuilderUTF16 sb) {
        return node.execute(sb);
    }

    public static String builderToJavaString(TruffleStringBuilderUTF16 sb) {
        return Strings.toJavaString(Strings.builderToString(sb));
    }

    public static int builderLength(TruffleStringBuilderUTF16 sb) {
        return sb.byteLength() >> 1;
    }

    public static TruffleString[] convertJavaStringArray(String[] array) {
        TruffleString[] ret = new TruffleString[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            ret[i2] = Strings.fromJavaString(array[i2]);
        }
        return ret;
    }

    public static TruffleString addBrackets(TruffleString str) {
        return Strings.concatAll(BRACKET_OPEN, str, BRACKET_CLOSE);
    }

    public static TruffleString format(String formatString, Object ... args) {
        return Strings.fromJavaString(String.format(formatString, args));
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString[] split(JSContext context, TruffleString str, TruffleString delimiter) {
        if (Strings.isEmpty(str)) {
            return new TruffleString[0];
        }
        int pos = Strings.indexOf(str, delimiter);
        if (pos < 0) {
            return new TruffleString[]{str};
        }
        ArrayList<TruffleString> ret = new ArrayList<TruffleString>();
        int lastEnd = 0;
        do {
            ret.add(Strings.substring(context, str, lastEnd, pos - lastEnd));
        } while ((pos = Strings.indexOf(str, delimiter, lastEnd = pos + Strings.length(delimiter))) >= 0);
        ret.add(Strings.substring(context, str, lastEnd, Strings.length(str) - lastEnd));
        return ret.toArray(new TruffleString[0]);
    }
}

