/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import java.util.Arrays;
import java.util.StringJoiner;

public class SimpleArrayList<E> {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CAPACITY = 8;
    private Object[] elements;
    private int size;

    public SimpleArrayList() {
        this(8);
    }

    public SimpleArrayList(int capacity) {
        this.elements = capacity != 0 ? new Object[capacity] : ScriptArray.EMPTY_OBJECT_ARRAY;
    }

    public static <E> SimpleArrayList<E> create(long maxAssumedLength) {
        return new SimpleArrayList<E>((int)Math.min(maxAssumedLength, 100L));
    }

    public static <E> SimpleArrayList<E> createEmpty() {
        return new SimpleArrayList<E>(0);
    }

    public void add(E e2, Node node, InlinedBranchProfile growProfile) {
        this.ensureCapacity(this.size + 1, node, growProfile);
        this.elements[this.size++] = e2;
    }

    public void addUncached(E e2) {
        this.ensureCapacity(this.size + 1, null, InlinedBranchProfile.getUncached());
        this.elements[this.size++] = e2;
    }

    public void addUnchecked(E e2) {
        this.elements[this.size++] = e2;
    }

    public E get(int index) {
        assert (index < this.size) : "out of bounds";
        return (E)this.elements[index];
    }

    public void set(int index, E elem) {
        assert (index < this.size) : "out of bounds";
        this.elements[index] = elem;
    }

    public Object pop() {
        assert (this.size > 0);
        return this.elements[--this.size];
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    public <T> T[] toArray(T[] a2) {
        if (a2.length < this.size) {
            return Arrays.copyOf(this.elements, this.size, a2.getClass());
        }
        System.arraycopy(this.elements, 0, a2, 0, this.size);
        if (a2.length > this.size) {
            a2[this.size] = null;
        }
        return a2;
    }

    private void ensureCapacity(int minCapacity, Node node, InlinedBranchProfile growProfile) {
        if (CompilerDirectives.injectBranchProbability(0.25, this.elements.length < minCapacity)) {
            growProfile.enter(node);
            this.ensureCapacityIntl(minCapacity);
        }
    }

    private void ensureCapacityIntl(int minCapacity) throws OutOfMemoryError {
        long curCapacity = this.elements.length;
        long newCapacity = curCapacity + (curCapacity >> 1);
        if (newCapacity < (long)minCapacity) {
            newCapacity = minCapacity;
        }
        if (newCapacity < 8L) {
            newCapacity = 8L;
        }
        if (newCapacity > 0x7FFFFFF7L) {
            if (0x7FFFFFF7 < minCapacity) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.outOfMemoryError();
            }
            newCapacity = 0x7FFFFFF7L;
        }
        this.elements = Arrays.copyOf(this.elements, (int)newCapacity);
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (Object element : this.elements) {
            sj.add(String.valueOf(element));
        }
        return sj.toString();
    }
}

