/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSMessageEndpoint;
import com.oracle.truffle.polyglot.enterprise.HSMessageEndpointGen;
import com.oracle.truffle.polyglot.enterprise.HSMessageTransport;
import com.oracle.truffle.polyglot.enterprise.NativeMessageEndpointGen;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.net.URI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNICalls;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIClassCache;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolate;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObjectHandles;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.CurrentIsolate;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.UnmanagedMemory;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io.MessageEndpoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io.MessageTransport;

final class HSMessageTransportGen {
    HSMessageTransportGen() {
    }

    static HSMessageTransport createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSMessageTransport {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<URI> uRIMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MessageEndpoint open(URI uRI, MessageEndpoint messageEndpoint) throws IOException, MessageTransport.VetoException {
            HSMessageEndpoint hSMessageEndpoint;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = uRIMarshaller.inferSize(uRI);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        uRIMarshaller.write((BinaryOutput)object, uRI);
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(4, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setLong(CurrentIsolate.getIsolate().rawValue());
                    object.addressOf(2).setLong(NativeObjectHandles.create(messageEndpoint));
                    object.addressOf(3).setJObject(jByteArray);
                    Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.openMethod, (JNI.JValue)object);
                    HSMessageEndpoint hSMessageEndpoint2 = hSMessageEndpoint = r2.isNonNull() ? HSMessageEndpointGen.createNativeToHS(jNIEnv, r2) : null;
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return hSMessageEndpoint;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            uRIMarshaller = jNIConfig.lookupMarshaller(URI.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod openMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass(jNIEnv, EndPoint.class);
                this.openMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "open", "(Lorg/graalvm/polyglot/io/MessageTransport;JJ[B)Lorg/graalvm/polyglot/io/MessageEndpoint;");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<URI> uRIMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static MessageEndpoint open(MessageTransport messageTransport, long l2, long l3, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                URI uRI = uRIMarshaller.read(binaryInput);
                MessageEndpoint messageEndpoint = messageTransport.open(uRI, l3 != 0L ? NativeMessageEndpointGen.create(NativeIsolate.get(l2), l3) : null);
                return messageEndpoint;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            uRIMarshaller = jNIConfig.lookupMarshaller(URI.class, new Class[0]);
        }
    }
}

