/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.util;

import com.oracle.truffle.regex.util.Abstract128BitSet;

public final class Immutable128BitSet
extends Abstract128BitSet {
    private final long lo;
    private final long hi;

    public static Immutable128BitSet create(int ... values) {
        long lo = 0L;
        long hi = 0L;
        for (int v2 : values) {
            assert (v2 < 128);
            if (v2 >= 64) {
                hi |= 1L << v2;
                continue;
            }
            lo |= 1L << v2;
        }
        return new Immutable128BitSet(lo, hi);
    }

    public static Immutable128BitSet createDirect(long lo, long hi) {
        return new Immutable128BitSet(lo, hi);
    }

    Immutable128BitSet(long lo, long hi) {
        this.lo = lo;
        this.hi = hi;
    }

    @Override
    public long getLo() {
        return this.lo;
    }

    @Override
    public long getHi() {
        return this.hi;
    }

    public static Immutable128BitSet getEmpty() {
        return new Immutable128BitSet(0L, 0L);
    }

    public static Immutable128BitSet getFull() {
        return new Immutable128BitSet(-1L, -1L);
    }

    public Immutable128BitSet set(int b2) {
        assert (b2 < 128);
        return b2 < 64 ? new Immutable128BitSet(this.lo | Immutable128BitSet.toBit(b2), this.hi) : new Immutable128BitSet(this.lo, this.hi | Immutable128BitSet.toBit(b2));
    }

    public Immutable128BitSet clear(int b2) {
        assert (b2 < 128);
        return b2 < 64 ? new Immutable128BitSet(this.lo & (Immutable128BitSet.toBit(b2) ^ 0xFFFFFFFFFFFFFFFFL), this.hi) : new Immutable128BitSet(this.lo, this.hi & (Immutable128BitSet.toBit(b2) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public Immutable128BitSet invert() {
        return new Immutable128BitSet(this.lo ^ 0xFFFFFFFFFFFFFFFFL, this.hi ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Immutable128BitSet intersect(Immutable128BitSet other) {
        return new Immutable128BitSet(this.lo & other.lo, this.hi & other.hi);
    }

    public Immutable128BitSet subtract(Immutable128BitSet other) {
        return new Immutable128BitSet(this.lo & (other.lo ^ 0xFFFFFFFFFFFFFFFFL), this.hi & (other.hi ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public Immutable128BitSet union(Immutable128BitSet other) {
        return new Immutable128BitSet(this.lo | other.lo, this.hi | other.hi);
    }

    public IntersectAndSubtractResult intersectAndSubtract(Immutable128BitSet o2) {
        long intersectionLo = this.lo & o2.lo;
        long intersectionHi = this.hi & o2.hi;
        return new IntersectAndSubtractResult(new Immutable128BitSet(this.lo & (intersectionLo ^ 0xFFFFFFFFFFFFFFFFL), this.hi & (intersectionHi ^ 0xFFFFFFFFFFFFFFFFL)), new Immutable128BitSet(o2.lo & (intersectionLo ^ 0xFFFFFFFFFFFFFFFFL), o2.hi & (intersectionHi ^ 0xFFFFFFFFFFFFFFFFL)), new Immutable128BitSet(intersectionLo, intersectionHi));
    }

    public static final class IntersectAndSubtractResult {
        public final Immutable128BitSet subtractedA;
        public final Immutable128BitSet subtractedB;
        public final Immutable128BitSet intersection;

        public IntersectAndSubtractResult(Immutable128BitSet subtractedA, Immutable128BitSet subtractedB, Immutable128BitSet intersection) {
            this.subtractedA = subtractedA;
            this.subtractedB = subtractedB;
            this.intersection = intersection;
        }
    }
}

