/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.OptimizationFailedException;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.AbstractAssumption;
import com.oracle.truffle.api.impl.AbstractFastThreadLocal;
import com.oracle.truffle.api.impl.FrameWithoutBoxing;
import com.oracle.truffle.api.impl.TVMCI;
import com.oracle.truffle.api.impl.ThreadLocalHandshake;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.LayoutFactory;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.compiler.ConstantFieldInfo;
import com.oracle.truffle.compiler.HostMethodInfo;
import com.oracle.truffle.compiler.OptimizedAssumptionDependency;
import com.oracle.truffle.compiler.PartialEvaluationMethodInfo;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationSupport;
import com.oracle.truffle.compiler.TruffleCompiler;
import com.oracle.truffle.compiler.TruffleCompilerOptionDescriptor;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import com.oracle.truffle.runtime.AbstractCompilationTask;
import com.oracle.truffle.runtime.BackgroundCompileQueue;
import com.oracle.truffle.runtime.BaseOSRRootNode;
import com.oracle.truffle.runtime.CompilationState;
import com.oracle.truffle.runtime.CompilationTask;
import com.oracle.truffle.runtime.EngineCacheSupport;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.FixedPointMath;
import com.oracle.truffle.runtime.FloodControlHandler;
import com.oracle.truffle.runtime.InlineDecision;
import com.oracle.truffle.runtime.LoopNodeFactory;
import com.oracle.truffle.runtime.ModuleUtil;
import com.oracle.truffle.runtime.OptimizedAssumption;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedDirectCallNode;
import com.oracle.truffle.runtime.OptimizedFrameInstance;
import com.oracle.truffle.runtime.OptimizedOSRFrameInstance;
import com.oracle.truffle.runtime.OptimizedRuntimeAccessor;
import com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import com.oracle.truffle.runtime.OptimizedRuntimeServiceProvider;
import com.oracle.truffle.runtime.OptimizedTVMCI;
import com.oracle.truffle.runtime.OptimizedTestTVMCI;
import com.oracle.truffle.runtime.OptimizedTruffleRuntimeListener;
import com.oracle.truffle.runtime.OptimizedTruffleRuntimeListenerDispatcher;
import com.oracle.truffle.runtime.TruffleCallBoundary;
import com.oracle.truffle.runtime.TruffleSplittingStrategy;
import com.oracle.truffle.runtime.TruffleTypes;
import com.oracle.truffle.runtime.debug.JFRListener;
import com.oracle.truffle.runtime.debug.StatisticsListener;
import com.oracle.truffle.runtime.debug.TraceASTCompilationListener;
import com.oracle.truffle.runtime.debug.TraceCompilationListener;
import com.oracle.truffle.runtime.debug.TraceCompilationPolymorphismListener;
import com.oracle.truffle.runtime.debug.TraceSplittingListener;
import com.oracle.truffle.runtime.serviceprovider.TruffleRuntimeServices;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.stack.InspectedFrame;
import jdk.vm.ci.code.stack.InspectedFrameVisitor;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.services.Services;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.UnmodifiableEconomicMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.home.Version;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageInfo;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionCategory;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptor;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptors;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionKey;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionStability;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionType;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionValues;

public abstract class OptimizedTruffleRuntime
implements TruffleRuntime,
TruffleCompilerRuntime {
    private static final int JAVA_SPECIFICATION_VERSION = Runtime.version().feature();
    public static final Version MIN_COMPILER_VERSION = Version.create(23, 1, 2);
    public static final int MIN_JDK_VERSION = 21;
    public static final int MAX_JDK_VERSION = 25;
    public static final Version NEXT_VERSION_UPDATE = Version.create(25, 1);
    private final OptimizedTruffleRuntimeListenerDispatcher listeners = new OptimizedTruffleRuntimeListenerDispatcher();
    protected volatile TruffleCompiler truffleCompiler;
    protected volatile OptimizedCallTarget initializeCallTarget;
    protected KnownMethods knownMethods;
    private final OptimizedTVMCI tvmci = new OptimizedTVMCI();
    private volatile OptimizedTestTVMCI testTvmci;
    private final LoopNodeFactory loopNodeFactory;
    private EngineCacheSupport engineCacheSupport;
    private final UnmodifiableEconomicMap<String, Class<?>> lookupTypes;
    private final FloodControlHandler floodControlHandler;
    private final List<OptionDescriptors> runtimeOptionDescriptors;
    protected volatile OptionDescriptors engineOptions;
    protected final TruffleCompilationSupport compilationSupport;
    private OptionDescriptors previousEngineCacheSupportOptions;
    private int compilationThresholdScale = FixedPointMath.toFixedPoint(1.0);

    protected void clearState() {
        assert (TruffleOptions.AOT) : "Must be called only in AOT mode.";
        this.knownMethods = null;
    }

    public static OptimizedTruffleRuntime getRuntime() {
        return (OptimizedTruffleRuntime)Truffle.getRuntime();
    }

    public OptimizedTruffleRuntime(TruffleCompilationSupport compilationSupport, Iterable<Class<?>> extraLookupTypes) {
        this.compilationSupport = compilationSupport;
        this.lookupTypes = OptimizedTruffleRuntime.initLookupTypes(extraLookupTypes);
        ArrayList<OptionDescriptors> options = new ArrayList<OptionDescriptors>();
        this.loopNodeFactory = OptimizedTruffleRuntime.loadGraalRuntimeServiceProvider(LoopNodeFactory.class, options, true);
        EngineCacheSupport support = this.loadEngineCacheSupport(options);
        this.engineCacheSupport = support == null ? new EngineCacheSupport.Disabled() : support;
        this.previousEngineCacheSupportOptions = this.engineCacheSupport.getEngineOptions();
        options.add(OptimizedRuntimeOptions.getDescriptors());
        options.add(new CompilerOptionsDescriptors());
        this.runtimeOptionDescriptors = options;
        this.floodControlHandler = OptimizedTruffleRuntime.loadGraalRuntimeServiceProvider(FloodControlHandler.class, null, false);
    }

    public final void initializeEngineCacheSupport(EngineCacheSupport support) {
        OptionDescriptors engineCacheOptions;
        this.runtimeOptionDescriptors.remove(this.previousEngineCacheSupportOptions);
        this.engineCacheSupport = support;
        this.previousEngineCacheSupportOptions = engineCacheOptions = support.getEngineOptions();
        this.runtimeOptionDescriptors.add(engineCacheOptions);
    }

    protected EngineCacheSupport loadEngineCacheSupport(List<OptionDescriptors> options) {
        return OptimizedTruffleRuntime.loadGraalRuntimeServiceProvider(EngineCacheSupport.class, options, false);
    }

    public abstract ThreadLocalHandshake getThreadLocalHandshake();

    @Override
    public String getName() {
        String compilerConfigurationName;
        return switch (compilerConfigurationName = String.valueOf(this.getCompilerConfigurationName())) {
            case "community" -> "GraalVM CE";
            case "enterprise" -> "Oracle GraalVM";
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("unexpected compiler configuration name: " + compilerConfigurationName));
                }
                yield "GraalVM " + compilerConfigurationName;
            }
        };
    }

    public final Iterable<Class<?>> getLookupTypes() {
        return this.lookupTypes.getValues();
    }

    public final String getCompilerConfigurationName() {
        return this.compilationSupport.getCompilerConfigurationName(this);
    }

    public abstract TruffleCompiler getTruffleCompiler(TruffleCompilable var1);

    public final TruffleCompilerOptionDescriptor[] listCompilerOptions() {
        return this.compilationSupport.listCompilerOptions();
    }

    public final boolean existsCompilerOption(String key) {
        return this.compilationSupport.compilerOptionExists(key);
    }

    public final String validateCompilerOption(String key, String value) {
        return this.compilationSupport.validateCompilerOption(key, value);
    }

    protected OptimizedTVMCI getTvmci() {
        return this.tvmci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TVMCI.Test<?, ?> getTestTvmci() {
        if (this.testTvmci == null) {
            OptimizedTruffleRuntime optimizedTruffleRuntime = this;
            synchronized (optimizedTruffleRuntime) {
                if (this.testTvmci == null) {
                    this.testTvmci = new OptimizedTestTVMCI();
                }
            }
        }
        return this.testTvmci;
    }

    @Override
    public TruffleCompilable asCompilableTruffleAST(JavaConstant constant) {
        return this.asObject(OptimizedCallTarget.class, constant);
    }

    @Override
    public Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumptionConstant) {
        OptimizedAssumption optimizedAssumption = this.asObject(OptimizedAssumption.class, optimizedAssumptionConstant);
        return optimizedAssumption.registerDependency();
    }

    protected abstract JavaConstant forObject(Object var1);

    protected abstract <T> T asObject(Class<T> var1, JavaConstant var2);

    public final TruffleCompiler newTruffleCompiler() {
        return this.compilationSupport.createCompiler(this);
    }

    private static <T> T loadServiceProvider(Class<T> clazz, boolean failIfNotFound) {
        Iterable<T> providers = ImageInfo.inImageBuildtimeCode() ? ServiceLoader.load(clazz) : TruffleRuntimeServices.load(clazz);
        boolean priorityService = OptimizedRuntimeServiceProvider.class.isAssignableFrom(clazz);
        T bestFactory = null;
        int bestPriority = 0;
        for (T factory : providers) {
            int currentPriority = priorityService ? ((OptimizedRuntimeServiceProvider)factory).getPriority() : 0;
            if (bestFactory != null && currentPriority <= bestPriority) continue;
            bestFactory = factory;
            bestPriority = currentPriority;
        }
        if (bestFactory == null && failIfNotFound) {
            throw new IllegalStateException("Unable to load a factory for " + clazz.getName());
        }
        return bestFactory;
    }

    private static <T extends OptimizedRuntimeServiceProvider> T loadGraalRuntimeServiceProvider(Class<T> clazz, List<OptionDescriptors> descriptors, boolean failIfNotFound) {
        OptionDescriptors serviceOptions;
        OptimizedRuntimeServiceProvider bestFactory = (OptimizedRuntimeServiceProvider)OptimizedTruffleRuntime.loadServiceProvider(clazz, failIfNotFound);
        if (descriptors != null && bestFactory != null && (serviceOptions = bestFactory.getEngineOptions()) != null) {
            descriptors.add(serviceOptions);
        }
        return (T)bestFactory;
    }

    @Override
    public ConstantFieldInfo getConstantFieldInfo(ResolvedJavaField field) {
        if (field.isAnnotationPresent(Node.Child.class)) {
            return ConstantFieldInfo.CHILD;
        }
        if (field.isAnnotationPresent(Node.Children.class)) {
            return ConstantFieldInfo.CHILDREN;
        }
        CompilerDirectives.CompilationFinal cf = (CompilerDirectives.CompilationFinal)field.getAnnotation(CompilerDirectives.CompilationFinal.class);
        if (cf != null) {
            int dimensions = OptimizedTruffleRuntime.actualStableDimensions(field, cf.dimensions());
            return ConstantFieldInfo.forDimensions(dimensions);
        }
        return null;
    }

    private static int actualStableDimensions(ResolvedJavaField field, int dimensions) {
        if (dimensions == 0) {
            return 0;
        }
        int arrayDim = OptimizedTruffleRuntime.getArrayDimensions(field.getType());
        if (dimensions < 0) {
            if (dimensions != -1) {
                throw new IllegalArgumentException("Negative @CompilationFinal dimensions");
            }
            return arrayDim;
        }
        if (dimensions > arrayDim) {
            throw new IllegalArgumentException(String.format("@CompilationFinal(dimensions=%d) exceeds declared array dimensions (%d) of field %s", dimensions, arrayDim, field));
        }
        return dimensions;
    }

    private static int getArrayDimensions(JavaType type) {
        int dimensions = 0;
        JavaType componentType = type;
        while (componentType.isArray()) {
            ++dimensions;
            componentType = componentType.getComponentType();
        }
        return dimensions;
    }

    private static UnmodifiableEconomicMap<String, Class<?>> initLookupTypes(Iterable<Class<?>> extraTypes) {
        EconomicMap<String, Class<?>> m2 = EconomicMap.create();
        for (Class c2 : new Class[]{Node.class, RootNode.class, UnexpectedResultException.class, SlowPathException.class, OptimizedCallTarget.class, OptimizedDirectCallNode.class, OptimizedAssumption.class, HostCompilerDirectives.class, CompilerDirectives.class, InlineDecision.class, CompilerAsserts.class, ExactMath.class, ArrayUtils.class, FrameDescriptor.class, FrameSlotKind.class, MethodHandle.class, ArrayList.class, AbstractAssumption.class, VirtualFrame.class, MaterializedFrame.class, CompilationState.class, FrameWithoutBoxing.class, BranchProfile.class, ConditionProfile.class, Objects.class, TruffleSafepoint.class, BaseOSRRootNode.class, TruffleString.class, AbstractTruffleString.class, AssertionError.class, Buffer.class, Shape.class, InstalledCode.class, DynamicObject.class, InlineSupport.InlinableField.class, InlineSupport.StateField.class, InlineSupport.BooleanField.class, InlineSupport.ByteField.class, InlineSupport.ShortField.class, InlineSupport.IntField.class, InlineSupport.CharField.class, InlineSupport.FloatField.class, InlineSupport.LongField.class, InlineSupport.DoubleField.class, InlineSupport.ReferenceField.class}) {
            m2.put(c2.getName(), c2);
        }
        FrameSlotKind.values();
        for (Class clazz : extraTypes) {
            m2.put(clazz.getName(), clazz);
        }
        for (TruffleTypes truffleTypes : TruffleRuntimeServices.load(TruffleTypes.class)) {
            for (Class<?> c4 : truffleTypes.getTypes()) {
                m2.put(c4.getName(), c4);
            }
        }
        if (JAVA_SPECIFICATION_VERSION >= 16 && JAVA_SPECIFICATION_VERSION < 19) {
            String className = "jdk.internal.access.foreign.MemorySegmentProxy";
            try {
                Class<?> clazz = Class.forName(className);
                m2.put(clazz.getName(), clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(className);
            }
        } else if (JAVA_SPECIFICATION_VERSION >= 19) {
            for (String className : new String[]{"jdk.internal.misc.ScopedMemoryAccess$ScopedAccessError", "jdk.internal.foreign.AbstractMemorySegmentImpl"}) {
                try {
                    Class<?> c6 = Class.forName(className);
                    m2.put(c6.getName(), c6);
                }
                catch (ClassNotFoundException e3) {
                    throw new NoClassDefFoundError(className);
                }
            }
        }
        for (String className : new String[]{"com.oracle.truffle.api.strings.TStringOps", "com.oracle.truffle.object.UnsafeAccess"}) {
            try {
                Class<?> c7 = Class.forName(className);
                m2.put(c7.getName(), c7);
            }
            catch (ClassNotFoundException e4) {
                throw new NoClassDefFoundError(className);
            }
        }
        return m2;
    }

    @Override
    public ResolvedJavaType resolveType(MetaAccessProvider metaAccess, String className, boolean required) {
        Class<?> c2 = this.lookupTypes.get(className);
        if (c2 == null) {
            if (!required) {
                return null;
            }
            throw new NoClassDefFoundError(className);
        }
        ResolvedJavaType type = metaAccess.lookupJavaType(c2);
        type.link();
        return type;
    }

    protected void installDefaultListeners() {
        TraceCompilationListener.install(this);
        TraceCompilationPolymorphismListener.install(this);
        TraceSplittingListener.install(this);
        StatisticsListener.install(this);
        TraceASTCompilationListener.install(this);
        JFRListener.install(this);
        TruffleSplittingStrategy.installListener(this);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public HostMethodInfo getHostMethodInfo(ResolvedJavaMethod method) {
        return new HostMethodInfo(OptimizedTruffleRuntime.isTruffleBoundary(method), OptimizedTruffleRuntime.isBytecodeInterpreterSwitch(method), OptimizedTruffleRuntime.isBytecodeInterpreterSwitchBoundary(method), OptimizedTruffleRuntime.isInliningCutoff(method));
    }

    private static boolean isBytecodeInterpreterSwitch(ResolvedJavaMethod method) {
        return OptimizedTruffleRuntime.getAnnotation(HostCompilerDirectives.BytecodeInterpreterSwitch.class, method) != null;
    }

    private static boolean isInliningCutoff(ResolvedJavaMethod method) {
        return OptimizedTruffleRuntime.getAnnotation(HostCompilerDirectives.InliningCutoff.class, method) != null;
    }

    private static boolean isBytecodeInterpreterSwitchBoundary(ResolvedJavaMethod method) {
        return OptimizedTruffleRuntime.getAnnotation(HostCompilerDirectives.BytecodeInterpreterSwitchBoundary.class, method) != null;
    }

    private static boolean isTruffleBoundary(ResolvedJavaMethod method) {
        return OptimizedTruffleRuntime.getAnnotation(CompilerDirectives.TruffleBoundary.class, method) != null;
    }

    @Override
    public PartialEvaluationMethodInfo getPartialEvaluationMethodInfo(ResolvedJavaMethod method) {
        CompilerDirectives.TruffleBoundary truffleBoundary = OptimizedTruffleRuntime.getAnnotation(CompilerDirectives.TruffleBoundary.class, method);
        TruffleCallBoundary truffleCallBoundary = OptimizedTruffleRuntime.getAnnotation(TruffleCallBoundary.class, method);
        return new PartialEvaluationMethodInfo(OptimizedTruffleRuntime.getLoopExplosionKind(method), OptimizedTruffleRuntime.getInlineKind(truffleBoundary, truffleCallBoundary, method, true), OptimizedTruffleRuntime.getInlineKind(truffleBoundary, truffleCallBoundary, method, false), method.canBeInlined(), OptimizedTruffleRuntime.isSpecializationMethod(method));
    }

    private static boolean isSpecializationMethod(ResolvedJavaMethod method) {
        return OptimizedTruffleRuntime.getAnnotation(Specialization.class, method) != null;
    }

    private static TruffleCompilerRuntime.LoopExplosionKind getLoopExplosionKind(ResolvedJavaMethod method) {
        ExplodeLoop explodeLoop = OptimizedTruffleRuntime.getAnnotation(ExplodeLoop.class, method);
        if (explodeLoop == null) {
            return TruffleCompilerRuntime.LoopExplosionKind.NONE;
        }
        switch (explodeLoop.kind()) {
            case FULL_UNROLL: {
                return TruffleCompilerRuntime.LoopExplosionKind.FULL_UNROLL;
            }
            case FULL_UNROLL_UNTIL_RETURN: {
                return TruffleCompilerRuntime.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN;
            }
            case FULL_EXPLODE: {
                return TruffleCompilerRuntime.LoopExplosionKind.FULL_EXPLODE;
            }
            case FULL_EXPLODE_UNTIL_RETURN: {
                return TruffleCompilerRuntime.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN;
            }
            case MERGE_EXPLODE: {
                return TruffleCompilerRuntime.LoopExplosionKind.MERGE_EXPLODE;
            }
        }
        throw new InternalError(String.format("Unknown Truffle LoopExplosionKind %s", new Object[]{explodeLoop.kind()}));
    }

    private static TruffleCompilerRuntime.InlineKind getInlineKind(CompilerDirectives.TruffleBoundary truffleBoundary, TruffleCallBoundary truffleCallBoundary, ResolvedJavaMethod method, boolean duringPartialEvaluation) {
        if (truffleBoundary != null) {
            if (duringPartialEvaluation) {
                if (truffleBoundary.transferToInterpreterOnException()) {
                    return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_SPECULATIVE_EXCEPTION;
                }
                return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (!truffleBoundary.allowInlining()) {
                return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_EXCEPTION;
            }
        } else {
            if (truffleCallBoundary != null) {
                return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (JFRListener.isInstrumented(method)) {
                return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_EXCEPTION;
            }
        }
        return TruffleCompilerRuntime.InlineKind.INLINE;
    }

    public final void initializeKnownMethods(MetaAccessProvider metaAccess) {
        this.knownMethods = new KnownMethods(metaAccess);
    }

    public void markFrameMaterializeCalled(FrameDescriptor descriptor) {
        OptimizedRuntimeAccessor.FRAME.markMaterializeCalled(descriptor);
    }

    public boolean getFrameMaterializeCalled(FrameDescriptor descriptor) {
        return OptimizedRuntimeAccessor.FRAME.getMaterializeCalled(descriptor);
    }

    @Override
    public LoopNode createLoopNode(RepeatingNode repeatingNode) {
        if (!(repeatingNode instanceof Node)) {
            throw new IllegalArgumentException("Repeating node must be of type Node.");
        }
        return this.getLoopNodeFactory().create(repeatingNode);
    }

    protected final LoopNodeFactory getLoopNodeFactory() {
        return this.loopNodeFactory;
    }

    public final EngineCacheSupport getEngineCacheSupport() {
        return this.engineCacheSupport;
    }

    @Override
    public final VirtualFrame createVirtualFrame(Object[] arguments, FrameDescriptor frameDescriptor) {
        return OptimizedCallTarget.createFrame(frameDescriptor, arguments);
    }

    @Override
    public final MaterializedFrame createMaterializedFrame(Object[] arguments) {
        return this.createMaterializedFrame(arguments, new FrameDescriptor());
    }

    @Override
    public final MaterializedFrame createMaterializedFrame(Object[] arguments, FrameDescriptor frameDescriptor) {
        return new FrameWithoutBoxing(frameDescriptor, arguments);
    }

    @Override
    public final Assumption createAssumption() {
        return this.createAssumption(null);
    }

    @Override
    public final Assumption createAssumption(String name) {
        return new OptimizedAssumption(name);
    }

    public final OptimizedTruffleRuntimeListener getListener() {
        return this.listeners;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final <T> T iterateFrames(FrameInstanceVisitor<T> visitor, int skipFrames) {
        if (skipFrames < 0) {
            throw new IllegalArgumentException("The skipFrames parameter must be >= 0.");
        }
        return this.iterateImpl(visitor, skipFrames);
    }

    public final int compilationThresholdScale() {
        return this.compilationThresholdScale;
    }

    final void setCompilationThresholdScale(int scale) {
        this.compilationThresholdScale = scale;
    }

    private <T> T iterateImpl(FrameInstanceVisitor<T> visitor, int skip) {
        KnownMethods methods = this.getKnownMethods();
        FrameVisitor<T> jvmciVisitor = new FrameVisitor<T>(visitor, methods, skip);
        return (T)this.getStackIntrospection().iterateFrames(methods.anyFrameMethod, methods.anyFrameMethod, 0, jvmciVisitor);
    }

    protected abstract StackIntrospection getStackIntrospection();

    @Override
    public <T> T getCapability(Class<T> capability) {
        if (capability == TVMCI.class) {
            return capability.cast(this.tvmci);
        }
        if (capability == LayoutFactory.class) {
            LayoutFactory layoutFactory = OptimizedTruffleRuntime.loadObjectLayoutFactory();
            ModuleUtil.exportTo(layoutFactory.getClass());
            return capability.cast(layoutFactory);
        }
        if (capability == TVMCI.Test.class) {
            return capability.cast(this.getTestTvmci());
        }
        try {
            return OptimizedTruffleRuntime.loadServiceProvider(capability, false);
        }
        catch (ServiceConfigurationError e2) {
            return null;
        }
    }

    public abstract SpeculationLog createSpeculationLog();

    protected abstract OptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget var1, RootNode var2);

    protected abstract OptimizedCallTarget createInitializationCallTarget(EngineData var1);

    public void addListener(OptimizedTruffleRuntimeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(OptimizedTruffleRuntimeListener listener) {
        this.listeners.remove(listener);
    }

    private void shutdown() {
        this.getListener().onShutdown();
        TruffleCompiler tcp = this.truffleCompiler;
        if (tcp != null) {
            tcp.shutdown();
        }
    }

    protected final void doCompile(OptimizedCallTarget callTarget, AbstractCompilationTask task) {
        Objects.requireNonNull(callTarget, "Cannot compile null call target.");
        Objects.requireNonNull(task, "Compilation task required.");
        List<OptimizedCallTarget> oldBlockCompilations = callTarget.blockCompilations;
        if (oldBlockCompilations != null) {
            for (OptimizedCallTarget blockTarget : oldBlockCompilations) {
                if (blockTarget.isValid()) continue;
                this.listeners.onCompilationQueued(blockTarget, task.tier());
                int nodeCount = blockTarget.getNonTrivialNodeCount();
                if (nodeCount > callTarget.engine.getEngineOptions().get(OptimizedRuntimeOptions.PartialBlockMaximumSize)) {
                    this.listeners.onCompilationDequeued(blockTarget, null, "Partial block is too big to be compiled.", task.tier());
                    continue;
                }
                this.compileImpl(blockTarget, task);
            }
        }
        this.compileImpl(callTarget, task);
        if (oldBlockCompilations == null && callTarget.blockCompilations != null) {
            ((CompilationTask)task).reset();
            this.listeners.onCompilationQueued(callTarget, task.tier());
            this.doCompile(callTarget, task);
        }
    }

    private void compileImpl(OptimizedCallTarget callTarget, AbstractCompilationTask task) {
        boolean compilationStarted = false;
        try {
            TruffleCompiler compiler = this.getTruffleCompiler(callTarget);
            this.listeners.onCompilationStarted(callTarget, task);
            compilationStarted = true;
            compiler.doCompile(task, callTarget, this.listeners.isEmpty() ? null : this.listeners);
            task.dequeueTargets();
        }
        catch (OptimizationFailedException e2) {
            throw e2;
        }
        catch (Error | RuntimeException e3) {
            this.notifyCompilationFailure(callTarget, e3, compilationStarted, task.tier());
            throw e3;
        }
        catch (Throwable e4) {
            this.notifyCompilationFailure(callTarget, e4, compilationStarted, task.tier());
            throw new InternalError(e4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCompilationFailure(OptimizedCallTarget callTarget, Throwable t2, boolean compilationStarted, int tier) {
        block3: {
            try {
                if (compilationStarted) {
                    this.listeners.onCompilationFailed(callTarget, t2.toString(), false, false, tier, () -> TruffleCompilable.serializeException(t2));
                    break block3;
                }
                this.listeners.onCompilationDequeued(callTarget, this, String.format("Failed to create Truffle compiler due to %s.", t2.getMessage()), tier);
            }
            catch (Throwable throwable) {
                Supplier<String> serializedException = () -> TruffleCompilable.serializeException(t2);
                callTarget.onCompilationFailed(serializedException, this.isSuppressedCompilationFailure(t2) || this.isSuppressedFailure(callTarget, serializedException), false, false, false);
                throw throwable;
            }
        }
        Supplier<String> serializedException = () -> TruffleCompilable.serializeException(t2);
        callTarget.onCompilationFailed(serializedException, this.isSuppressedCompilationFailure(t2) || this.isSuppressedFailure(callTarget, serializedException), false, false, false);
    }

    public abstract BackgroundCompileQueue getCompileQueue();

    public CompilationTask submitForCompilation(OptimizedCallTarget optimizedCallTarget, boolean lastTierCompilation) {
        BackgroundCompileQueue.Priority priority = new BackgroundCompileQueue.Priority(optimizedCallTarget.getCallAndLoopCount(), lastTierCompilation ? BackgroundCompileQueue.Priority.Tier.LAST : BackgroundCompileQueue.Priority.Tier.FIRST);
        return this.getCompileQueue().submitCompilation(priority, optimizedCallTarget);
    }

    private static boolean assertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    public void finishCompilation(OptimizedCallTarget optimizedCallTarget, CompilationTask task, boolean mayBeAsynchronous) {
        block4: {
            if (!mayBeAsynchronous) {
                try {
                    OptimizedTruffleRuntime.uninterruptibleWaitForCompilation(task);
                }
                catch (ExecutionException e2) {
                    if (optimizedCallTarget.engine.compilationFailureAction == OptimizedRuntimeOptions.ExceptionAction.Throw) {
                        throw new OptimizationFailedException(e2.getCause(), optimizedCallTarget);
                    }
                    if (!OptimizedTruffleRuntime.assertionsEnabled()) break block4;
                    e2.printStackTrace();
                }
            }
        }
    }

    private static void uninterruptibleWaitForCompilation(CompilationTask task) throws ExecutionException {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    task.awaitCompletion();
                }
                catch (InterruptedException e2) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void waitForCompilation(OptimizedCallTarget optimizedCallTarget, long timeout) throws ExecutionException, TimeoutException {
        CompilationTask task = optimizedCallTarget.getCompilationTask();
        if (task != null) {
            try {
                task.awaitCompletion(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public int getCompilationQueueSize() {
        BackgroundCompileQueue compileQueue = this.getCompileQueue();
        return compileQueue == null ? 0 : compileQueue.getQueueSize();
    }

    public void bypassedInstalledCode(OptimizedCallTarget target) {
    }

    public KnownMethods getKnownMethods() {
        return this.knownMethods;
    }

    protected static EngineData getEngineData(RootNode rootNode) {
        return OptimizedTVMCI.getEngineData(rootNode);
    }

    private static LayoutFactory loadObjectLayoutFactory() {
        return OptimizedTruffleRuntime.selectObjectLayoutFactory(OptimizedTruffleRuntime.loadService(LayoutFactory.class));
    }

    private static <T> List<ServiceLoader<T>> loadService(Class<T> service) {
        ClassLoader runtimeClassLoader = OptimizedTruffleRuntime.class.getClassLoader();
        ClassLoader appClassLoader = service.getClassLoader();
        ServiceLoader<T> appLoader = ServiceLoader.load(service, appClassLoader);
        if (runtimeClassLoader.equals(appClassLoader)) {
            return List.of(appLoader);
        }
        ServiceLoader<T> runtimeLoader = ServiceLoader.load(service, runtimeClassLoader);
        return List.of(runtimeLoader, appLoader);
    }

    private static LayoutFactory selectObjectLayoutFactory(Iterable<? extends Iterable<LayoutFactory>> availableLayoutFactories) {
        String layoutFactoryImplName = Services.getSavedProperty((String)"truffle.object.LayoutFactory");
        LayoutFactory bestLayoutFactory = null;
        for (Iterable<LayoutFactory> iterable : availableLayoutFactories) {
            for (LayoutFactory currentLayoutFactory : iterable) {
                if (layoutFactoryImplName != null) {
                    if (!currentLayoutFactory.getClass().getName().equals(layoutFactoryImplName)) continue;
                    return currentLayoutFactory;
                }
                if (bestLayoutFactory == null) {
                    bestLayoutFactory = currentLayoutFactory;
                    continue;
                }
                if (currentLayoutFactory.getPriority() < bestLayoutFactory.getPriority()) continue;
                assert (currentLayoutFactory.getPriority() != bestLayoutFactory.getPriority());
                bestLayoutFactory = currentLayoutFactory;
            }
        }
        return bestLayoutFactory;
    }

    protected String printStackTraceToString(Throwable e2) {
        CharArrayWriter caw = new CharArrayWriter();
        e2.printStackTrace(new PrintWriter(caw));
        return caw.toString();
    }

    @Override
    public boolean isValueType(ResolvedJavaType type) {
        return OptimizedTruffleRuntime.getAnnotation(CompilerDirectives.ValueType.class, type) != null;
    }

    @Override
    public void log(String loggerId, TruffleCompilable compilable, String message) {
        TruffleLogger logger = ((OptimizedCallTarget)compilable).engine.getLogger(loggerId);
        if (logger != null) {
            logger.log(Level.INFO, message);
        }
    }

    @Override
    public boolean isSuppressedFailure(TruffleCompilable compilable, Supplier<String> serializedException) {
        return this.floodControlHandler != null && this.floodControlHandler.isSuppressedFailure(compilable, serializedException);
    }

    final boolean isSuppressedCompilationFailure(Throwable throwable) {
        return this.compilationSupport.isSuppressedCompilationFailure(throwable);
    }

    private static BailoutException handleAnnotationFailure(NoClassDefFoundError e2, String attemptedAction) {
        throw new BailoutException((Throwable)e2, "Error while %s. This usually means that the unresolved type is in the signature of some other method or field in the same class. This can be resolved by modifying the relevant class path or module path such that it includes the missing type.", new Object[]{attemptedAction});
    }

    private static <T extends Annotation> T getAnnotation(Class<T> annotationClass, ResolvedJavaMethod method) {
        try {
            return (T)((Annotation)annotationClass.cast(method.getAnnotation(annotationClass)));
        }
        catch (NoClassDefFoundError e2) {
            throw OptimizedTruffleRuntime.handleAnnotationFailure(e2, String.format("querying %s for presence of a %s annotation", method.format("%H.%n(%p)"), annotationClass.getName()));
        }
    }

    private static <T extends Annotation> T getAnnotation(Class<T> annotationClass, ResolvedJavaType type) {
        try {
            return (T)((Annotation)annotationClass.cast(type.getAnnotation(annotationClass)));
        }
        catch (NoClassDefFoundError e2) {
            throw OptimizedTruffleRuntime.handleAnnotationFailure(e2, String.format("querying %s for presence of a %s annotation", type.toJavaName(), annotationClass.getName()));
        }
    }

    protected final AutoCloseable openCompilerThreadScope() {
        return this.compilationSupport.openCompilerThreadScope();
    }

    protected long getCompilerIdleDelay(OptimizedCallTarget callTarget) {
        return callTarget.getOptionValue(OptimizedRuntimeOptions.CompilerIdleDelay);
    }

    final OptionDescriptors getOptionDescriptors() {
        OptionDescriptors res = this.engineOptions;
        if (res == null) {
            this.engineOptions = res = OptimizedRuntimeAccessor.LANGUAGE.createOptionDescriptorsUnion(this.runtimeOptionDescriptors.toArray(new OptionDescriptors[this.runtimeOptionDescriptors.size()]));
        }
        return res;
    }

    protected int getObjectAlignment() {
        throw new UnsupportedOperationException();
    }

    protected int getArrayBaseOffset(Class<?> componentType) {
        throw new UnsupportedOperationException();
    }

    protected int getArrayIndexScale(Class<?> componentType) {
        throw new UnsupportedOperationException();
    }

    protected int getBaseInstanceSize(Class<?> type) {
        throw new UnsupportedOperationException();
    }

    protected int[] getFieldOffsets(Class<?> type, boolean includePrimitive, boolean includeSuperclasses) {
        throw new UnsupportedOperationException();
    }

    protected abstract AbstractFastThreadLocal getFastThreadLocalImpl();

    public long getStackOverflowLimit() {
        throw new UnsupportedOperationException();
    }

    public static <T> ThreadLocal<T> createTerminatingThreadLocal(Supplier<T> initialValue, Consumer<T> onThreadTermination) {
        try {
            Method m2 = Services.class.getMethod("createTerminatingThreadLocal", Supplier.class, Consumer.class);
            return (ThreadLocal)m2.invoke(null, initialValue, onThreadTermination);
        }
        catch (NoSuchMethodException e2) {
            return ThreadLocal.withInitial(initialValue);
        }
        catch (ReflectiveOperationException e3) {
            throw CompilerDirectives.shouldNotReachHere(e3);
        }
    }

    public final class KnownMethods {
        public final ResolvedJavaMethod callDirectMethod;
        public final ResolvedJavaMethod callInlinedMethod;
        public final ResolvedJavaMethod callIndirectMethod;
        public final ResolvedJavaMethod callTargetMethod;
        public final ResolvedJavaMethod callInlinedCallMethod;
        public final ResolvedJavaMethod[] anyFrameMethod;

        public KnownMethods(MetaAccessProvider metaAccess) {
            this.callDirectMethod = metaAccess.lookupJavaMethod((Executable)OptimizedFrameInstance.CALL_DIRECT);
            this.callIndirectMethod = metaAccess.lookupJavaMethod((Executable)OptimizedFrameInstance.CALL_INDIRECT);
            this.callInlinedMethod = metaAccess.lookupJavaMethod((Executable)OptimizedFrameInstance.CALL_INLINED);
            this.callInlinedCallMethod = metaAccess.lookupJavaMethod((Executable)OptimizedFrameInstance.CALL_INLINED_CALL);
            this.callTargetMethod = metaAccess.lookupJavaMethod((Executable)OptimizedFrameInstance.CALL_TARGET_METHOD);
            this.anyFrameMethod = new ResolvedJavaMethod[]{this.callDirectMethod, this.callIndirectMethod, this.callInlinedMethod, this.callTargetMethod, this.callInlinedCallMethod};
        }
    }

    static final class CompilerOptionsDescriptors
    implements OptionDescriptors {
        TruffleCompilerOptionDescriptor[] options;
        private static final Map<String, OptionKey<String>> KEYS = new ConcurrentHashMap<String, OptionKey<String>>();
        private static final Map<OptionKey<String>, String> NAMES = new ConcurrentHashMap<OptionKey<String>, String>();

        CompilerOptionsDescriptors() {
        }

        @Override
        public OptionDescriptor get(String optionName) {
            String newOptionName = null;
            if (optionName.startsWith("compiler.")) {
                newOptionName = optionName;
            } else if (CompilerOptionsDescriptors.isLegacyOption(optionName)) {
                newOptionName = CompilerOptionsDescriptors.convertFromLegacyOptionName(optionName);
            }
            if (newOptionName != null && OptimizedTruffleRuntime.getRuntime().existsCompilerOption(newOptionName)) {
                OptionDescriptor.Builder b2 = OptionDescriptor.newBuilder(CompilerOptionsDescriptors.getOrCreateOptionKey(optionName), optionName);
                if (CompilerOptionsDescriptors.isLegacyOption(optionName)) {
                    b2.deprecated(true).deprecationMessage(String.format("The option %s is now deprecated. Please use the new option name '%s' instead to resolve this.", optionName, newOptionName));
                }
                return b2.build();
            }
            return null;
        }

        static OptionKey<String> getOrCreateOptionKey(String name) {
            return KEYS.computeIfAbsent(name, k2 -> {
                OptionType<String> type = new OptionType<String>("compilerOption", s2 -> s2, v2 -> {
                    String result;
                    String optionName = name;
                    if (CompilerOptionsDescriptors.isLegacyOption(optionName)) {
                        optionName = CompilerOptionsDescriptors.convertFromLegacyOptionName(optionName);
                    }
                    if ((result = OptimizedTruffleRuntime.getRuntime().validateCompilerOption(optionName, (String)v2)) != null) {
                        throw new IllegalArgumentException(result);
                    }
                });
                OptionKey<String> key = new OptionKey<String>("", type);
                NAMES.put(key, name);
                return key;
            });
        }

        static boolean isLegacyOption(String optionName) {
            switch (optionName) {
                case "engine.EncodedGraphCache": 
                case "engine.ExcludeAssertions": 
                case "engine.FirstTierInliningPolicy": 
                case "engine.FirstTierUseEconomy": 
                case "engine.InlineAcrossTruffleBoundary": 
                case "engine.InlineOnly": 
                case "engine.Inlining": 
                case "engine.InliningExpansionBudget": 
                case "engine.InliningInliningBudget": 
                case "engine.InliningPolicy": 
                case "engine.InliningRecursionDepth": 
                case "engine.InliningUseSize": 
                case "engine.InstrumentBoundaries": 
                case "engine.InstrumentBoundariesPerInlineSite": 
                case "engine.InstrumentBranches": 
                case "engine.InstrumentBranchesPerInlineSite": 
                case "engine.InstrumentFilter": 
                case "engine.InstrumentationTableSize": 
                case "engine.IterativePartialEscape": 
                case "engine.MaximumGraalGraphSize": 
                case "engine.MethodExpansionStatistics": 
                case "engine.NodeExpansionStatistics": 
                case "engine.NodeSourcePositions": 
                case "engine.ParsePEGraphsWithAssumptions": 
                case "engine.TraceInlining": 
                case "engine.TraceInliningDetails": 
                case "engine.TraceMethodExpansion": 
                case "engine.TraceNodeExpansion": 
                case "engine.TracePerformanceWarnings": 
                case "engine.TraceStackTraceLimit": 
                case "engine.TreatPerformanceWarningsAsErrors": {
                    return true;
                }
            }
            return false;
        }

        static String convertFromLegacyOptionName(String optionName) {
            return optionName.replaceFirst("engine", "compiler");
        }

        static String convertToLegacyOptionName(String optionName) {
            return optionName.replaceFirst("compiler", "engine");
        }

        @Override
        public Iterator<OptionDescriptor> iterator() {
            TruffleCompilerOptionDescriptor[] optionsArray = this.options;
            if (optionsArray == null) {
                this.options = optionsArray = OptimizedTruffleRuntime.getRuntime().listCompilerOptions();
            }
            ArrayList<OptionDescriptor> descriptors = new ArrayList<OptionDescriptor>();
            for (TruffleCompilerOptionDescriptor descriptor : optionsArray) {
                descriptors.add(CompilerOptionsDescriptors.convertDescriptor(descriptor));
            }
            for (TruffleCompilerOptionDescriptor descriptor : optionsArray) {
                descriptors.add(CompilerOptionsDescriptors.convertDescriptorLegacy(descriptor));
            }
            return descriptors.iterator();
        }

        static OptionDescriptor convertDescriptorLegacy(TruffleCompilerOptionDescriptor d2) {
            String name = CompilerOptionsDescriptors.convertToLegacyOptionName(d2.name());
            return OptionDescriptor.newBuilder(CompilerOptionsDescriptors.getOrCreateOptionKey(name), name).help(d2.help()).stability(OptionStability.EXPERIMENTAL).category(CompilerOptionsDescriptors.matchCategory(d2)).deprecated(true).deprecationMessage(String.format("The option %s is now deprecated. Please use the new option name '%s' instead to resolve this.", name, d2.name())).build();
        }

        static OptionDescriptor convertDescriptor(TruffleCompilerOptionDescriptor d2) {
            String name = d2.name();
            return OptionDescriptor.newBuilder(CompilerOptionsDescriptors.getOrCreateOptionKey(name), name).help(d2.help()).stability(OptionStability.EXPERIMENTAL).category(CompilerOptionsDescriptors.matchCategory(d2)).deprecated(d2.deprecated()).deprecationMessage(d2.deprecationMessage()).build();
        }

        static Map<String, String> extractOptions(OptionValues values) {
            LinkedHashMap<String, String> options = null;
            for (Map.Entry<OptionKey<String>, String> entry : NAMES.entrySet()) {
                if (options == null) {
                    options = new LinkedHashMap();
                }
                String optionName = entry.getValue();
                if (!values.hasBeenSet(entry.getKey())) continue;
                String optionValue = values.get(entry.getKey());
                if (CompilerOptionsDescriptors.isLegacyOption(optionName)) {
                    optionName = CompilerOptionsDescriptors.convertFromLegacyOptionName(optionName);
                }
                options.put(optionName, optionValue);
            }
            return options == null ? new LinkedHashMap<String, String>() : options;
        }

        static OptionCategory matchCategory(TruffleCompilerOptionDescriptor d2) {
            switch (d2.type()) {
                case USER: {
                    return OptionCategory.USER;
                }
                case EXPERT: {
                    return OptionCategory.EXPERT;
                }
                case DEBUG: {
                    return OptionCategory.INTERNAL;
                }
            }
            return OptionCategory.INTERNAL;
        }
    }

    private static final class FrameVisitor<T>
    implements InspectedFrameVisitor<T> {
        private final FrameInstanceVisitor<T> visitor;
        private final KnownMethods methods;
        private int skipFrames;
        private InspectedFrame callNodeFrame;
        private InspectedFrame osrFrame;

        FrameVisitor(FrameInstanceVisitor<T> visitor, KnownMethods methods, int skip) {
            this.visitor = visitor;
            this.methods = methods;
            this.skipFrames = skip;
        }

        public T visitFrame(InspectedFrame frame) {
            if (frame.isMethod(this.methods.callDirectMethod) || frame.isMethod(this.methods.callIndirectMethod) || frame.isMethod(this.methods.callInlinedMethod) || frame.isMethod(this.methods.callInlinedCallMethod)) {
                this.callNodeFrame = frame;
                return null;
            }
            assert (frame.isMethod(this.methods.callTargetMethod));
            if (FrameVisitor.isOSRFrame(frame)) {
                if (this.skipFrames == 0 && this.osrFrame == null) {
                    this.osrFrame = frame;
                }
                return null;
            }
            if (this.skipFrames > 0) {
                --this.skipFrames;
                return null;
            }
            try {
                if (this.osrFrame != null) {
                    T t2 = this.visitor.visitFrame(new OptimizedOSRFrameInstance(frame, this.callNodeFrame, this.osrFrame));
                    return t2;
                }
                T t3 = this.visitor.visitFrame(new OptimizedFrameInstance(frame, this.callNodeFrame));
                return t3;
            }
            finally {
                this.osrFrame = null;
                this.callNodeFrame = null;
            }
        }

        private static boolean isOSRFrame(InspectedFrame frame) {
            return ((OptimizedCallTarget)frame.getLocal(0)).getRootNode() instanceof BaseOSRRootNode;
        }
    }

    public static class StackTraceHelper {
        public static void logHostAndGuestStacktrace(String reason, OptimizedCallTarget callTarget) {
            final int limit = callTarget.getOptionValue(OptimizedRuntimeOptions.TraceStackTraceLimit);
            OptimizedTruffleRuntime runtime = OptimizedTruffleRuntime.getRuntime();
            final StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append(reason).append(" at\n");
            runtime.iterateFrames(new FrameInstanceVisitor<Object>(){
                int frameIndex = 0;

                @Override
                public Object visitFrame(FrameInstance frameInstance) {
                    CallTarget target = frameInstance.getCallTarget();
                    StringBuilder line = new StringBuilder("  ");
                    if (this.frameIndex > 0) {
                        line.append("  ");
                    }
                    line.append(StackTraceHelper.formatStackFrame(frameInstance, target)).append("\n");
                    ++this.frameIndex;
                    messageBuilder.append((CharSequence)line);
                    if (this.frameIndex < limit) {
                        return null;
                    }
                    messageBuilder.append("    ...\n");
                    return frameInstance;
                }
            });
            int skip = 3;
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            String suffix = stackTrace.length > 3 + limit ? "\n    ..." : "";
            messageBuilder.append(Arrays.stream(stackTrace).skip(3L).limit(limit).map(StackTraceElement::toString).collect(Collectors.joining("\n    ", "  ", suffix)));
            runtime.log(callTarget, messageBuilder.toString());
        }

        private static String formatStackFrame(FrameInstance frameInstance, CallTarget target) {
            StringBuilder builder = new StringBuilder();
            if (target instanceof RootCallTarget) {
                OptimizedCallTarget callTarget;
                RootNode root = ((RootCallTarget)target).getRootNode();
                String name = root.getName();
                if (name == null) {
                    builder.append("unnamed-root");
                } else {
                    builder.append(name);
                }
                Node callNode = frameInstance.getCallNode();
                SourceSection sourceSection = null;
                if (callNode != null) {
                    sourceSection = callNode.getEncapsulatingSourceSection();
                }
                if (sourceSection == null) {
                    sourceSection = root.getSourceSection();
                }
                if (sourceSection == null || sourceSection.getSource() == null) {
                    builder.append("(Unknown)");
                } else {
                    builder.append("(").append(StackTraceHelper.formatPath(sourceSection)).append(":").append(sourceSection.getStartLine()).append(")");
                }
                if (target instanceof OptimizedCallTarget && (callTarget = (OptimizedCallTarget)target).isSplit()) {
                    builder.append(" <split-").append(Integer.toHexString(callTarget.hashCode())).append(">");
                }
            } else {
                builder.append(target.toString());
            }
            return builder.toString();
        }

        private static String formatPath(SourceSection sourceSection) {
            if (sourceSection.getSource().getPath() != null) {
                Path path = FileSystems.getDefault().getPath(".", new String[0]).toAbsolutePath();
                Path filePath = FileSystems.getDefault().getPath(sourceSection.getSource().getPath(), new String[0]).toAbsolutePath();
                try {
                    return path.relativize(filePath).toString();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return sourceSection.getSource().getName();
        }
    }
}

