/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.evaluate.translation.translator;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.api.evaluate.translation.IValueTranslator;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.evaluate.translation.translator.NbtCompoundTagProxyObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;

public class ValueTranslatorNbt
implements IValueTranslator<ValueTypeNbt.ValueNbt> {
    @Override
    public IValueType<?> getValueType() {
        return ValueTypes.NBT;
    }

    @Override
    public boolean canHandleGraalValue(Value value) {
        return value.hasMembers();
    }

    @Override
    public boolean canTranslateNbt() {
        return true;
    }

    @Override
    public Value translateToGraal(Context context, ValueTypeNbt.ValueNbt value, IEvaluationExceptionFactory exceptionFactory, ValueDeseralizationContext valueDeseralizationContext) throws EvaluationException {
        Tag tag = value.getRawValue().orElse(null);
        if (tag == null) {
            return context.asValue(null);
        }
        return this.translateTag(context, tag, exceptionFactory, valueDeseralizationContext);
    }

    public Value translateTag(Context context, Tag tag, IEvaluationExceptionFactory exceptionFactory, ValueDeseralizationContext valueDeseralizationContext) throws EvaluationException {
        switch (tag.getId()) {
            case 0: {
                return context.eval("js", "exports = { 'nbt_end': true }");
            }
            case 1: {
                return context.asValue(tag.asByte().orElseThrow());
            }
            case 2: {
                return context.asValue(tag.asShort().orElseThrow());
            }
            case 3: {
                return context.asValue(tag.asInt().orElseThrow());
            }
            case 4: {
                return context.asValue(tag.asLong().orElseThrow());
            }
            case 5: {
                return context.asValue(tag.asFloat().orElseThrow());
            }
            case 6: {
                return context.asValue(tag.asDouble().orElseThrow());
            }
            case 7: {
                return context.asValue(((ByteArrayTag)tag).getAsByteArray());
            }
            case 8: {
                return context.asValue(tag.asString().orElseThrow());
            }
            case 9: {
                ArrayList<Value> list = new ArrayList<Value>();
                ListTag listTag = (ListTag)tag;
                for (Tag innerValue : listTag) {
                    list.add(this.translateTag(context, innerValue, exceptionFactory, valueDeseralizationContext));
                }
                return context.asValue(list);
            }
            case 10: {
                return this.translateCompoundTag(context, (CompoundTag)tag, exceptionFactory, null, null, valueDeseralizationContext);
            }
            case 11: {
                return context.asValue(((IntArrayTag)tag).getAsIntArray());
            }
            case 12: {
                return context.asValue(((LongArrayTag)tag).getAsLongArray());
            }
        }
        throw exceptionFactory.createError(Component.translatable((String)"valuetype.integratedscripting.error.translation.nbt_unknown", (Object[])new Object[]{tag.getType().getPrettyName()}));
    }

    public Value translateCompoundTag(Context context, CompoundTag tag, IEvaluationExceptionFactory exceptionFactory, @Nullable Map<String, IOperator> methods, @Nullable IValue value, ValueDeseralizationContext valueDeseralizationContext) {
        return context.asValue(new NbtCompoundTagProxyObject(context, exceptionFactory, tag, methods, value, valueDeseralizationContext));
    }

    @Override
    public ValueTypeNbt.ValueNbt translateFromGraal(Context context, Value value, IEvaluationExceptionFactory exceptionFactory, ValueDeseralizationContext valueDeseralizationContext) throws EvaluationException {
        if (value.isProxyObject()) {
            try {
                NbtCompoundTagProxyObject proxy = (NbtCompoundTagProxyObject)value.asProxyObject();
                return ValueTypeNbt.ValueNbt.of((Tag)proxy.getTag());
            }
            catch (ClassCastException proxy) {
                // empty catch block
            }
        }
        if (value.getMemberKeys().equals(Sets.newHashSet((Object[])new String[]{"nbt_end"}))) {
            return ValueTypeNbt.ValueNbt.of((Tag)EndTag.INSTANCE);
        }
        CompoundTag tag = new CompoundTag();
        for (String memberKey : value.getMemberKeys()) {
            Value memberValue = value.getMember(memberKey);
            if (memberValue.isNull()) continue;
            Object subValue = ValueTranslators.REGISTRY.translateFromGraal(context, memberValue, exceptionFactory, valueDeseralizationContext);
            tag.put(memberKey, ValueTranslators.REGISTRY.translateToNbt(context, subValue, exceptionFactory));
        }
        return ValueTypeNbt.ValueNbt.of((Tag)tag);
    }

    @Override
    public Tag translateToNbt(Context context, ValueTypeNbt.ValueNbt value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        return (Tag)value.getRawValue().orElseThrow();
    }
}

