/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset;

class UTF8 {
    private static final int[] U8_LEAD3_T1_BITS = new int[]{32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 16, 48, 48};
    private static final int[] U8_LEAD4_T1_BITS = new int[]{3584, 3840, 3840, 3840, 256};
    static int MAX_LENGTH = 4;

    UTF8() {
    }

    static int countTrailBytes(byte leadByte) {
        if (leadByte < -32) {
            return leadByte < -62 ? 0 : 1;
        }
        if (leadByte < -16) {
            return 2;
        }
        return leadByte <= -12 ? 3 : 0;
    }

    static int countBytes(byte leadByte) {
        if (leadByte >= 0) {
            return 1;
        }
        if (leadByte < -32) {
            return leadByte < -62 ? 0 : 2;
        }
        if (leadByte < -16) {
            return 3;
        }
        return leadByte <= -12 ? 4 : 0;
    }

    static boolean isValidLead3AndT1(int lead, byte t1) {
        return (U8_LEAD3_T1_BITS[lead & 0xF] & 1 << ((t1 & 0xFF) >> 5)) != 0;
    }

    static boolean isValidLead4AndT1(int lead, byte t1) {
        return (U8_LEAD4_T1_BITS[lead & 7] & 1 << ((t1 & 0xFF) >> 4)) != 0;
    }

    static boolean isSingle(byte c2) {
        return c2 >= 0;
    }

    static boolean isLead(byte c2) {
        return (c2 - 194 & 0xFF) <= 50;
    }

    static boolean isTrail(byte c2) {
        return c2 < -64;
    }

    static int length(int c2) {
        if (c2 >= 0) {
            if (c2 <= 127) {
                return 1;
            }
            if (c2 <= 2047) {
                return 2;
            }
            if (c2 <= 55295) {
                return 3;
            }
            if (c2 <= 65535) {
                return c2 >= 57344 ? 3 : 0;
            }
            if (c2 <= 0x10FFFF) {
                return 4;
            }
        }
        return 0;
    }

    static boolean isValidTrail(int prev, byte t2, int i2, int length) {
        if (length <= 2 || i2 > 1) {
            return UTF8.isTrail(t2);
        }
        if (length == 3) {
            return UTF8.isValidLead3AndT1(prev, t2);
        }
        return UTF8.isValidLead4AndT1(prev, t2);
    }
}

