/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.BigIntFunctionBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;

public final class BigIntFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<BigIntFunction> {
    public static final JSBuiltinsContainer BUILTINS = new BigIntFunctionBuiltins();

    protected BigIntFunctionBuiltins() {
        super(JSBigInt.CLASS_NAME, BigIntFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, BigIntFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return BigIntFunctionBuiltinsFactory.JSBigIntAsUintNNodeGen.create(context, builtin, BigIntFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 1: {
                return BigIntFunctionBuiltinsFactory.JSBigIntAsIntNNodeGen.create(context, builtin, BigIntFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum BigIntFunction implements BuiltinEnum<BigIntFunction>
    {
        asUintN(2),
        asIntN(2);

        private final int length;

        private BigIntFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            return 9;
        }
    }

    public static abstract class JSBigIntAsUintNNode
    extends JSBuiltinNode {
        public JSBigIntAsUintNNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected BigInt doIt(Object bitsObj, Object bigIntObj, @Cached JSToIndexNode toIndexNode, @Cached JSToBigIntNode toBigIntNode) {
            long bits = toIndexNode.executeLong(bitsObj);
            BigInt bigint = toBigIntNode.executeBigInteger(bigIntObj);
            if (bits == 0L) {
                return BigInt.ZERO;
            }
            if (bigint.signum() >= 0 && (long)bigint.bitLength() <= bits) {
                return bigint;
            }
            try {
                int bitsAsInt = Math.toIntExact(bits);
                return bigint.mod(BigInt.ONE.shiftLeft(bitsAsInt));
            }
            catch (ArithmeticException e2) {
                throw Errors.createRangeErrorBigIntMaxSizeExceeded();
            }
        }
    }

    public static abstract class JSBigIntAsIntNNode
    extends JSBuiltinNode {
        public JSBigIntAsIntNNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected BigInt doIt(Object bitsObj, Object bigIntObj, @Cached JSToIndexNode toIndexNode, @Cached JSToBigIntNode toBigIntNode) {
            long bits = toIndexNode.executeLong(bitsObj);
            BigInt bigint = toBigIntNode.executeBigInteger(bigIntObj);
            if (bits == 0L) {
                return BigInt.ZERO;
            }
            if ((long)bigint.bitLength() < bits) {
                return bigint;
            }
            try {
                assert (JSRuntime.longIsRepresentableAsInt(bits));
                int bitsAsInt = (int)bits;
                BigInt twoPowBits = BigInt.ONE.shiftLeft(bitsAsInt);
                BigInt mod = bigint.mod(twoPowBits);
                if (mod.bitLength() == bitsAsInt) {
                    assert (mod.compareTo(BigInt.ONE.shiftLeft(bitsAsInt - 1)) >= 0) : mod;
                    return mod.subtract(twoPowBits);
                }
                assert (mod.compareTo(BigInt.ONE.shiftLeft(bitsAsInt - 1)) < 0 && mod.bitLength() < bitsAsInt) : mod;
                return mod;
            }
            catch (ArithmeticException e2) {
                throw Errors.createRangeErrorBigIntMaxSizeExceeded();
            }
        }
    }
}

