/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.temporal;

import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;

public final class JSTemporalDurationRecord {
    private final double years;
    private final double months;
    private final double days;
    private final double hours;
    private final double minutes;
    private final double seconds;
    private final double milliseconds;
    private final double microseconds;
    private final double nanoseconds;
    private final double weeks;
    private final double remainder;

    private JSTemporalDurationRecord(double years, double months, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds, double weeks, double remainder) {
        this.years = years;
        this.months = months;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
        this.microseconds = microseconds;
        this.nanoseconds = nanoseconds;
        this.weeks = weeks;
        this.remainder = remainder;
    }

    public static JSTemporalDurationRecord create(double years, double months, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        return new JSTemporalDurationRecord(years, months, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, 0.0, 0.0);
    }

    public static JSTemporalDurationRecord createWeeks(double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        return new JSTemporalDurationRecord(years, months, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, weeks, 0.0);
    }

    public static JSTemporalDurationRecord createWeeksRemainder(double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds, double remainder) {
        return new JSTemporalDurationRecord(years, months, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, weeks, remainder);
    }

    public double getYears() {
        return this.years;
    }

    public double getMonths() {
        return this.months;
    }

    public double getDays() {
        return this.days;
    }

    public double getHours() {
        return this.hours;
    }

    public double getMinutes() {
        return this.minutes;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public double getMilliseconds() {
        return this.milliseconds;
    }

    public double getMicroseconds() {
        return this.microseconds;
    }

    public double getNanoseconds() {
        return this.nanoseconds;
    }

    public double getWeeks() {
        return this.weeks;
    }

    public double getRemainder() {
        return this.remainder;
    }

    public static JSTemporalDurationRecord create(JSTemporalDateTimeRecord r2) {
        return JSTemporalDurationRecord.create(r2.getYear(), r2.getMonth(), r2.getDay(), r2.getHour(), r2.getMinute(), r2.getSecond(), r2.getMillisecond(), r2.getMicrosecond(), r2.getNanosecond());
    }

    public static JSTemporalDurationRecord create(JSTemporalDurationObject duration) {
        return JSTemporalDurationRecord.createWeeks(duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds());
    }

    public static JSTemporalDurationRecord createZero() {
        return new JSTemporalDurationRecord(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }
}

