/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.TruffleOptionDescriptors;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptor;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptors;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionKey;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionStability;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionValues;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.SandboxPolicy;

final class OptionValuesImpl
implements OptionValues {
    private static final float FUZZY_MATCH_THRESHOLD = 0.7f;
    private final OptionDescriptors descriptors;
    private final SandboxPolicy sandboxPolicy;
    private final Map<OptionKey<?>, Object> values;
    private List<OptionDescriptor> usedDeprecatedDescriptors;
    private final Map<OptionKey<?>, String> unparsedValues;
    private volatile Set<OptionKey<?>> validAssertKeys;
    private final boolean trackDeprecatedOptions;

    OptionValuesImpl(OptionDescriptors descriptors, SandboxPolicy sandboxPolicy, boolean preserveUnparsedValues, boolean trackDeprecatedOptions) {
        Objects.requireNonNull(descriptors);
        Objects.requireNonNull(sandboxPolicy);
        this.descriptors = descriptors;
        this.sandboxPolicy = sandboxPolicy;
        this.values = new HashMap();
        this.unparsedValues = preserveUnparsedValues ? new HashMap() : null;
        this.trackDeprecatedOptions = trackDeprecatedOptions;
    }

    public int hashCode() {
        int result = 31 + this.descriptors.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OptionValues)) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        OptionValues other = (OptionValues)obj;
        if (!this.getDescriptors().equals(other.getDescriptors())) {
            return false;
        }
        if (!this.hasSetOptions() && !other.hasSetOptions()) {
            return true;
        }
        if (other instanceof OptionValuesImpl) {
            OptionValuesImpl otherOptions = (OptionValuesImpl)other;
            if (!this.values.equals(otherOptions.values)) {
                return false;
            }
        } else {
            for (OptionDescriptor descriptor : this.getDescriptors()) {
                OptionKey<?> key = descriptor.getKey();
                if (this.slowCompareKey(key, other)) continue;
                return false;
            }
        }
        return true;
    }

    Collection<OptionDescriptor> getUsedDeprecatedDescriptors() {
        if (!this.trackDeprecatedOptions) {
            throw new UnsupportedOperationException("Deprecated options not tracked.");
        }
        if (this.usedDeprecatedDescriptors == null) {
            return List.of();
        }
        return this.usedDeprecatedDescriptors;
    }

    private boolean slowCompareKey(OptionKey<?> key, OptionValues other) {
        boolean set = this.hasBeenSet(key);
        if (set != other.hasBeenSet(key)) {
            return false;
        }
        return !set || this.get(key).equals(other.get(key));
    }

    public void putAll(PolyglotEngineImpl engine, Map<String, String> providedValues, boolean allowExperimentalOptions) {
        for (String key : providedValues.keySet()) {
            this.put(engine, key, providedValues.get(key), allowExperimentalOptions);
        }
    }

    public OptionDescriptor put(PolyglotEngineImpl engine, String key, String value, boolean allowExperimentalOptions) {
        Object convertedValue;
        OptionKey<?> optionKey;
        OptionDescriptor descriptor = this.findDescriptor(engine, key, allowExperimentalOptions);
        if (this.sandboxPolicy != SandboxPolicy.TRUSTED) {
            SandboxPolicy optionSandboxPolicy;
            SandboxPolicy sandboxPolicy = optionSandboxPolicy = this.descriptors instanceof TruffleOptionDescriptors ? ((TruffleOptionDescriptors)this.descriptors).getSandboxPolicy(key) : SandboxPolicy.TRUSTED;
            if (this.sandboxPolicy.isStricterThan(optionSandboxPolicy)) {
                throw PolyglotEngineException.illegalArgument(PolyglotImpl.sandboxPolicyException(this.sandboxPolicy, String.format("The option %s can only be used up to the %s sandbox policy.", new Object[]{descriptor.getName(), optionSandboxPolicy}), String.format("do not set the %s option by removing Builder.option(\"%s\", \"%s\")", descriptor.getName(), descriptor.getName(), value)));
            }
        }
        Object previousValue = this.values.containsKey(optionKey = descriptor.getKey()) ? this.values.get(optionKey) : optionKey.getDefaultValue();
        String name = descriptor.getName();
        String suffix = null;
        if (descriptor.isOptionMap()) {
            suffix = key.substring(name.length());
            assert (suffix.isEmpty() || suffix.startsWith("."));
            if (suffix.startsWith(".")) {
                suffix = suffix.substring(1);
            }
        }
        try {
            convertedValue = optionKey.getType().convert(previousValue, suffix, value);
        }
        catch (IllegalArgumentException e2) {
            throw PolyglotEngineException.illegalArgument(e2);
        }
        if (this.trackDeprecatedOptions && descriptor.isDeprecated()) {
            if (this.usedDeprecatedDescriptors == null) {
                this.usedDeprecatedDescriptors = new ArrayList<OptionDescriptor>();
            }
            this.usedDeprecatedDescriptors.add(descriptor);
        }
        this.values.put(descriptor.getKey(), convertedValue);
        if (this.unparsedValues != null) {
            this.unparsedValues.put(descriptor.getKey(), value);
        }
        return descriptor;
    }

    private OptionValuesImpl(OptionValuesImpl copy) {
        this.values = new HashMap(copy.values);
        this.descriptors = copy.descriptors;
        this.sandboxPolicy = copy.sandboxPolicy;
        this.unparsedValues = copy.unparsedValues;
        this.usedDeprecatedDescriptors = copy.usedDeprecatedDescriptors;
        this.trackDeprecatedOptions = copy.trackDeprecatedOptions;
    }

    private <T> boolean contains(OptionKey<T> optionKey) {
        Set<OptionKey<?>> keys = this.validAssertKeys;
        if (keys == null) {
            keys = this.initializeValidAssertKeys();
        }
        return keys.contains(optionKey);
    }

    private synchronized Set<OptionKey<?>> initializeValidAssertKeys() {
        Set<OptionKey<?>> keys = this.validAssertKeys;
        if (keys == null) {
            keys = new HashSet();
            for (OptionDescriptor descriptor : this.descriptors) {
                keys.add(descriptor.getKey());
            }
            this.validAssertKeys = keys;
        }
        return keys;
    }

    @Override
    public boolean hasBeenSet(OptionKey<?> optionKey) {
        assert (this.contains(optionKey));
        return this.values.containsKey(optionKey);
    }

    OptionValuesImpl copy() {
        return new OptionValuesImpl(this);
    }

    void copyInto(OptionValuesImpl target) {
        if (!target.values.isEmpty()) {
            throw new IllegalStateException("Values must be empty.");
        }
        if (this.sandboxPolicy != target.sandboxPolicy) {
            throw new AssertionError((Object)"Source and target must have the same SandboxPolicy.");
        }
        target.values.putAll(this.values);
    }

    @Override
    public OptionDescriptors getDescriptors() {
        return this.descriptors;
    }

    @Override
    public <T> T get(OptionKey<T> optionKey) {
        assert (this.contains(optionKey));
        Object value = this.values.get(optionKey);
        if (value == null) {
            return optionKey.getDefaultValue();
        }
        return (T)value;
    }

    @Override
    public <T> void set(OptionKey<T> optionKey, T value) {
        throw new UnsupportedOperationException("OptionValues#set() is no longer supported");
    }

    @Override
    public boolean hasSetOptions() {
        return !this.values.isEmpty();
    }

    String getUnparsedOptionValue(OptionKey<?> key) {
        if (this.unparsedValues == null) {
            throw new IllegalStateException("Unparsed values are not supported");
        }
        return this.unparsedValues.get(key);
    }

    private OptionDescriptor findDescriptor(PolyglotEngineImpl engine, String key, boolean allowExperimentalOptions) {
        OptionDescriptor descriptor = this.descriptors.get(key);
        if (descriptor == null) {
            throw this.failNotFound(engine, key);
        }
        if (!allowExperimentalOptions && descriptor.getStability() == OptionStability.EXPERIMENTAL) {
            throw OptionValuesImpl.failExperimental(key);
        }
        return descriptor;
    }

    private static RuntimeException failExperimental(String key) {
        String message = String.format("Option '%s' is experimental and must be enabled with allowExperimentalOptions(boolean) in Context.Builder or Engine.Builder. ", key) + "Do not use experimental options in production environments.";
        return PolyglotEngineException.illegalArgument(message);
    }

    private RuntimeException failNotFound(PolyglotEngineImpl engine, String key) {
        OptionDescriptors allOptions;
        Exception errorOptions = null;
        try {
            allOptions = engine == null ? this.descriptors : engine.getAllOptions();
        }
        catch (Exception e2) {
            errorOptions = e2;
            allOptions = this.descriptors;
        }
        RuntimeException error = OptionValuesImpl.failNotFound(allOptions, key);
        if (errorOptions != null) {
            error.addSuppressed(errorOptions);
        }
        throw error;
    }

    static RuntimeException failNotFound(OptionDescriptors allOptions, String key) {
        List<OptionDescriptor> matches = OptionValuesImpl.fuzzyMatch(allOptions, key);
        Formatter msg = new Formatter();
        msg.format("Could not find option with name %s.", key);
        Iterator iterator = matches.iterator();
        if (iterator.hasNext()) {
            msg.format("%nDid you mean one of the following?", new Object[0]);
            for (OptionDescriptor match : matches) {
                msg.format("%n    %s=<%s>", match.getName(), match.getKey().getType().getName());
            }
        }
        throw PolyglotEngineException.illegalArgument(msg.toString());
    }

    static List<OptionDescriptor> fuzzyMatch(OptionDescriptors descriptors, String optionKey) {
        ArrayList<OptionDescriptor> matches = new ArrayList<OptionDescriptor>();
        for (OptionDescriptor option : descriptors) {
            float score = OptionValuesImpl.stringSimiliarity(option.getName(), optionKey);
            if (!(score >= 0.7f)) continue;
            matches.add(option);
        }
        return matches;
    }

    private static float stringSimiliarity(String str1, String str2) {
        int hit = 0;
        block0: for (int i2 = 0; i2 < str1.length() - 1; ++i2) {
            for (int j2 = 0; j2 < str2.length() - 1; ++j2) {
                if (str1.charAt(i2) != str2.charAt(j2) || str1.charAt(i2 + 1) != str2.charAt(j2 + 1)) continue;
                ++hit;
                continue block0;
            }
        }
        return 2.0f * (float)hit / (float)(str1.length() + str2.length());
    }

    public String toString() {
        Map<OptionKey<?>, Object> options = this.unparsedValues != null ? this.unparsedValues : this.values;
        StringBuilder b2 = new StringBuilder("{");
        String sep = "";
        for (OptionDescriptor descriptor : this.getDescriptors()) {
            OptionKey<?> key = descriptor.getKey();
            if (!this.hasBeenSet(key)) continue;
            b2.append(sep);
            b2.append(descriptor.getName());
            b2.append("=");
            b2.append(options.get(key));
            sep = ", ";
        }
        b2.append("}");
        return b2.toString();
    }
}

