/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.buffer;

import com.oracle.truffle.regex.tregex.buffer.AbstractArrayBuffer;
import com.oracle.truffle.regex.util.EmptyArrays;
import java.util.Arrays;

public class CharArrayBuffer
extends AbstractArrayBuffer {
    protected char[] buf;

    public CharArrayBuffer() {
        this(16);
    }

    public CharArrayBuffer(int initialSize) {
        this.buf = new char[initialSize];
    }

    @Override
    int getBufferLength() {
        return this.buf.length;
    }

    @Override
    void grow(int newSize) {
        this.buf = Arrays.copyOf(this.buf, newSize);
    }

    public char[] getBuffer() {
        return this.buf;
    }

    public char get(int i2) {
        return this.buf[i2];
    }

    public void set(int i2, char c2) {
        this.buf[i2] = c2;
    }

    public void add(char c2) {
        if (this.length == this.buf.length) {
            this.grow(this.length * 2);
        }
        this.buf[this.length++] = c2;
    }

    public char[] toArray() {
        return this.isEmpty() ? EmptyArrays.CHAR : Arrays.copyOf(this.buf, this.length);
    }
}

