/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.DateFunctionBuiltins;
import com.oracle.truffle.js.builtins.DatePrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSDateObject;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.Grego;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.DateFormat;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.TimeZone;

public final class JSDate
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("Date");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Date.prototype");
    public static final JSDate INSTANCE = new JSDate();
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTE = 60;
    public static final int MS_PER_SECOND = 1000;
    public static final int MS_PER_MINUTE = 60000;
    public static final int MS_PER_HOUR = 3600000;
    public static final int MS_PER_DAY = 86400000;
    public static final double MAX_DATE = 8.64E15;
    public static final double MAX_YEAR_VALUE = 300000.0;
    public static final double MIN_YEAR_VALUE = -300000.0;
    private static final int DAYS_IN_4_YEARS = 1461;
    private static final int DAYS_IN_100_YEARS = 36524;
    private static final int DAYS_IN_400_YEARS = 146097;
    private static final int DAYS_FROM_1970_TO_2000 = 10957;
    private static final int YEAR_SHIFT = 280000;
    private static final int DAY_SHIFT = 102267900;
    public static final TruffleString INVALID_DATE_STRING = Strings.constant("Invalid Date");

    private JSDate() {
    }

    public static void setTimeMillisField(JSDateObject obj, double timeMillis) {
        assert (JSDate.isJSDate(obj));
        obj.setTimeMillis(timeMillis);
    }

    public static double getTimeMillisField(JSDateObject obj) {
        assert (JSDate.isJSDate(obj));
        return obj.getTimeMillis();
    }

    public static boolean isJSDate(Object obj) {
        return obj instanceof JSDateObject;
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject datePrototype;
        JSContext ctx = realm.getContext();
        if (ctx.getEcmaScriptVersion() < 6) {
            Shape protoShape = JSShape.createPrototypeShape(realm.getContext(), INSTANCE, realm.getObjectPrototype());
            datePrototype = JSDateObject.create(protoShape, realm.getObjectPrototype(), Double.NaN);
            JSObjectUtil.setOrVerifyPrototype(ctx, datePrototype, realm.getObjectPrototype());
        } else {
            datePrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        }
        JSObjectUtil.putConstructorProperty(datePrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, datePrototype, DatePrototypeBuiltins.BUILTINS);
        if (ctx.isOptionAnnexB()) {
            Object utcStringFunction = JSDynamicObject.getOrNull(datePrototype, Strings.TO_UTC_STRING);
            JSObjectUtil.putDataProperty(datePrototype, Strings.TO_GMT_STRING, utcStringFunction, JSAttributes.getDefaultNotEnumerable());
        }
        return datePrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, DateFunctionBuiltins.BUILTINS);
    }

    @CompilerDirectives.TruffleBoundary
    public static double executeConstructor(double[] argsEvaluated, boolean inputIsUTC) {
        double month;
        double year = argsEvaluated.length > 0 ? argsEvaluated[0] : Double.NaN;
        double d2 = month = argsEvaluated.length > 1 ? argsEvaluated[1] : 0.0;
        if (Double.isNaN(year) || Double.isInfinite(year) || Double.isNaN(month) || Double.isInfinite(month)) {
            return Double.NaN;
        }
        double day = JSDate.getArgOrDefault(argsEvaluated, 2, 1);
        double hour = JSDate.getArgOrDefault(argsEvaluated, 3, 0);
        double minute = JSDate.getArgOrDefault(argsEvaluated, 4, 0);
        double second = JSDate.getArgOrDefault(argsEvaluated, 5, 0);
        double ms = JSDate.getArgOrDefault(argsEvaluated, 6, 0);
        return JSDate.makeDate(JSDate.toFullYear(year), month, day, hour, minute, second, ms, inputIsUTC ? Integer.valueOf(0) : null);
    }

    private static double getArgOrDefault(double[] argsEvaluated, int index, int def) {
        if (argsEvaluated.length > index) {
            return argsEvaluated[index];
        }
        return def;
    }

    public static double day(double t2) {
        return JSDate.floor(t2 / 8.64E7);
    }

    private static double timeWithinDay(double t2) {
        return JSDate.secureNegativeModulo(t2, 8.64E7);
    }

    public static int dayFromYear(int y2) {
        return 365 * (y2 - 1970) + Math.floorDiv(y2 - 1969, 4) - Math.floorDiv(y2 - 1901, 100) + Math.floorDiv(y2 - 1601, 400);
    }

    @CompilerDirectives.TruffleBoundary
    public static int yearFromTime(long t2) {
        long daysAfter1970 = Math.floorDiv(t2, 86400000);
        assert (JSRuntime.longIsRepresentableAsInt(daysAfter1970));
        return JSDate.yearFromDays((int)daysAfter1970);
    }

    public static int yearFromDays(int daysAfter1970) {
        int daysAfter2000 = daysAfter1970 - 10957;
        int days = daysAfter2000 + 102267900;
        assert (days > 0) : days;
        int year = 400 * (days / 146097);
        int remainingDays = days % 146097;
        year += 100 * (--remainingDays / 36524);
        remainingDays %= 36524;
        year += 4 * (++remainingDays / 1461);
        remainingDays %= 1461;
        return (year += --remainingDays / 365) - 280000 + 2000;
    }

    public static boolean isLeapYear(int year) {
        if (year % 4 != 0) {
            return false;
        }
        if (year % 100 != 0) {
            return true;
        }
        return year % 400 == 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static int monthFromTime(double dt) {
        assert (JSRuntime.doubleIsRepresentableAsLong(dt));
        long t2 = (long)dt;
        int year = JSDate.yearFromTime(t2);
        boolean leapYear = JSDate.isLeapYear(year);
        int day = JSDate.dayWithinYear(t2, year);
        return JSDate.monthFromTimeIntl(leapYear, day);
    }

    private static int monthFromTimeIntl(boolean leapYear, int day) {
        assert (0 <= day && day < 365 + (leapYear ? 1 : 0)) : day;
        if (day < 31) {
            return 0;
        }
        if (!leapYear) {
            if (day < 59) {
                return 1;
            }
            if (day < 90) {
                return 2;
            }
            if (day < 120) {
                return 3;
            }
            if (day < 151) {
                return 4;
            }
            if (day < 181) {
                return 5;
            }
            if (day < 212) {
                return 6;
            }
            if (day < 243) {
                return 7;
            }
            if (day < 273) {
                return 8;
            }
            if (day < 304) {
                return 9;
            }
            if (day < 334) {
                return 10;
            }
            return 11;
        }
        if (day < 60) {
            return 1;
        }
        if (day < 91) {
            return 2;
        }
        if (day < 121) {
            return 3;
        }
        if (day < 152) {
            return 4;
        }
        if (day < 182) {
            return 5;
        }
        if (day < 213) {
            return 6;
        }
        if (day < 244) {
            return 7;
        }
        if (day < 274) {
            return 8;
        }
        if (day < 305) {
            return 9;
        }
        if (day < 335) {
            return 10;
        }
        return 11;
    }

    private static int dayWithinYear(long t2, int year) {
        return (int)Math.floorDiv(t2, 86400000) - JSDate.dayFromYear(year);
    }

    @CompilerDirectives.TruffleBoundary
    public static int dateFromTime(double dt) {
        assert (JSRuntime.doubleIsRepresentableAsLong(dt));
        long t2 = (long)dt;
        int year = JSDate.yearFromTime(t2);
        int day = JSDate.dayWithinYear(t2, year);
        return JSDate.dateFromDayInYear(year, day);
    }

    public static int dateFromDayInYear(int year, int day) {
        if (day < 31) {
            return day + 1;
        }
        boolean leapYear = JSDate.isLeapYear(year);
        int dayMinusLeap = day - (leapYear ? 1 : 0);
        switch (JSDate.monthFromTimeIntl(leapYear, day)) {
            case 1: {
                return day - 30;
            }
            case 2: {
                return dayMinusLeap - 58;
            }
            case 3: {
                return dayMinusLeap - 89;
            }
            case 4: {
                return dayMinusLeap - 119;
            }
            case 5: {
                return dayMinusLeap - 150;
            }
            case 6: {
                return dayMinusLeap - 180;
            }
            case 7: {
                return dayMinusLeap - 211;
            }
            case 8: {
                return dayMinusLeap - 242;
            }
            case 9: {
                return dayMinusLeap - 272;
            }
            case 10: {
                return dayMinusLeap - 303;
            }
            case 11: {
                return dayMinusLeap - 333;
            }
        }
        assert (false) : "should not reach here";
        return -1;
    }

    public static double weekDay(double t2) {
        int result = ((int)JSDate.day(t2) + 4) % 7;
        return result >= 0 ? (double)result : (double)(result + 7);
    }

    public static double localTime(double t2, Node node) {
        return t2 + (double)JSDate.localTZA(t2, true, node);
    }

    private static double utc(double t2, Node node) {
        return t2 - (double)JSDate.localTZA(t2, false, node);
    }

    public static long localTZA(double t2, boolean isUTC, Node node) {
        return JSDate.localTZA(t2, isUTC, JSRealm.get(node).getLocalTimeZone());
    }

    private static int getOffset(TimeZone timeZone, long date, int[] fields) {
        Grego.timeToFields(date, fields);
        return timeZone.getOffset(1, fields[0], fields[1], fields[2], fields[3], fields[5]);
    }

    private static int getOffset(TimeZone timeZone, long t2, boolean isUTC) {
        int dstOffset;
        int rawOffset = timeZone.getRawOffset();
        long date = isUTC ? t2 + (long)rawOffset : t2;
        int[] fields = new int[6];
        int offset = JSDate.getOffset(timeZone, date, fields);
        if (isUTC) {
            return offset;
        }
        if (offset != rawOffset) {
            int dstOffset2 = offset - rawOffset;
            return JSDate.getOffset(timeZone, date - (long)dstOffset2, fields);
        }
        int dstSavings = timeZone.getDSTSavings();
        if (dstSavings == 0) {
            dstSavings = 3600000;
        }
        if ((dstOffset = (offset = JSDate.getOffset(timeZone, date - (long)dstSavings, fields)) - rawOffset) != 0 && dstOffset != dstSavings) {
            offset = JSDate.getOffset(timeZone, date - (long)dstOffset, fields);
        }
        return offset;
    }

    @CompilerDirectives.TruffleBoundary
    public static int localTZA(double t2, boolean isUTC, TimeZone timeZone) {
        return JSDate.getOffset(timeZone, (long)t2, isUTC);
    }

    @CompilerDirectives.TruffleBoundary
    public static int hourFromTime(double t2) {
        return (int)JSDate.secureNegativeModulo(JSDate.floor(t2 / 3600000.0), 24.0);
    }

    @CompilerDirectives.TruffleBoundary
    public static int minFromTime(double t2) {
        return (int)JSDate.secureNegativeModulo(JSDate.floor(t2 / 60000.0), 60.0);
    }

    @CompilerDirectives.TruffleBoundary
    public static int secFromTime(double t2) {
        return (int)JSDate.secureNegativeModulo(JSDate.floor(t2 / 1000.0), 60.0);
    }

    @CompilerDirectives.TruffleBoundary
    public static int msFromTime(double t2) {
        return (int)JSDate.secureNegativeModulo(t2, 1000.0);
    }

    private static double secureNegativeModulo(double value, double modulo) {
        double result = value % modulo;
        if (result >= 0.0) {
            return result;
        }
        return result + modulo;
    }

    @CompilerDirectives.TruffleBoundary
    public static double makeTime(double hour, double min, double sec, double ms) {
        if (!(JSDate.isFinite(hour) && JSDate.isFinite(min) && JSDate.isFinite(sec) && JSDate.isFinite(ms))) {
            return Double.NaN;
        }
        double h2 = JSRuntime.truncateDouble(hour);
        double m2 = JSRuntime.truncateDouble(min);
        double s2 = JSRuntime.truncateDouble(sec);
        double milli = JSRuntime.truncateDouble(ms);
        return h2 * 3600000.0 + m2 * 60000.0 + s2 * 1000.0 + milli;
    }

    @CompilerDirectives.TruffleBoundary
    public static double makeDay(double year, double month, double date) {
        if (!(JSDate.isFinite(year) && JSDate.isFinite(month) && JSDate.isFinite(date))) {
            return Double.NaN;
        }
        double y2 = JSRuntime.truncateDouble(year);
        double m2 = JSRuntime.truncateDouble(month);
        double dt = JSRuntime.truncateDouble(date);
        double ym = y2 + JSDate.floor(m2 / 12.0);
        int mn = (int)(m2 % 12.0);
        if (mn < 0) {
            mn += 12;
        }
        if (ym < -300000.0 || ym > 300000.0) {
            return Double.NaN;
        }
        return (double)JSDate.isoDateToEpochDaysResolvedYM((int)ym, mn + 1, 1) + dt - 1.0;
    }

    @CompilerDirectives.TruffleBoundary
    public static long isoDateToEpochDays(int year, int month, int date) {
        int resolvedYear = year + month / 12;
        int resolvedMonth = month % 12;
        if (resolvedMonth < 0) {
            resolvedMonth += 12;
        }
        return JSDate.isoDateToEpochDaysResolvedYM(resolvedYear, resolvedMonth + 1, date);
    }

    @CompilerDirectives.TruffleBoundary
    private static long isoDateToEpochDaysResolvedYM(int y2, int m2, int date) {
        return LocalDate.of(y2, m2, 1).toEpochDay() + (long)date - 1L;
    }

    @CompilerDirectives.TruffleBoundary
    public static double makeDate(double day, double time) {
        if (!JSDate.isFinite(day) || !JSDate.isFinite(time)) {
            return Double.NaN;
        }
        return day * 8.64E7 + time;
    }

    @CompilerDirectives.TruffleBoundary
    public static double makeDate(double y2, double m2, double d2, double h2, double min, double sec, double ms, Integer timezone) {
        double day = JSDate.makeDay(y2, m2, d2);
        double time = JSDate.makeTime(h2, min, sec, ms);
        double date = JSDate.makeDate(day, time);
        date = timezone == null ? JSDate.utc(date, null) : (date -= (double)(timezone * 60000));
        return JSDate.timeClip(date);
    }

    public static double timeClip(double time) {
        if (Double.isInfinite(time) || Double.isNaN(time) || Math.abs(time) > 8.64E15) {
            return Double.NaN;
        }
        return Double.valueOf(time).longValue();
    }

    private static boolean isFinite(double d2) {
        return !Double.isNaN(d2) && !Double.isInfinite(d2);
    }

    private static double floor(double d2) {
        return Math.floor(d2);
    }

    public static JSDateObject create(JSContext context, JSRealm realm, double timeMillis) {
        JSObjectFactory factory = context.getDateFactory();
        return JSDate.create(factory, realm, factory.getPrototype(realm), timeMillis);
    }

    public static JSDateObject create(JSContext context, JSRealm realm, JSDynamicObject proto, double timeMillis) {
        JSObjectFactory factory = context.getDateFactory();
        return JSDate.create(factory, realm, proto, timeMillis);
    }

    private static JSDateObject create(JSObjectFactory factory, JSRealm realm, JSDynamicObject proto, double timeMillis) {
        Shape shape = factory.getShape(realm, proto);
        JSDateObject newObj = factory.initProto(new JSDateObject(shape, proto, timeMillis), realm, proto);
        return factory.trackAllocation(newObj);
    }

    public static double setTime(JSDateObject thisDate, double time) {
        double v2 = JSDate.timeClip(time);
        JSDate.setTimeMillisField(thisDate, v2);
        return v2;
    }

    public static double setMilliseconds(JSDateObject thisDate, double ms, boolean isUTC, Node node) {
        double t2 = JSDate.localTime(JSDate.getTimeMillisField(thisDate), isUTC, node);
        double time = JSDate.makeTime(JSDate.hourFromTime(t2), JSDate.minFromTime(t2), JSDate.secFromTime(t2), ms);
        double u2 = JSDate.timeClip(JSDate.utc(JSDate.makeDate(JSDate.day(t2), time), isUTC, node));
        JSDate.setTimeMillisField(thisDate, u2);
        return u2;
    }

    public static double setSeconds(JSDateObject thisDate, double s2, double ms, boolean msSpecified, boolean isUTC, Node node) {
        double t2 = JSDate.localTime(JSDate.getTimeMillisField(thisDate), isUTC, node);
        double milli = msSpecified ? ms : (double)JSDate.msFromTime(t2);
        double date = JSDate.makeDate(JSDate.day(t2), JSDate.makeTime(JSDate.hourFromTime(t2), JSDate.minFromTime(t2), s2, milli));
        double u2 = JSDate.timeClip(JSDate.utc(date, isUTC, node));
        JSDate.setTimeMillisField(thisDate, u2);
        return u2;
    }

    public static double setMinutes(JSDateObject thisDate, double m2, double s2, boolean sSpecified, double ms, boolean msSpecified, boolean isUTC, Node node) {
        double t2 = JSDate.localTime(JSDate.getTimeMillisField(thisDate), isUTC, node);
        double milli = msSpecified ? ms : (double)JSDate.msFromTime(t2);
        double sec = sSpecified ? s2 : (double)JSDate.secFromTime(t2);
        double date = JSDate.makeDate(JSDate.day(t2), JSDate.makeTime(JSDate.hourFromTime(t2), m2, sec, milli));
        double u2 = JSDate.timeClip(JSDate.utc(date, isUTC, node));
        JSDate.setTimeMillisField(thisDate, u2);
        return u2;
    }

    public static double setHours(JSDateObject thisDate, double h2, double m2, boolean mSpecified, double s2, boolean sSpecified, double ms, boolean msSpecified, boolean isUTC, Node node) {
        double t2 = JSDate.localTime(JSDate.getTimeMillisField(thisDate), isUTC, node);
        double milli = msSpecified ? ms : (double)JSDate.msFromTime(t2);
        double sec = sSpecified ? s2 : (double)JSDate.secFromTime(t2);
        double min = mSpecified ? m2 : (double)JSDate.minFromTime(t2);
        double date = JSDate.makeDate(JSDate.day(t2), JSDate.makeTime(h2, min, sec, milli));
        double u2 = JSDate.timeClip(JSDate.utc(date, isUTC, node));
        JSDate.setTimeMillisField(thisDate, u2);
        return u2;
    }

    public static double setDate(JSDateObject thisDate, double date, boolean isUTC, Node node) {
        double u2;
        double t2 = JSDate.localTime(JSDate.getTimeMillisField(thisDate), isUTC, node);
        if (Double.isNaN(t2)) {
            u2 = Double.NaN;
        } else {
            double newDate = JSDate.makeDate(JSDate.makeDay(JSDate.yearFromTime((long)t2), JSDate.monthFromTime(t2), date), JSDate.timeWithinDay(t2));
            u2 = JSDate.timeClip(JSDate.utc(newDate, isUTC, node));
        }
        JSDate.setTimeMillisField(thisDate, u2);
        return u2;
    }

    public static double setMonth(JSDateObject thisDate, double month, double date, boolean dateSpecified, boolean isUTC, Node node) {
        double newDate;
        double t2 = JSDate.localTime(JSDate.getTimeMillisField(thisDate), isUTC, node);
        if (Double.isNaN(t2)) {
            newDate = Double.NaN;
        } else {
            double dt = dateSpecified ? date : (double)JSDate.dateFromTime(t2);
            newDate = JSDate.timeClip(JSDate.utc(JSDate.makeDate(JSDate.makeDay(JSDate.yearFromTime((long)t2), month, dt), JSDate.timeWithinDay(t2)), isUTC, node));
        }
        JSDate.setTimeMillisField(thisDate, newDate);
        return newDate;
    }

    public static double setFullYear(JSDateObject thisDate, double year, double month, boolean monthSpecified, double date, boolean dateSpecified, boolean isUTC, Node node) {
        double timeFieldValue = JSDate.getTimeMillisField(thisDate);
        double t2 = Double.isNaN(timeFieldValue) ? 0.0 : JSDate.localTime(timeFieldValue, isUTC, node);
        double dt = dateSpecified ? date : (double)JSDate.dateFromTime(t2);
        double m2 = monthSpecified ? month : (double)JSDate.monthFromTime(t2);
        double newDate = JSDate.makeDate(JSDate.makeDay(year, m2, dt), JSDate.timeWithinDay(t2));
        double u2 = JSDate.timeClip(JSDate.utc(newDate, isUTC, node));
        JSDate.setTimeMillisField(thisDate, u2);
        return u2;
    }

    public static double setYear(JSDateObject thisDate, double year, Node node) {
        double t2 = JSDate.getTimeMillisField(thisDate);
        double d2 = t2 = Double.isNaN(t2) ? 0.0 : JSDate.localTime(t2, node);
        if (Double.isNaN(year)) {
            JSDate.setTimeMillisField(thisDate, Double.NaN);
            return Double.NaN;
        }
        double fullYear = JSDate.toFullYear(year);
        double r5 = JSDate.makeDay(fullYear, JSDate.monthFromTime(t2), JSDate.dateFromTime(t2));
        double r6 = JSDate.timeClip(JSDate.utc(JSDate.makeDate(r5, JSDate.timeWithinDay(t2)), node));
        JSDate.setTimeMillisField(thisDate, r6);
        return r6;
    }

    private static double toFullYear(double year) {
        if (-1.0 < year && year < 100.0) {
            return 1900 + (int)year;
        }
        return year;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString format(DateFormat format, double time) {
        return Strings.fromJavaString(format.format(time));
    }

    public static TruffleString toString(double time, JSRealm realm) {
        if (Double.isNaN(time)) {
            return INVALID_DATE_STRING;
        }
        return JSDate.format(realm.getDateToStringFormat(), time);
    }

    public static TruffleString toISOStringIntl(double time, JSRealm realm) {
        return JSDate.format(realm.getJSDateISOFormat(time), time);
    }

    public static boolean isTimeValid(double time) {
        return !Double.isNaN(time) && !Double.isInfinite(time);
    }

    private static double localTime(double time, boolean isUTC, Node node) {
        return isUTC ? time : JSDate.localTime(time, node);
    }

    private static double utc(double time, boolean isUTC, Node node) {
        return isUTC ? time : JSDate.utc(time, node);
    }

    public static boolean isValidDate(JSDateObject date) {
        return !Double.isNaN(JSDate.getTimeMillisField(date));
    }

    @CompilerDirectives.TruffleBoundary
    public static Instant asInstant(JSDateObject date) {
        assert (JSDate.isValidDate(date));
        return Instant.ofEpochMilli((long)JSDate.getTimeMillisField(date));
    }

    @CompilerDirectives.TruffleBoundary
    public static LocalDate asLocalDate(JSDateObject date, JSRealm realm) {
        return LocalDate.from(JSDate.asInstant(date).atZone(realm.getLocalTimeZoneId()));
    }

    @CompilerDirectives.TruffleBoundary
    public static LocalTime asLocalTime(JSDateObject date, JSRealm realm) {
        return LocalTime.from(JSDate.asInstant(date).atZone(realm.getLocalTimeZoneId()));
    }

    public static double getDateValueFromInstant(Object receiver, InteropLibrary interop) {
        Instant instant;
        try {
            instant = interop.asInstant(receiver);
        }
        catch (UnsupportedMessageException e2) {
            throw Errors.createTypeErrorInteropException(receiver, e2, "asInstant", null);
        }
        try {
            return instant.toEpochMilli();
        }
        catch (ArithmeticException e3) {
            return Double.NaN;
        }
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getDatePrototype();
    }
}

