/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.Strings;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public final class JSURLEncoder {
    static final BitSet unreservedURISet;
    static final BitSet reservedURISet;
    private final boolean isSpecial;
    private final Charset charset;

    public JSURLEncoder(boolean isSpecial) {
        this(isSpecial, StandardCharsets.UTF_8);
    }

    public JSURLEncoder(boolean isSpecial, Charset charset) {
        this.charset = charset;
        this.isSpecial = isSpecial;
    }

    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    public TruffleString encode(TruffleString s2) {
        int length = Strings.length(s2);
        TruffleStringBuilderUTF16 sb = null;
        CharsetEncoder encoder = null;
        int i2 = 0;
        String javaStr = Strings.toJavaString(s2);
        while (i2 < length) {
            char c2 = Strings.charAt(s2, i2);
            if (this.needsNoEncoding(c2)) {
                if (sb != null) {
                    Strings.builderAppend(sb, c2);
                }
                ++i2;
                continue;
            }
            if (sb == null) {
                sb = JSURLEncoder.allocStringBuilder(s2, i2, length + 16);
            }
            if (encoder == null) {
                encoder = this.charset.newEncoder();
            }
            i2 = this.encodeConvert(javaStr, i2, c2, sb, encoder);
        }
        return sb != null ? Strings.builderToString(sb) : s2;
    }

    static TruffleStringBuilderUTF16 allocStringBuilder(TruffleString s2, int i2, int estimatedLength) {
        TruffleStringBuilderUTF16 sb = Strings.builderCreate(estimatedLength);
        if (i2 > 0) {
            Strings.builderAppend(sb, s2, 0, i2);
        }
        return sb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int encodeConvert(String s2, int iParam, int cParam, TruffleStringBuilderUTF16 buffer, CharsetEncoder encoder) {
        char c2;
        int i2 = iParam;
        int c3 = cParam;
        int startPos = i2;
        do {
            if (56320 <= c3 && c3 <= 57343) {
                throw JSURLEncoder.cannotEscapeError();
            }
            if (c3 >= 55296 && c3 <= 56319) {
                if (i2 + 1 >= s2.length()) throw JSURLEncoder.cannotEscapeError();
                char d2 = s2.charAt(i2 + 1);
                if (d2 < '\udc00' || d2 > '\udfff') throw JSURLEncoder.cannotEscapeError();
                ++i2;
            }
            if (++i2 >= s2.length()) break;
            c2 = s2.charAt(i2);
            c3 = c2;
        } while (!this.needsNoEncoding(c2));
        ByteBuffer bb = JSURLEncoder.encodeSubstring(s2, startPos, i2, encoder);
        byte[] ba = bb.array();
        assert (bb.arrayOffset() + bb.position() == 0);
        int length = bb.limit();
        for (int j2 = 0; j2 < length; ++j2) {
            Strings.builderAppend(buffer, '%');
            char ch = JSURLEncoder.charForDigit(ba[j2] >> 4 & 0xF, 16);
            Strings.builderAppend(buffer, ch);
            ch = JSURLEncoder.charForDigit(ba[j2] & 0xF, 16);
            Strings.builderAppend(buffer, ch);
        }
        return i2;
    }

    public static char charForDigit(int digit, int radix) {
        assert (digit >= 0 && digit < radix && radix >= 2 && radix <= 36);
        if (digit < 10) {
            return (char)(48 + digit);
        }
        return (char)(55 + digit);
    }

    private static JSException cannotEscapeError() {
        throw Errors.createURIError("cannot escape");
    }

    private static ByteBuffer encodeSubstring(String s2, int off, int len, CharsetEncoder encoder) {
        CharBuffer cb = CharBuffer.wrap(s2, off, len);
        try {
            return encoder.encode(cb);
        }
        catch (CharacterCodingException ex) {
            throw JSURLEncoder.cannotEscapeError();
        }
    }

    private boolean needsNoEncoding(int c2) {
        if (this.isSpecial) {
            return unreservedURISet.get(c2) || reservedURISet.get(c2);
        }
        return unreservedURISet.get(c2);
    }

    static {
        BitSet unreserved = new BitSet(128);
        unreserved.set(97, 123);
        unreserved.set(65, 91);
        unreserved.set(48, 58);
        unreserved.set(45);
        unreserved.set(95);
        unreserved.set(46);
        unreserved.set(42);
        unreserved.set(33);
        unreserved.set(126);
        unreserved.set(39);
        unreserved.set(40);
        unreserved.set(41);
        BitSet reserved = new BitSet(128);
        reserved.set(59);
        reserved.set(47);
        reserved.set(63);
        reserved.set(58);
        reserved.set(64);
        reserved.set(38);
        reserved.set(61);
        reserved.set(43);
        reserved.set(36);
        reserved.set(44);
        reserved.set(35);
        unreservedURISet = unreserved;
        reservedURISet = reserved;
    }
}

