/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSWeakMap;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import java.util.Map;

public final class JSWeakMapObject
extends JSNonProxyObject {
    private final Map<Object, Object> weakHashMap;

    protected JSWeakMapObject(Shape shape, JSDynamicObject proto, Map<Object, Object> weakHashMap) {
        super(shape, proto);
        this.weakHashMap = weakHashMap;
    }

    public Map<Object, Object> getWeakHashMap() {
        return this.weakHashMap;
    }

    @Override
    public TruffleString getClassName() {
        return JSWeakMap.CLASS_NAME;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return Strings.addBrackets(this.getClassName());
        }
        return this.getClassName();
    }
}

