/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.NativeOptionValidator;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.util.function.Consumer;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolate;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolateThread;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObjectHandles;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageInfo;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.UnmanagedMemory;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.function.CEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;

final class NativeOptionValidatorGen {
    NativeOptionValidatorGen() {
    }

    static NativeOptionValidator createHSToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeOptionValidator createNativeToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeOptionValidator create(NativeIsolate nativeIsolate, long l2) {
        if (ImageInfo.inImageCode()) {
            return NativeOptionValidatorGen.createNativeToNative(nativeIsolate, l2);
        }
        return NativeOptionValidatorGen.createHSToNative(nativeIsolate, l2);
    }

    private static final class StartPoint
    extends NativeOptionValidator {
        private static final BinaryMarshaller<Object> objectWithOptionValueMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(NativeIsolate nativeIsolate, long l2) {
            super(nativeIsolate, l2);
        }

        @Override
        public void accept(Object object) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                int n2 = objectWithOptionValueMarshaller.inferSize(object);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create(n2);
                objectWithOptionValueMarshaller.write(byteArrayBinaryOutput, object);
                StartPoint.accept0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), byteArrayBinaryOutput.getArray());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native void accept0(long var0, long var2, byte[] var4);

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            objectWithOptionValueMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.OptionValue.class);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<Object> objectWithOptionValueMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeOptionValidatorGen_00024StartPoint_accept0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void accept(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JByteArray jByteArray) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeOptionValidatorGen::accept", jNIEnv);){
                Consumer consumer = NativeObjectHandles.resolve(l3, Consumer.class);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get(256);
                int n2 = JNIUtil.GetArrayLength(jNIEnv, jByteArray);
                CCharPointer cCharPointer2 = n2 <= 256 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc(n2);
                try {
                    JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray, 0, n2, cCharPointer2);
                    BinaryInput binaryInput = BinaryInput.create(cCharPointer2, n2);
                    Object object = objectWithOptionValueMarshaller.read(binaryInput);
                    consumer.accept(object);
                }
                finally {
                    if (cCharPointer2 != cCharPointer) {
                        UnmanagedMemory.free(cCharPointer2);
                    }
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            objectWithOptionValueMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.OptionValue.class);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

