/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedRuntimeAccessor;

@NodeInfo
public final class OptimizedIndirectCallNode
extends IndirectCallNode {
    @CompilerDirectives.CompilationFinal
    private Class<? extends Throwable> exceptionProfile;

    OptimizedIndirectCallNode() {
    }

    @Override
    public Object call(CallTarget target, Object ... arguments) {
        try {
            OptimizedCallTarget optimizedTarget = (OptimizedCallTarget)target;
            if (CompilerDirectives.isPartialEvaluationConstant(optimizedTarget)) {
                return optimizedTarget.callDirect(this, arguments);
            }
            return optimizedTarget.callIndirect(this, arguments);
        }
        catch (Throwable t2) {
            throw this.handleException(t2);
        }
    }

    private RuntimeException handleException(Throwable t2) {
        Throwable profiled = this.profileExceptionType(t2);
        OptimizedRuntimeAccessor.LANGUAGE.addStackFrameInfo(this, null, profiled, null);
        throw OptimizedCallTarget.rethrow(profiled);
    }

    private <T extends Throwable> T profileExceptionType(T value) {
        Class<? extends Throwable> clazz = this.exceptionProfile;
        if (clazz != Throwable.class) {
            if (clazz != null && value.getClass() == clazz) {
                if (CompilerDirectives.inInterpreter()) {
                    return value;
                }
                return (T)CompilerDirectives.castExact(value, clazz);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.exceptionProfile = clazz == null ? value.getClass() : Throwable.class;
        }
        return value;
    }
}

