/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.core.network;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integratedscripting.api.network.IScript;
import org.cyclops.integratedscripting.api.network.IScriptFactory;
import org.cyclops.integratedscripting.api.network.IScriptingData;
import org.cyclops.integratedscripting.core.network.GraalScript;
import org.cyclops.integratedscripting.core.network.ScriptingNetworkHelpers;
import org.cyclops.integratedscripting.evaluate.EvaluationExceptionResolutionHelpers;
import org.cyclops.integratedscripting.evaluate.ScriptHelpers;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.PolyglotException;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Source;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;
import org.jetbrains.annotations.Nullable;

public class GraalScriptFactory
implements IScriptFactory {
    private final String languageId;

    public GraalScriptFactory(String languageId) {
        this.languageId = languageId;
    }

    @Override
    @Nullable
    public IScript getScript(int disk, Path path) throws EvaluationException {
        Pair<OutputStream, OutputStream> outputStreams = ScriptingNetworkHelpers.getScriptingData().getOutputStreams(disk, path);
        Context graalContext = ScriptHelpers.createPopulatedContext(contextBuilder -> contextBuilder.out((OutputStream)outputStreams.getLeft()).err((OutputStream)outputStreams.getRight()), ValueDeseralizationContext.ofAllEnabled());
        Value languageBinding = graalContext.getBindings("js");
        try {
            Source source = Source.newBuilder(this.languageId, ScriptingNetworkHelpers.getScriptingData().getScripts(disk).get(path), path.toString()).build();
            try {
                graalContext.eval(source);
            }
            catch (PolyglotException e2) {
                throw EvaluationExceptionResolutionHelpers.resolveOnScriptChange(new EvaluationException(Component.translatable((String)"script.integratedscripting.error.script_read", (Object[])new Object[]{path.toString(), disk, e2.getMessage()})), disk, path);
            }
            Wrapper diskListener = new Wrapper();
            return new GraalScript(graalContext, languageBinding, scriptInvalidateListener -> {
                diskListener.set(scriptPathRelative -> {
                    if (scriptPathRelative.equals(path)) {
                        scriptInvalidateListener.invalidate();
                    }
                });
                ScriptingNetworkHelpers.getScriptingData().addListener(disk, (IScriptingData.IDiskScriptsChangeListener)diskListener.get());
            }, () -> {
                if (diskListener.get() != null) {
                    ScriptingNetworkHelpers.getScriptingData().removeListener(disk, (IScriptingData.IDiskScriptsChangeListener)diskListener.get());
                }
            }, disk, path, null, ValueDeseralizationContext.ofAllEnabled());
        }
        catch (IOException e3) {
            throw EvaluationExceptionResolutionHelpers.resolveOnScriptChange(new EvaluationException(Component.translatable((String)"script.integratedscripting.error.script_read", (Object[])new Object[]{path.toString(), disk, e3.getMessage()})), disk, path);
        }
    }
}

