/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.evaluate;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integratedscripting.api.network.IScriptingData;
import org.cyclops.integratedscripting.core.network.ScriptingNetworkHelpers;

public class EvaluationExceptionResolutionHelpers {
    private static final ReferenceQueue<? super EvaluationException> EVALUATION_EXCEPTION_REFERENCE_QUEUE = new ReferenceQueue();

    public static EvaluationException resolveOnScriptChange(EvaluationException evaluationException, int disk, Path path) {
        Wrapper listener = new Wrapper();
        listener.set((Object)EvaluationExceptionResolutionHelpers.createListener(new EvaluationExceptionReference(evaluationException, EVALUATION_EXCEPTION_REFERENCE_QUEUE, disk, (Wrapper<IScriptingData.IDiskScriptsChangeListener>)listener), disk, path));
        ScriptingNetworkHelpers.getScriptingData().addListener(disk, (IScriptingData.IDiskScriptsChangeListener)listener.get());
        return evaluationException;
    }

    public static void expungeStaleEvaluationExceptions() {
        Reference<? super EvaluationException> x2;
        while ((x2 = EVALUATION_EXCEPTION_REFERENCE_QUEUE.poll()) != null) {
            ((EvaluationExceptionReference)x2).removeListener();
        }
    }

    protected static IScriptingData.IDiskScriptsChangeListener createListener(EvaluationExceptionReference evaluationExceptionReference, int disk, Path path) {
        return scriptPathRelative -> {
            if (scriptPathRelative.equals(path)) {
                EvaluationException exception = (EvaluationException)evaluationExceptionReference.get();
                if (exception != null) {
                    exception.resolve();
                }
                ScriptingNetworkHelpers.getScriptingData().removeListener(disk, (IScriptingData.IDiskScriptsChangeListener)evaluationExceptionReference.listener.get());
            }
        };
    }

    public static class EvaluationExceptionReference
    extends WeakReference<EvaluationException> {
        private final int disk;
        private final Wrapper<IScriptingData.IDiskScriptsChangeListener> listener;

        public EvaluationExceptionReference(EvaluationException referent, ReferenceQueue<? super EvaluationException> queue, int disk, Wrapper<IScriptingData.IDiskScriptsChangeListener> listener) {
            super(referent, queue);
            this.disk = disk;
            this.listener = listener;
        }

        public void removeListener() {
            ScriptingNetworkHelpers.getScriptingData().removeListener(this.disk, (IScriptingData.IDiskScriptsChangeListener)this.listener.get());
        }
    }
}

