/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.impl.DispatchOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class DelegatingOutputStream
extends OutputStream {
    private final OutputStream out;
    private final DispatchOutputStream delegate;

    DelegatingOutputStream(OutputStream out, DispatchOutputStream delegate) {
        this.out = out;
        this.delegate = delegate;
    }

    @Override
    public void write(int b2) throws IOException {
        DispatchOutputStream.OutputStreamList outs = this.delegate.getOutList();
        if (outs != null) {
            outs.writeMulti(b2);
        }
        this.out.write(b2);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        DispatchOutputStream.OutputStreamList outs = this.delegate.getOutList();
        if (outs != null) {
            outs.writeMulti(b2);
        }
        this.out.write(b2);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        DispatchOutputStream.OutputStreamList outs = this.delegate.getOutList();
        if (outs != null) {
            outs.writeMulti(b2, off, len);
        }
        this.out.write(b2, off, len);
    }

    @Override
    public void flush() throws IOException {
        DispatchOutputStream.OutputStreamList outs = this.delegate.getOutList();
        if (outs != null) {
            outs.flushMulti();
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        DispatchOutputStream.OutputStreamList outs = this.delegate.getOutList();
        if (outs != null) {
            outs.closeMulti();
        }
        this.out.close();
    }
}

