/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractInternalNode;
import com.oracle.truffle.api.strings.AbstractPublicNode;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.DecodingErrorHandler;
import com.oracle.truffle.api.strings.Encodings;
import com.oracle.truffle.api.strings.InternalErrors;
import com.oracle.truffle.api.strings.JCodings;
import com.oracle.truffle.api.strings.TSCodeRange;
import com.oracle.truffle.api.strings.TStringConstants;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringOps;
import com.oracle.truffle.api.strings.TStringOpsNodes;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIteratorFactory;

public final class TruffleStringIterator {
    final AbstractTruffleString a;
    final Object arrayA;
    final byte codeRangeA;
    final TruffleString.Encoding encoding;
    final TruffleString.ErrorHandling errorHandling;
    private int rawIndex;

    TruffleStringIterator(AbstractTruffleString a2, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, TruffleString.ErrorHandling errorHandling, int rawIndex) {
        assert (TSCodeRange.isCodeRange(codeRangeA));
        this.a = a2;
        this.arrayA = arrayA;
        this.codeRangeA = (byte)codeRangeA;
        this.encoding = encoding;
        this.errorHandling = errorHandling;
        this.rawIndex = rawIndex;
    }

    public boolean hasNext() {
        return this.rawIndex < this.a.length();
    }

    public boolean hasPrevious() {
        return this.rawIndex > 0;
    }

    public int getByteIndex() {
        return this.rawIndex << this.encoding.naturalStride;
    }

    private int applyErrorHandler(DecodingErrorHandler errorHandler, int startIndex) {
        return this.applyErrorHandler(errorHandler, startIndex, true);
    }

    private int applyErrorHandlerReverse(DecodingErrorHandler errorHandler, int startIndex) {
        return this.applyErrorHandler(errorHandler, startIndex, false);
    }

    private int applyErrorHandler(DecodingErrorHandler errorHandler, int startIndex, boolean forward) {
        CompilerAsserts.partialEvaluationConstant(errorHandler);
        CompilerAsserts.partialEvaluationConstant(forward);
        if (TStringGuards.isReturnNegative(errorHandler)) {
            return -1;
        }
        if (TStringGuards.isBuiltin(errorHandler)) {
            return Encodings.invalidCodepoint();
        }
        int byteEnd = this.getByteIndex();
        this.rawIndex = startIndex;
        int byteStart = this.getByteIndex();
        int estimatedByteLength = forward ? byteEnd - byteStart : byteStart - byteEnd;
        DecodingErrorHandler.Result result = errorHandler.apply(this.a, byteStart, estimatedByteLength);
        this.errorHandlerSkipBytes(result.byteLength(), forward);
        return result.codepoint();
    }

    void errorHandlerSkipBytes(int byteLength, boolean forward) {
        int rawLength = byteLength >> this.encoding.naturalStride;
        if (rawLength == 0) {
            throw InternalErrors.illegalState("custom error handler consumed less than one char / int value");
        }
        if (forward) {
            this.rawIndex += rawLength;
            if (Integer.compareUnsigned(this.rawIndex, this.a.length()) > 0) {
                throw InternalErrors.illegalState("custom error handler consumed more bytes than string length");
            }
        } else {
            this.rawIndex -= rawLength;
            if (this.rawIndex < 0) {
                throw InternalErrors.illegalState("custom error handler consumed more bytes than string length");
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public int nextUncached() {
        return NextNode.getUncached().execute(this);
    }

    @CompilerDirectives.TruffleBoundary
    public int previousUncached() {
        return PreviousNode.getUncached().execute(this);
    }

    int getRawIndex() {
        return this.rawIndex;
    }

    void setRawIndex(int i2) {
        this.rawIndex = i2;
    }

    private int readFwdS0() {
        assert (this.a.stride() == 0);
        assert (this.hasNext());
        return TStringOps.readS0(this.a, this.arrayA, this.rawIndex);
    }

    private int readFwdS1() {
        assert (this.a.stride() == 1);
        assert (this.hasNext());
        return TStringOps.readS1(this.a, this.arrayA, this.rawIndex);
    }

    private int readBckS1() {
        assert (this.a.stride() == 1);
        assert (this.hasPrevious());
        return TStringOps.readS1(this.a, this.arrayA, this.rawIndex - 1);
    }

    private static int readAndInc(Node node, TruffleStringIterator it, TStringOpsNodes.RawReadValueNode readNode) {
        assert (it.hasNext());
        return readNode.execute(node, it.a, it.arrayA, it.rawIndex++);
    }

    private int readAndIncS0() {
        assert (this.a.stride() == 0);
        assert (this.hasNext());
        return TStringOps.readS0(this.a, this.arrayA, this.rawIndex++);
    }

    private int readAndIncS1() {
        assert (this.a.stride() == 1);
        assert (this.hasNext());
        return TStringOps.readS1(this.a, this.arrayA, this.rawIndex++);
    }

    private static int readAndDec(Node node, TruffleStringIterator it, TStringOpsNodes.RawReadValueNode readNode) {
        assert (it.hasPrevious());
        return readNode.execute(node, it.a, it.arrayA, --it.rawIndex);
    }

    private int readAndDecS0() {
        assert (this.a.stride() == 0);
        assert (this.hasPrevious());
        return TStringOps.readS0(this.a, this.arrayA, --this.rawIndex);
    }

    private int readAndDecS1() {
        assert (this.a.stride() == 1);
        assert (this.hasPrevious());
        return TStringOps.readS1(this.a, this.arrayA, --this.rawIndex);
    }

    private boolean curIsUtf8ContinuationByte() {
        return Encodings.isUTF8ContinuationByte(this.readFwdS0());
    }

    static int indexOf(Node location, TruffleStringIterator it, int codepoint, int fromIndex, int toIndex, InternalNextNode nextNode) {
        int aCodepointIndex = 0;
        while (aCodepointIndex < fromIndex && it.hasNext()) {
            nextNode.execute(location, it);
            TStringConstants.truffleSafePointPoll(location, ++aCodepointIndex);
        }
        if (aCodepointIndex < fromIndex) {
            return -1;
        }
        while (it.hasNext() && aCodepointIndex < toIndex) {
            if (nextNode.execute(location, it) == codepoint) {
                return aCodepointIndex;
            }
            TStringConstants.truffleSafePointPoll(location, ++aCodepointIndex);
        }
        return -1;
    }

    static int lastIndexOf(Node location, TruffleStringIterator it, int codepoint, int fromIndex, int toIndex, InternalNextNode nextNode) {
        int aCodepointIndex = 0;
        int result = -1;
        while (aCodepointIndex < fromIndex && it.hasNext()) {
            if (nextNode.execute(location, it) == codepoint) {
                result = aCodepointIndex;
            }
            TStringConstants.truffleSafePointPoll(location, ++aCodepointIndex);
        }
        if (aCodepointIndex < toIndex) {
            return -1;
        }
        return result;
    }

    static int indexOfString(Node node, TruffleStringIterator aIt, TruffleStringIterator bIt, int fromIndex, int toIndex, InternalNextNode nextNodeA, InternalNextNode nextNodeB) {
        if (!bIt.hasNext()) {
            return fromIndex;
        }
        int aCodepointIndex = 0;
        while (aCodepointIndex < fromIndex && aIt.hasNext()) {
            nextNodeA.execute(node, aIt);
            TStringConstants.truffleSafePointPoll(node, ++aCodepointIndex);
        }
        if (aCodepointIndex < fromIndex) {
            return -1;
        }
        int bFirst = nextNodeB.execute(node, bIt);
        int bSecondIndex = bIt.getRawIndex();
        while (aIt.hasNext() && aCodepointIndex < toIndex) {
            if (nextNodeA.execute(node, aIt) == bFirst) {
                if (!bIt.hasNext()) {
                    return aCodepointIndex;
                }
                int aCurIndex = aIt.getRawIndex();
                int innerLoopCount = 0;
                while (bIt.hasNext()) {
                    if (!aIt.hasNext()) {
                        return -1;
                    }
                    if (nextNodeA.execute(node, aIt) != nextNodeB.execute(node, bIt)) break;
                    if (!bIt.hasNext()) {
                        return aCodepointIndex;
                    }
                    TStringConstants.truffleSafePointPoll(node, ++innerLoopCount);
                }
                aIt.setRawIndex(aCurIndex);
                bIt.setRawIndex(bSecondIndex);
            }
            TStringConstants.truffleSafePointPoll(node, ++aCodepointIndex);
        }
        return -1;
    }

    static int byteIndexOfString(Node node, TruffleStringIterator aIt, TruffleStringIterator bIt, int fromByteIndex, int toByteIndex, InternalNextNode nextNodeA, InternalNextNode nextNodeB) {
        if (!bIt.hasNext()) {
            return fromByteIndex;
        }
        aIt.setRawIndex(fromByteIndex);
        int bFirst = nextNodeB.execute(node, bIt);
        int bSecondIndex = bIt.getRawIndex();
        int loopCount = 0;
        while (aIt.hasNext() && aIt.getRawIndex() < toByteIndex) {
            int ret = aIt.getRawIndex();
            if (nextNodeA.execute(node, aIt) == bFirst) {
                if (!bIt.hasNext()) {
                    return ret;
                }
                int aCurIndex = aIt.getRawIndex();
                while (bIt.hasNext()) {
                    if (!aIt.hasNext()) {
                        return -1;
                    }
                    if (nextNodeA.execute(node, aIt) != nextNodeB.execute(node, bIt)) break;
                    if (!bIt.hasNext()) {
                        return ret;
                    }
                    TStringConstants.truffleSafePointPoll(node, ++loopCount);
                }
                aIt.setRawIndex(aCurIndex);
                bIt.setRawIndex(bSecondIndex);
            }
            TStringConstants.truffleSafePointPoll(node, ++loopCount);
        }
        return -1;
    }

    static int lastIndexOfString(Node node, TruffleStringIterator aIt, TruffleStringIterator bIt, int fromIndex, int toIndex, InternalNextNode nextNodeA, InternalPreviousNode prevNodeA, InternalPreviousNode prevNodeB) {
        if (!bIt.hasPrevious()) {
            return fromIndex;
        }
        int bFirstCodePoint = prevNodeB.execute(node, bIt, DecodingErrorHandler.DEFAULT);
        int lastMatchIndex = -1;
        int lastMatchByteIndex = -1;
        int aCodepointIndex = 0;
        while (aCodepointIndex < fromIndex && aIt.hasNext()) {
            if (nextNodeA.execute(node, aIt) == bFirstCodePoint) {
                lastMatchIndex = aCodepointIndex;
                lastMatchByteIndex = aIt.getRawIndex();
            }
            TStringConstants.truffleSafePointPoll(node, ++aCodepointIndex);
        }
        if (aCodepointIndex < fromIndex || lastMatchIndex < 0) {
            return -1;
        }
        aCodepointIndex = lastMatchIndex;
        aIt.setRawIndex(lastMatchByteIndex);
        int bSecondIndex = bIt.getRawIndex();
        while (aIt.hasPrevious() && aCodepointIndex >= toIndex) {
            if (prevNodeA.execute(node, aIt, DecodingErrorHandler.DEFAULT) == bFirstCodePoint) {
                if (!bIt.hasPrevious()) {
                    return aCodepointIndex;
                }
                int aCurIndex = aIt.getRawIndex();
                int aCurCodePointIndex = aCodepointIndex;
                while (bIt.hasPrevious()) {
                    if (!aIt.hasPrevious()) {
                        return -1;
                    }
                    if (prevNodeA.execute(node, aIt, DecodingErrorHandler.DEFAULT) != prevNodeB.execute(node, bIt, DecodingErrorHandler.DEFAULT)) break;
                    if (!bIt.hasPrevious() && --aCurCodePointIndex >= toIndex) {
                        return aCurCodePointIndex;
                    }
                    TStringConstants.truffleSafePointPoll(node, aCurCodePointIndex);
                }
                aIt.setRawIndex(aCurIndex);
                bIt.setRawIndex(bSecondIndex);
            }
            TStringConstants.truffleSafePointPoll(node, --aCodepointIndex);
        }
        return -1;
    }

    static int lastByteIndexOfString(Node node, TruffleStringIterator aIt, TruffleStringIterator bIt, int fromByteIndex, int toByteIndex, InternalNextNode nextNodeA, InternalPreviousNode prevNodeA, InternalPreviousNode prevNodeB) {
        if (!bIt.hasPrevious()) {
            return fromByteIndex;
        }
        int bFirstCodePoint = prevNodeB.execute(node, bIt, DecodingErrorHandler.DEFAULT);
        int lastMatchByteIndex = -1;
        int loopCount = 0;
        while (aIt.getRawIndex() < fromByteIndex && aIt.hasNext()) {
            if (nextNodeA.execute(node, aIt) == bFirstCodePoint) {
                lastMatchByteIndex = aIt.getRawIndex();
            }
            TStringConstants.truffleSafePointPoll(node, ++loopCount);
        }
        if (aIt.getRawIndex() < fromByteIndex || lastMatchByteIndex < 0) {
            return -1;
        }
        aIt.setRawIndex(lastMatchByteIndex);
        int bSecondIndex = bIt.getRawIndex();
        while (aIt.hasPrevious() && aIt.getRawIndex() > toByteIndex) {
            if (prevNodeA.execute(node, aIt, DecodingErrorHandler.DEFAULT) == bFirstCodePoint) {
                if (!bIt.hasPrevious()) {
                    return aIt.getRawIndex();
                }
                int aCurIndex = aIt.getRawIndex();
                while (bIt.hasPrevious()) {
                    if (!aIt.hasPrevious()) {
                        return -1;
                    }
                    if (prevNodeA.execute(node, aIt, DecodingErrorHandler.DEFAULT) != prevNodeB.execute(node, bIt, DecodingErrorHandler.DEFAULT)) break;
                    if (!bIt.hasPrevious() && aIt.getRawIndex() >= toByteIndex) {
                        return aIt.getRawIndex();
                    }
                    TStringConstants.truffleSafePointPoll(node, ++loopCount);
                }
                aIt.setRawIndex(aCurIndex);
                bIt.setRawIndex(bSecondIndex);
            }
            TStringConstants.truffleSafePointPoll(node, ++loopCount);
        }
        return -1;
    }

    public static abstract class NextNode
    extends AbstractPublicNode {
        NextNode() {
        }

        public abstract int execute(TruffleStringIterator var1);

        @Specialization
        final int doDefault(TruffleStringIterator it, @Cached InternalNextNode nextNode, @Cached InlinedConditionProfile errorHandlerProfile) {
            if (errorHandlerProfile.profile(this, it.errorHandling == TruffleString.ErrorHandling.BEST_EFFORT)) {
                return nextNode.execute(this, it, DecodingErrorHandler.DEFAULT);
            }
            return nextNode.execute(this, it, DecodingErrorHandler.RETURN_NEGATIVE);
        }

        @NeverDefault
        public static NextNode create() {
            return TruffleStringIteratorFactory.NextNodeGen.create();
        }

        public static NextNode getUncached() {
            return TruffleStringIteratorFactory.NextNodeGen.getUncached();
        }
    }

    public static abstract class PreviousNode
    extends AbstractPublicNode {
        PreviousNode() {
        }

        public abstract int execute(TruffleStringIterator var1);

        @Specialization
        final int doDefault(TruffleStringIterator it, @Cached InternalPreviousNode previousNode, @Cached InlinedConditionProfile errorHandlerProfile) {
            if (errorHandlerProfile.profile(this, it.errorHandling == TruffleString.ErrorHandling.BEST_EFFORT)) {
                return previousNode.execute(this, it, DecodingErrorHandler.DEFAULT);
            }
            return previousNode.execute(this, it, DecodingErrorHandler.RETURN_NEGATIVE);
        }

        @NeverDefault
        public static PreviousNode create() {
            return TruffleStringIteratorFactory.PreviousNodeGen.create();
        }

        public static PreviousNode getUncached() {
            return TruffleStringIteratorFactory.PreviousNodeGen.getUncached();
        }
    }

    static abstract class InternalNextNode
    extends AbstractInternalNode {
        InternalNextNode() {
        }

        final int execute(Node node, TruffleStringIterator it) {
            return this.execute(node, it, DecodingErrorHandler.DEFAULT);
        }

        final int execute(Node node, TruffleStringIterator it, DecodingErrorHandler errorHandler) {
            if (!it.hasNext()) {
                throw InternalErrors.illegalState("end of string has been reached already");
            }
            CompilerAsserts.partialEvaluationConstant(errorHandler);
            return this.executeInternal(node, it, errorHandler);
        }

        abstract int executeInternal(Node var1, TruffleStringIterator var2, DecodingErrorHandler var3);

        @Specialization(guards={"isUTF32(it.encoding) || isFixedWidth(it.codeRangeA)", "isDefaultVariant(errorHandler)"})
        static int fixed(Node node, TruffleStringIterator it, DecodingErrorHandler errorHandler, @Cached.Shared(value="readRaw") @Cached TStringOpsNodes.RawReadValueNode readNode) {
            return TruffleStringIterator.readAndInc(node, it, readNode);
        }

        @Specialization(guards={"isUpToValidFixedWidth(it.codeRangeA)"})
        static int fixedValid(Node node, TruffleStringIterator it, DecodingErrorHandler errorHandler, @Cached.Shared(value="readRaw") @Cached TStringOpsNodes.RawReadValueNode readNode) {
            return TruffleStringIterator.readAndInc(node, it, readNode);
        }

        @Specialization(guards={"isAscii(it.encoding)", "isBroken(it.codeRangeA)", "!isDefaultVariant(errorHandler)"})
        static int brokenAscii(Node node, TruffleStringIterator it, DecodingErrorHandler errorHandler, @Cached.Shared(value="readRaw") @Cached TStringOpsNodes.RawReadValueNode readNode) {
            int codepoint = TruffleStringIterator.readAndInc(node, it, readNode);
            if (codepoint < 128) {
                return codepoint;
            }
            return it.applyErrorHandler(errorHandler, it.rawIndex - 1);
        }

        @Specialization(guards={"isUTF32(it.encoding)", "isBroken(it.codeRangeA)", "!isDefaultVariant(errorHandler)"})
        static int brokenUTF32(Node node, TruffleStringIterator it, DecodingErrorHandler errorHandler, @Cached.Shared(value="readRaw") @Cached TStringOpsNodes.RawReadValueNode readNode) {
            int codepoint = TruffleStringIterator.readAndInc(node, it, readNode);
            if (Encodings.isValidUnicodeCodepoint(codepoint)) {
                return codepoint;
            }
            return it.applyErrorHandler(errorHandler, it.rawIndex - 1);
        }

        @Specialization(guards={"isUTF8(it.encoding)", "isValid(it.codeRangeA)"})
        static int utf8Valid(TruffleStringIterator it, DecodingErrorHandler errorHandler) {
            int b2 = it.readAndIncS0();
            if (b2 < 128) {
                return b2;
            }
            int nBytes = Integer.numberOfLeadingZeros(~(b2 << 24));
            int codepoint = b2 & 255 >>> nBytes;
            assert (1 < nBytes && nBytes < 5) : nBytes;
            assert (it.rawIndex + nBytes - 1 <= it.a.length());
            switch (nBytes) {
                case 4: {
                    assert (it.curIsUtf8ContinuationByte());
                    codepoint = codepoint << 6 | it.readAndIncS0() & 0x3F;
                }
                case 3: {
                    assert (it.curIsUtf8ContinuationByte());
                    codepoint = codepoint << 6 | it.readAndIncS0() & 0x3F;
                }
            }
            assert (it.curIsUtf8ContinuationByte());
            codepoint = codepoint << 6 | it.readAndIncS0() & 0x3F;
            return codepoint;
        }

        @Specialization(guards={"isUTF8(it.encoding)", "isBroken(it.codeRangeA)"})
        static int utf8Broken(TruffleStringIterator it, DecodingErrorHandler errorHandler) {
            byte type;
            int startIndex = it.rawIndex;
            int b2 = it.readAndIncS0();
            if (b2 < 128) {
                return b2;
            }
            int nBytes = Encodings.utf8CodePointLength(b2);
            int codepoint = b2 & 255 >>> nBytes;
            byte[] stateMachine = Encodings.getUTF8DecodingStateMachine(errorHandler);
            byte state = stateMachine[256 + (type = stateMachine[b2])];
            if (state != 12) {
                int maxIndex = Math.min(it.a.length(), it.rawIndex - 1 + nBytes);
                while (it.rawIndex < maxIndex && (state = stateMachine[256 + state + (type = stateMachine[b2 = it.readFwdS0()])]) != 12) {
                    codepoint = b2 & 0x3F | codepoint << 6;
                    ++it.rawIndex;
                }
            }
            if (state == 0) {
                return codepoint;
            }
            if (TStringGuards.isDefaultVariant(errorHandler)) {
                if (errorHandler == DecodingErrorHandler.DEFAULT) {
                    it.rawIndex = startIndex + 1;
                }
                return Encodings.invalidCodepoint();
            }
            if (errorHandler == DecodingErrorHandler.RETURN_NEGATIVE) {
                it.rawIndex = startIndex + 1;
            }
            return it.applyErrorHandler(errorHandler, startIndex);
        }

        @Specialization(guards={"isUTF16(it.encoding)", "isValid(it.codeRangeA)"})
        static int utf16Valid(TruffleStringIterator it, DecodingErrorHandler errorHandler) {
            char c2 = (char)it.readAndIncS1();
            if (Encodings.isUTF16HighSurrogate(c2)) {
                assert (it.hasNext());
                assert (Encodings.isUTF16LowSurrogate(it.readFwdS1()));
                return Character.toCodePoint(c2, (char)it.readAndIncS1());
            }
            return c2;
        }

        @Specialization(guards={"isUTF16(it.encoding)", "isBroken(it.codeRangeA)"})
        static int utf16Broken(TruffleStringIterator it, DecodingErrorHandler errorHandler) {
            char c2 = (char)it.readAndIncS1();
            if (TStringGuards.isReturnNegative(errorHandler) || !TStringGuards.isBuiltin(errorHandler)) {
                if (Encodings.isUTF16Surrogate(c2)) {
                    char c22;
                    if (Encodings.isUTF16HighSurrogate(c2) && it.hasNext() && Encodings.isUTF16LowSurrogate(c22 = (char)it.readFwdS1())) {
                        ++it.rawIndex;
                        return Character.toCodePoint(c2, c22);
                    }
                    return it.applyErrorHandler(errorHandler, it.rawIndex - 1);
                }
            } else {
                char c23;
                assert (TStringGuards.isDefaultVariant(errorHandler));
                if (Encodings.isUTF16HighSurrogate(c2) && it.hasNext() && Encodings.isUTF16LowSurrogate(c23 = (char)it.readFwdS1())) {
                    ++it.rawIndex;
                    return Character.toCodePoint(c2, c23);
                }
            }
            return c2;
        }

        @Specialization(guards={"isUnsupportedEncoding(it.encoding)"})
        static int unsupported(TruffleStringIterator it, DecodingErrorHandler errorHandler) {
            assert (it.hasNext());
            JCodings jcodings = JCodings.getInstance();
            byte[] bytes = JCodings.asByteArray(it.arrayA);
            int startIndex = it.rawIndex;
            int p2 = it.a.byteArrayOffset() + it.rawIndex;
            int end = it.a.byteArrayOffset() + it.a.length();
            int length = jcodings.getCodePointLength(it.encoding, bytes, p2, end);
            int codepoint = 0;
            if (length < 1) {
                it.rawIndex = length < -1 ? it.a.length() : ++it.rawIndex;
            } else {
                it.rawIndex += length;
                codepoint = jcodings.readCodePoint(it.encoding, bytes, p2, end, errorHandler);
            }
            if (length < 1 || !jcodings.isValidCodePoint(it.encoding, codepoint)) {
                return it.applyErrorHandler(errorHandler, startIndex);
            }
            return codepoint;
        }
    }

    static abstract class InternalPreviousNode
    extends AbstractInternalNode {
        InternalPreviousNode() {
        }

        public final int execute(Node node, TruffleStringIterator it, DecodingErrorHandler errorHandler) {
            if (!it.hasPrevious()) {
                throw InternalErrors.illegalState("beginning of string has been reached already");
            }
            return this.executeInternal(node, it, errorHandler);
        }

        abstract int executeInternal(Node var1, TruffleStringIterator var2, DecodingErrorHandler var3);

        @Specialization(guards={"isFixedWidth(it.codeRangeA)", "isDefaultVariant(errorHandler)"})
        static int fixed(Node node, TruffleStringIterator it, DecodingErrorHandler errorHandler, @Cached.Shared(value="readRaw") @Cached TStringOpsNodes.RawReadValueNode readNode) {
            return TruffleStringIterator.readAndDec(node, it, readNode);
        }

        @Specialization(guards={"isUpToValidFixedWidth(it.codeRangeA)", "!isDefaultVariant(errorHandler)"})
        static int fixedValid(Node node, TruffleStringIterator it, DecodingErrorHandler errorHandler, @Cached.Shared(value="readRaw") @Cached TStringOpsNodes.RawReadValueNode readNode) {
            return TruffleStringIterator.readAndDec(node, it, readNode);
        }

        @Specialization(guards={"isAscii(it.encoding)", "isBroken(it.codeRangeA)", "!isDefaultVariant(errorHandler)"})
        static int brokenAscii(Node node, TruffleStringIterator it, DecodingErrorHandler errorHandler, @Cached.Shared(value="readRaw") @Cached TStringOpsNodes.RawReadValueNode readNode) {
            int codepoint = TruffleStringIterator.readAndDec(node, it, readNode);
            if (codepoint < 128) {
                return codepoint;
            }
            return it.applyErrorHandlerReverse(errorHandler, it.rawIndex + 1);
        }

        @Specialization(guards={"isUTF32(it.encoding)", "isBroken(it.codeRangeA)", "!isDefaultVariant(errorHandler)"})
        static int brokenUTF32(Node node, TruffleStringIterator it, DecodingErrorHandler errorHandler, @Cached.Shared(value="readRaw") @Cached TStringOpsNodes.RawReadValueNode readNode) {
            int codepoint = TruffleStringIterator.readAndDec(node, it, readNode);
            if (Encodings.isValidUnicodeCodepoint(codepoint)) {
                return codepoint;
            }
            return it.applyErrorHandlerReverse(errorHandler, it.rawIndex + 1);
        }

        @Specialization(guards={"isUTF8(it.encoding)", "isValid(it.codeRangeA)"})
        static int utf8Valid(TruffleStringIterator it, DecodingErrorHandler errorHandler) {
            int b2 = it.readAndDecS0();
            if (b2 < 128) {
                return b2;
            }
            assert (Encodings.isUTF8ContinuationByte(b2));
            int codepoint = b2 & 0x3F;
            for (int j2 = 1; j2 < 4; ++j2) {
                b2 = it.readAndDecS0();
                if (j2 >= 3 || !Encodings.isUTF8ContinuationByte(b2)) break;
                codepoint |= (b2 & 0x3F) << 6 * j2;
            }
            int nBytes = Integer.numberOfLeadingZeros(~(b2 << 24));
            assert (1 < nBytes && nBytes < 5) : nBytes;
            return codepoint | (b2 & 255 >>> nBytes) << 6 * (nBytes - 1);
        }

        @Specialization(guards={"isUTF8(it.encoding)", "isBroken(it.codeRangeA)"})
        static int utf8Broken(TruffleStringIterator it, DecodingErrorHandler errorHandler) {
            int startIndex = it.rawIndex;
            int b2 = it.readAndDecS0();
            if (b2 < 128) {
                return b2;
            }
            int codepoint = b2 & 0x3F;
            byte[] stateMachine = Encodings.getUTF8DecodingStateMachineReverse(errorHandler);
            byte type = stateMachine[b2];
            byte state = stateMachine[256 + type];
            int shift = 6;
            assert (state != 0);
            if (state > 24) {
                while (it.rawIndex > 0 && (state = stateMachine[256 + state + (type = stateMachine[b2 = it.readAndDecS0()])]) > 24) {
                    codepoint |= (b2 & 0x3F) << shift;
                    shift += 6;
                }
            }
            if (state == 0) {
                return (255 >> type & b2) << shift | codepoint;
            }
            if (TStringGuards.isDefaultVariant(errorHandler)) {
                if (errorHandler == DecodingErrorHandler.DEFAULT || state != 24) {
                    it.rawIndex = startIndex - 1;
                }
                return Encodings.invalidCodepoint();
            }
            if (errorHandler == DecodingErrorHandler.RETURN_NEGATIVE) {
                it.rawIndex = startIndex - 1;
            }
            return it.applyErrorHandler(errorHandler, startIndex);
        }

        @Specialization(guards={"isUTF16(it.encoding)", "isValid(it.codeRangeA)"})
        static int utf16Valid(TruffleStringIterator it, DecodingErrorHandler errorHandler) {
            char c2 = (char)it.readAndDecS1();
            if (Encodings.isUTF16LowSurrogate(c2)) {
                assert (Encodings.isUTF16HighSurrogate((char)it.readBckS1()));
                return Character.toCodePoint((char)it.readAndDecS1(), c2);
            }
            return c2;
        }

        @Specialization(guards={"isUTF16(it.encoding)", "isBroken(it.codeRangeA)"})
        static int utf16Broken(TruffleStringIterator it, DecodingErrorHandler errorHandler) {
            char c2;
            char c3 = (char)it.readAndDecS1();
            if (TStringGuards.isReturnNegative(errorHandler) || !TStringGuards.isBuiltin(errorHandler)) {
                if (Encodings.isUTF16Surrogate(c3)) {
                    char c22;
                    if (Encodings.isUTF16LowSurrogate(c3) && it.hasPrevious() && Encodings.isUTF16HighSurrogate(c22 = (char)it.readBckS1())) {
                        --it.rawIndex;
                        return Character.toCodePoint(c22, c3);
                    }
                    return it.applyErrorHandlerReverse(errorHandler, it.rawIndex + 1);
                }
            } else if (Encodings.isUTF16LowSurrogate(c3) && it.hasPrevious() && Encodings.isUTF16HighSurrogate(c2 = (char)it.readBckS1())) {
                --it.rawIndex;
                return Character.toCodePoint(c2, c3);
            }
            return c3;
        }

        @Specialization(guards={"isUnsupportedEncoding(it.encoding)"})
        static int unsupported(TruffleStringIterator it, DecodingErrorHandler errorHandler) {
            assert (it.hasPrevious());
            JCodings jcodings = JCodings.getInstance();
            byte[] bytes = JCodings.asByteArray(it.arrayA);
            int start = it.a.byteArrayOffset();
            int index = it.a.byteArrayOffset() + it.rawIndex;
            int end = it.a.byteArrayOffset() + it.a.length();
            int prevIndex = jcodings.getPreviousCodePointIndex(it.encoding, bytes, start, index, end);
            int codepoint = 0;
            if (prevIndex < 0) {
                --it.rawIndex;
            } else {
                assert (prevIndex >= it.a.byteArrayOffset());
                assert (prevIndex < index);
                it.rawIndex = prevIndex - it.a.byteArrayOffset();
                codepoint = jcodings.readCodePoint(it.encoding, bytes, prevIndex, end, errorHandler);
            }
            if (prevIndex < 0 || !jcodings.isValidCodePoint(it.encoding, codepoint)) {
                return it.applyErrorHandlerReverse(errorHandler, index);
            }
            return codepoint;
        }
    }
}

