/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNodeGen;
import com.oracle.truffle.js.nodes.promise.PromiseReactionJobNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JobCallback;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.PromiseReactionRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class PerformPromiseThenNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private IsCallableNode isCallableFulfillNode = IsCallableNode.create();
    @Node.Child
    private IsCallableNode isCallableRejectNode = IsCallableNode.create();
    @Node.Child
    private PromiseReactionJobNode promiseReactionJobNode;

    protected PerformPromiseThenNode(JSContext context) {
        this.context = context;
    }

    @NeverDefault
    public static PerformPromiseThenNode create(JSContext context) {
        return PerformPromiseThenNodeGen.create(context);
    }

    public final JSDynamicObject execute(JSPromiseObject promise, Object onFulfilled, Object onRejected) {
        return this.execute(promise, onFulfilled, onRejected, null);
    }

    public abstract JSDynamicObject execute(JSPromiseObject var1, Object var2, Object var3, PromiseCapabilityRecord var4);

    @Specialization
    protected JSDynamicObject promiseThen(JSPromiseObject promise, Object onFulfilled, Object onRejected, PromiseCapabilityRecord resultCapability, @Cached InlinedConditionProfile pendingProf, @Cached InlinedConditionProfile fulfilledProf, @Cached InlinedConditionProfile unhandledProf, @Cached InlinedBranchProfile growProfile) {
        JobCallback onRejectedHandler;
        JSRealm realm = this.getRealm();
        JSAgent agent = realm.getAgent();
        JobCallback onFulfilledHandler = this.isCallableFulfillNode.executeBoolean(onFulfilled) ? agent.hostMakeJobCallback(onFulfilled) : null;
        JobCallback jobCallback = onRejectedHandler = this.isCallableRejectNode.executeBoolean(onRejected) ? agent.hostMakeJobCallback(onRejected) : null;
        assert (resultCapability != null || onFulfilledHandler != null && onRejectedHandler != null);
        PromiseReactionRecord fulfillReaction = PromiseReactionRecord.create(resultCapability, onFulfilledHandler, true);
        PromiseReactionRecord rejectReaction = PromiseReactionRecord.create(resultCapability, onRejectedHandler, false);
        int promiseState = JSPromise.getPromiseState(promise);
        if (pendingProf.profile(this, promiseState == 0)) {
            promise.getPromiseFulfillReactions().add(fulfillReaction, this, growProfile);
            promise.getPromiseRejectReactions().add(rejectReaction, this, growProfile);
        } else if (fulfilledProf.profile(this, promiseState == 1)) {
            Object value = promise.getPromiseResult();
            assert (value != null);
            JSFunctionObject job = this.getPromiseReactionJob(fulfillReaction, value);
            this.context.enqueuePromiseJob(realm, job);
        } else {
            assert (promiseState == 2);
            Object reason = promise.getPromiseResult();
            assert (reason != null);
            if (unhandledProf.profile(this, !promise.isHandled())) {
                this.context.notifyPromiseRejectionTracker(promise, 1, Undefined.instance, agent);
            }
            JSFunctionObject job = this.getPromiseReactionJob(rejectReaction, reason);
            this.context.enqueuePromiseJob(realm, job);
        }
        promise.setIsHandled(true);
        if (resultCapability == null) {
            return Undefined.instance;
        }
        return resultCapability.getPromise();
    }

    private JSFunctionObject getPromiseReactionJob(PromiseReactionRecord reaction, Object value) {
        if (this.promiseReactionJobNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.promiseReactionJobNode = this.insert(PromiseReactionJobNode.create(this.context));
        }
        return this.promiseReactionJobNode.execute(reaction, value);
    }
}

