/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.doubleconv;

class DiyFp {
    private long f_;
    private int e_;
    static final int kSignificandSize = 64;
    static final long kUint64MSB = Long.MIN_VALUE;

    DiyFp() {
        this.f_ = 0L;
        this.e_ = 0;
    }

    DiyFp(long f2, int e2) {
        this.f_ = f2;
        this.e_ = e2;
    }

    void subtract(DiyFp other) {
        assert (this.e_ == other.e_);
        assert (Long.compareUnsigned(this.f_, other.f_) >= 0);
        this.f_ -= other.f_;
    }

    static DiyFp minus(DiyFp a2, DiyFp b2) {
        DiyFp result = new DiyFp(a2.f_, a2.e_);
        result.subtract(b2);
        return result;
    }

    final void multiply(DiyFp other) {
        long kM32 = 0xFFFFFFFFL;
        long a2 = this.f_ >>> 32;
        long b2 = this.f_ & 0xFFFFFFFFL;
        long c2 = other.f_ >>> 32;
        long d2 = other.f_ & 0xFFFFFFFFL;
        long ac = a2 * c2;
        long bc = b2 * c2;
        long ad = a2 * d2;
        long bd = b2 * d2;
        long tmp = (bd >>> 32) + (ad & 0xFFFFFFFFL) + (bc & 0xFFFFFFFFL) + 0x80000000L;
        this.e_ += other.e_ + 64;
        this.f_ = ac + (ad >>> 32) + (bc >>> 32) + (tmp >>> 32);
    }

    static DiyFp times(DiyFp a2, DiyFp b2) {
        DiyFp result = new DiyFp(a2.f_, a2.e_);
        result.multiply(b2);
        return result;
    }

    void normalize() {
        assert (this.f_ != 0L);
        long significand = this.f_;
        int exponent = this.e_;
        long k10MSBits = -18014398509481984L;
        while ((significand & 0xFFC0000000000000L) == 0L) {
            significand <<= 10;
            exponent -= 10;
        }
        while ((significand & Long.MIN_VALUE) == 0L) {
            significand <<= 1;
            --exponent;
        }
        this.f_ = significand;
        this.e_ = exponent;
    }

    static DiyFp normalize(DiyFp a2) {
        DiyFp result = new DiyFp(a2.f_, a2.e_);
        result.normalize();
        return result;
    }

    long f() {
        return this.f_;
    }

    int e() {
        return this.e_;
    }

    void setF(long new_value) {
        this.f_ = new_value;
    }

    void setE(int new_value) {
        this.e_ = new_value;
    }

    public String toString() {
        return "DiyFp[f=" + this.f_ + ", e=" + this.e_ + "]";
    }
}

