/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotValueDispatch;
import java.lang.reflect.Proxy;

interface PolyglotWrapper {
    public Object getGuestObject();

    public PolyglotContextImpl getContext();

    public PolyglotLanguageContext getLanguageContext();

    public static boolean isInstance(Object v2) {
        if (v2 == null) {
            return false;
        }
        if (v2 instanceof Proxy) {
            return PolyglotWrapper.isHostProxy(v2);
        }
        return v2 instanceof PolyglotWrapper;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isHostProxy(Object v2) {
        if (Proxy.isProxyClass(v2.getClass())) {
            return Proxy.getInvocationHandler(v2) instanceof PolyglotWrapper;
        }
        return false;
    }

    public static PolyglotWrapper asInstance(Object v2) {
        if (v2 instanceof Proxy) {
            return PolyglotWrapper.getHostProxy(v2);
        }
        return (PolyglotWrapper)v2;
    }

    @CompilerDirectives.TruffleBoundary
    public static PolyglotWrapper getHostProxy(Object v2) {
        return (PolyglotWrapper)((Object)Proxy.getInvocationHandler(v2));
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equalsProxy(PolyglotWrapper wrapper, Object other) {
        if (other == null) {
            return false;
        }
        if (Proxy.isProxyClass(other.getClass())) {
            return PolyglotWrapper.equals(wrapper.getLanguageContext(), wrapper.getGuestObject(), PolyglotWrapper.getHostProxy(other).getGuestObject());
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equals(Object context, Object receiver, Object obj) {
        PolyglotContextImpl.State localContextState;
        if (obj == null) {
            return false;
        }
        if (receiver == obj) {
            return true;
        }
        PolyglotLanguageContext languageContext = (PolyglotLanguageContext)context;
        if (languageContext != null && (localContextState = languageContext.context.state).isInvalidOrClosed()) {
            return false;
        }
        Object prev = null;
        try {
            prev = PolyglotValueDispatch.hostEnter(languageContext);
        }
        catch (Throwable t2) {
            return false;
        }
        try {
            InteropLibrary receiverLib = InteropLibrary.getUncached(receiver);
            InteropLibrary objLib = InteropLibrary.getUncached(obj);
            boolean bl = receiverLib.isIdentical(receiver, obj, objLib);
            return bl;
        }
        catch (Throwable t3) {
            throw PolyglotImpl.guestToHostException(languageContext, t3, true);
        }
        finally {
            try {
                PolyglotValueDispatch.hostLeave(languageContext, prev);
            }
            catch (Throwable throwable) {}
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static int hashCode(Object context, Object receiver) {
        int n2;
        PolyglotContextImpl.State localContextState;
        PolyglotLanguageContext languageContext = (PolyglotLanguageContext)context;
        if (languageContext != null && (localContextState = languageContext.context.state).isInvalidOrClosed()) {
            return System.identityHashCode(receiver);
        }
        Object prev = null;
        try {
            prev = PolyglotValueDispatch.hostEnter(languageContext);
        }
        catch (Throwable t2) {
            return System.identityHashCode(receiver);
        }
        try {
            InteropLibrary receiverLib = InteropLibrary.getUncached(receiver);
            if (receiverLib.hasIdentity(receiver)) {
                int n3 = receiverLib.identityHashCode(receiver);
                return n3;
            }
            n2 = System.identityHashCode(receiver);
        }
        catch (Throwable t3) {
            throw PolyglotImpl.guestToHostException(languageContext, t3, true);
        }
        finally {
            try {
                PolyglotValueDispatch.hostLeave(languageContext, prev);
            }
            catch (Throwable throwable) {}
        }
        return n2;
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(Object languageContext, Object receiver) {
        PolyglotContextImpl.State localContextState;
        PolyglotLanguageContext context = (PolyglotLanguageContext)languageContext;
        Object prev = null;
        if (context != null && (localContextState = context.context.state).isInvalidOrClosed()) {
            return "Error in toString(): Context is invalid or closed.";
        }
        try {
            prev = PolyglotValueDispatch.hostEnter(context);
        }
        catch (Throwable t2) {
            return String.format("Error in toString(): Could not enter context: %s.", t2.getMessage());
        }
        try {
            String t2 = PolyglotWrapper.toStringImpl(context, receiver);
            return t2;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context, e2, true);
        }
        finally {
            try {
                PolyglotValueDispatch.hostLeave(languageContext, prev);
            }
            catch (Throwable throwable) {}
        }
    }

    public static String toString(PolyglotWrapper thisObj) {
        return PolyglotWrapper.toString(thisObj.getLanguageContext(), thisObj.getGuestObject());
    }

    public static String toStringImpl(Object languageContext, Object receiver) throws AssertionError {
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(receiver);
        Object result = lib.toDisplayString(receiver);
        InteropLibrary resultLib = InteropLibrary.getFactory().getUncached(result);
        try {
            return resultLib.asString(result);
        }
        catch (UnsupportedMessageException e2) {
            throw CompilerDirectives.shouldNotReachHere("toDisplayString must be coercible to java.lang.String, but is not.", e2);
        }
    }
}

