/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.tregex.parser.ast.InnerLiteral;
import com.oracle.truffle.regex.tregex.string.Encodings;

public final class InputOps {
    public static int length(TruffleString input, Encodings.Encoding encoding) {
        TruffleString.Encoding tsEncoding = encoding.getTStringEncoding();
        int stride = encoding.getStride();
        CompilerAsserts.partialEvaluationConstant((Object)tsEncoding);
        CompilerAsserts.partialEvaluationConstant(stride);
        return input.byteLength(tsEncoding) >> stride;
    }

    public static int indexOf(TruffleString input, int fromIndex, int maxIndex, TruffleString.CodePointSet codePointSet, Encodings.Encoding encoding, TruffleString.ByteIndexOfCodePointSetNode indexOfNode) {
        int stride = encoding.getStride();
        CompilerAsserts.partialEvaluationConstant(codePointSet);
        CompilerAsserts.partialEvaluationConstant(encoding);
        CompilerAsserts.partialEvaluationConstant(stride);
        return indexOfNode.execute(input, fromIndex << stride, maxIndex << stride, codePointSet, false) >> stride;
    }

    public static int indexOf(TruffleString input, int fromIndex, int maxIndex, InnerLiteral literal, Encodings.Encoding encoding, TruffleString.ByteIndexOfStringNode indexOfStringNode) {
        TruffleString.Encoding tsEncoding = encoding.getTStringEncoding();
        boolean hasMask = literal.hasMask();
        int stride = encoding.getStride();
        CompilerAsserts.partialEvaluationConstant(literal);
        CompilerAsserts.partialEvaluationConstant(hasMask);
        CompilerAsserts.partialEvaluationConstant((Object)tsEncoding);
        CompilerAsserts.partialEvaluationConstant(stride);
        int fromByteIndex = fromIndex << stride;
        int maxByteIndex = maxIndex << stride;
        if (fromByteIndex >= maxByteIndex) {
            return -1;
        }
        if (hasMask) {
            TruffleString.WithMask mask = literal.getMaskContent();
            CompilerAsserts.partialEvaluationConstant(mask);
            return indexOfStringNode.execute((AbstractTruffleString)input, mask, fromByteIndex, maxByteIndex, tsEncoding) >> stride;
        }
        TruffleString string = literal.getLiteralContent();
        CompilerAsserts.partialEvaluationConstant(string);
        return indexOfStringNode.execute((AbstractTruffleString)input, string, fromByteIndex, maxByteIndex, tsEncoding) >> stride;
    }

    public static boolean regionEquals(TruffleString input, InnerLiteral literal, int literalLength, Encodings.Encoding encoding, int fromIndex, int toIndex, TruffleString.RegionEqualByteIndexNode regionEqualsNode) {
        int fromByteIndex = fromIndex << encoding.getStride();
        int byteLength = literalLength << encoding.getStride();
        return toIndex - fromIndex >= literalLength && InputOps.regionEqualsInner(input, literal, encoding, fromByteIndex, byteLength, regionEqualsNode);
    }

    private static boolean regionEqualsInner(TruffleString input, InnerLiteral literal, Encodings.Encoding encoding, int fromByteIndexInput, int byteLength, TruffleString.RegionEqualByteIndexNode regionEqualsNode) {
        TruffleString.Encoding tsEncoding = encoding.getTStringEncoding();
        boolean hasMask = literal.hasMask();
        CompilerAsserts.partialEvaluationConstant(literal);
        CompilerAsserts.partialEvaluationConstant(hasMask);
        CompilerAsserts.partialEvaluationConstant((Object)tsEncoding);
        if (hasMask) {
            TruffleString.WithMask mask = literal.getMaskContent();
            CompilerAsserts.partialEvaluationConstant(mask);
            return regionEqualsNode.execute((AbstractTruffleString)input, fromByteIndexInput, mask, 0, byteLength, tsEncoding);
        }
        TruffleString string = literal.getLiteralContent();
        CompilerAsserts.partialEvaluationConstant(string);
        return regionEqualsNode.execute((AbstractTruffleString)input, fromByteIndexInput, string, 0, byteLength, tsEncoding);
    }
}

