/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;

public final class CaseUnfoldingTrie {
    private final List<Integer> codepoints = new ArrayList<Integer>();
    private final EconomicMap<Integer, CaseUnfoldingTrie> childNodes = EconomicMap.create();
    private final int depth;

    public CaseUnfoldingTrie(int depth) {
        this.depth = depth;
    }

    public void add(int codepoint, int[] caseFoldedString, int offset) {
        if (caseFoldedString.length == offset) {
            this.codepoints.add(codepoint);
            return;
        }
        if (!this.hasChildAt(caseFoldedString[offset])) {
            this.childNodes.put(caseFoldedString[offset], new CaseUnfoldingTrie(this.depth + 1));
        }
        this.getChildAt(caseFoldedString[offset]).add(codepoint, caseFoldedString, offset + 1);
    }

    public boolean hasChildAt(int index) {
        return this.childNodes.containsKey(index);
    }

    public CaseUnfoldingTrie getChildAt(int index) {
        return (CaseUnfoldingTrie)this.childNodes.get(index);
    }

    public List<Integer> getCodepoints() {
        return this.codepoints;
    }

    public int getDepth() {
        return this.depth;
    }

    public static List<Unfolding> findUnfoldings(CaseFoldData.CaseFoldAlgorithm algorithm, List<Integer> caseFolded) {
        ArrayList<CaseUnfoldingTrie> nodes = new ArrayList<CaseUnfoldingTrie>();
        ArrayList<CaseUnfoldingTrie> nextNodes = new ArrayList<CaseUnfoldingTrie>();
        ArrayList<Unfolding> unfoldings = new ArrayList<Unfolding>();
        CaseUnfoldingTrie root = CaseFoldData.getUnfoldingTrie(algorithm);
        for (int i2 = 0; i2 < caseFolded.size(); ++i2) {
            int codepoint = caseFolded.get(i2);
            nodes.add(root);
            for (CaseUnfoldingTrie node : nodes) {
                if (!node.hasChildAt(codepoint)) continue;
                CaseUnfoldingTrie child = node.getChildAt(codepoint);
                nextNodes.add(child);
                for (int unfoldedCodepoint : child.getCodepoints()) {
                    unfoldings.add(new Unfolding(i2 + 1 - child.getDepth(), child.getDepth(), unfoldedCodepoint));
                }
            }
            ArrayList<CaseUnfoldingTrie> nodesTmp = nodes;
            nodes = nextNodes;
            nextNodes = nodesTmp;
            nextNodes.clear();
        }
        unfoldings.sort(Comparator.comparingInt(Unfolding::getStart).thenComparing(Comparator.comparingInt(Unfolding::getLength).reversed()));
        return unfoldings;
    }

    public static List<Integer> findSingleCharUnfoldings(CaseFoldData.CaseFoldAlgorithm algorithm, int[] caseFolded) {
        CaseUnfoldingTrie node = CaseFoldData.getUnfoldingTrie(algorithm);
        for (int codepoint : caseFolded) {
            assert (node.hasChildAt(codepoint));
            node = node.getChildAt(codepoint);
        }
        return node.getCodepoints();
    }

    public static List<Integer> findSingleCharUnfoldings(CaseFoldData.CaseFoldAlgorithm algorithm, int caseFolded) {
        if (CaseFoldData.getUnfoldingTrie(algorithm).hasChildAt(caseFolded)) {
            return CaseFoldData.getUnfoldingTrie(algorithm).getChildAt(caseFolded).getCodepoints();
        }
        return Collections.emptyList();
    }

    public static final class Unfolding {
        private final int start;
        private final int length;
        private final int codepoint;

        public Unfolding(int start, int length, int codepoint) {
            this.start = start;
            this.length = length;
            this.codepoint = codepoint;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public int getEnd() {
            return this.start + this.length;
        }

        public int getCodepoint() {
            return this.codepoint;
        }
    }
}

