/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.evaluate;

import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integratedscripting.GeneralConfig;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.evaluate.EvaluationExceptionResolutionHelpers;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Engine;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.EnvironmentAccess;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.HostAccess;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.ResourceLimits;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;

public class ScriptHelpers {
    private static final Engine ENGINE = Engine.newBuilder().option("engine.WarnInterpreterOnly", "false").build();

    public static Context createBaseContext(@Nullable Function<Context.Builder, Context.Builder> contextBuilderModifier) {
        Context.Builder contextBuilder = Context.newBuilder(new String[0]).engine(ENGINE).allowCreateProcess(GeneralConfig.graalAllowCreateProcess).allowCreateThread(GeneralConfig.graalAllowCreateThread).allowIO(GeneralConfig.graalAllowIo).allowHostClassLoading(GeneralConfig.graalAllowHostClassLoading).allowExperimentalOptions(GeneralConfig.graalAllowExperimentalOptions).allowEnvironmentAccess(GeneralConfig.graalAllowEnvironment ? EnvironmentAccess.INHERIT : EnvironmentAccess.NONE).allowNativeAccess(GeneralConfig.graalAllowNative).allowHostAccess(HostAccess.newBuilder().allowPublicAccess(GeneralConfig.graalAllowHostPublicAccess).allowAllImplementations(GeneralConfig.graalAllowHostAllImplementations).allowAllClassImplementations(GeneralConfig.graalAllowHostAllClassImplementations).allowArrayAccess(GeneralConfig.graalAllowHostArrayAccess).allowListAccess(GeneralConfig.graalAllowHostListAccess).allowBufferAccess(GeneralConfig.graalAllowHostBufferAccess).allowIterableAccess(GeneralConfig.graalAllowHostIterableAccess).allowIteratorAccess(GeneralConfig.graalAllowHostIteratorAccess).allowMapAccess(GeneralConfig.graalAllowHostMapAccess).allowAccessInheritance(GeneralConfig.graalAllowHostAccessInheritance).build()).allowInnerContextOptions(false);
        if (GeneralConfig.graalStatementLimit > 0) {
            contextBuilder = contextBuilder.resourceLimits(ResourceLimits.newBuilder().statementLimit(GeneralConfig.graalStatementLimit, null).build());
        }
        if (contextBuilderModifier != null) {
            contextBuilder = contextBuilderModifier.apply(contextBuilder);
        }
        return contextBuilder.build();
    }

    public static Context createPopulatedContext(@Nullable Function<Context.Builder, Context.Builder> contextBuilderModifier, ValueDeseralizationContext valueDeseralizationContext) throws EvaluationException {
        Context context = ScriptHelpers.createBaseContext(contextBuilderModifier);
        Value jsBindings = context.getBindings("js");
        Value jsObjectClass = jsBindings.getMember("Object");
        Value idContext = jsObjectClass.newInstance(new Object[0]);
        Value ops = jsObjectClass.newInstance(new Object[0]);
        for (Map.Entry entry : Operators.REGISTRY.getGlobalInteractOperators().entrySet()) {
            ops.putMember((String)entry.getKey(), ValueTranslators.REGISTRY.translateToGraal(context, ValueTypeOperator.ValueOperator.of((IOperator)((IOperator)entry.getValue())), ScriptHelpers.getDummyEvaluationExceptionFactory(), valueDeseralizationContext));
        }
        idContext.putMember("ops", ops);
        jsBindings.putMember("idContext", idContext);
        return context;
    }

    @Nullable
    public static String getPathExtension(Path path) {
        String filePathString = path.toString();
        int dotPos = filePathString.lastIndexOf(46);
        if (dotPos >= 0 && dotPos + 1 < filePathString.length()) {
            return filePathString.substring(dotPos + 1);
        }
        return null;
    }

    public static IEvaluationExceptionFactory getDummyEvaluationExceptionFactory() {
        return EvaluationException::new;
    }

    public static IEvaluationExceptionFactory getEvaluationExceptionFactory(int disk, Path path, String member) {
        EvaluationExceptionResolutionHelpers.expungeStaleEvaluationExceptions();
        return message -> EvaluationExceptionResolutionHelpers.resolveOnScriptChange(new EvaluationException(Component.translatable((String)"script.integratedscripting.error.script_exec", (Object[])new Object[]{member, path.toString(), disk, message})), disk, path);
    }

    public static <E extends Throwable> void sneakyThrow(Throwable e2) throws E {
        throw e2;
    }
}

