/*
 * Decompiled with CFR 0.152.
 */
package haage.hiddenarmour.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class HiddenArmourConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("hiddenarmour.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean hideArmour = false;
    public boolean includeElytra = false;
    public boolean hideHorseArmor = false;
    public boolean hideWolfArmor = false;
    public boolean hideEnchantmentGlint = false;
    public boolean hideNameTags = false;
    public boolean showHelmet = false;
    public boolean showChestplate = false;
    public boolean showLeggings = false;
    public boolean showBoots = false;
    private static HiddenArmourConfig instance;

    public static HiddenArmourConfig get() {
        if (instance == null) {
            HiddenArmourConfig.load();
        }
        return instance;
    }

    public static void load() {
        block9: {
            try {
                if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                        instance = (HiddenArmourConfig)GSON.fromJson((Reader)reader, HiddenArmourConfig.class);
                        break block9;
                    }
                }
                instance = new HiddenArmourConfig();
                HiddenArmourConfig.save();
            }
            catch (IOException e) {
                e.printStackTrace();
                instance = new HiddenArmourConfig();
            }
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)HiddenArmourConfig.get(), (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isShowHelmet() {
        return this.showHelmet;
    }

    public void setShowHelmet(boolean showHelmet) {
        this.showHelmet = showHelmet;
    }

    public boolean isShowChestplate() {
        return this.showChestplate;
    }

    public void setShowChestplate(boolean showChestplate) {
        this.showChestplate = showChestplate;
    }

    public boolean isShowLeggings() {
        return this.showLeggings;
    }

    public void setShowLeggings(boolean showLeggings) {
        this.showLeggings = showLeggings;
    }

    public boolean isShowBoots() {
        return this.showBoots;
    }

    public void setShowBoots(boolean showBoots) {
        this.showBoots = showBoots;
    }
}

