/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.dungeon;

import jeresources.entry.DungeonEntry;
import jeresources.registry.DungeonRegistry;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class DungeonWrapper
implements IRecipeCategoryExtension<DungeonEntry> {
    private boolean done;
    private int lidStart;

    public void drawInfo(DungeonEntry entry, int recipeWidth, int recipeHeight, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderHelper.renderChest(guiGraphics, 15.0f, 20.0f, -40.0f, 20.0f, this.getLidAngle());
    }

    public void createRecipeExtras(DungeonEntry entry, IRecipeExtrasBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        builder.addText(FormattedText.of((String)TranslationHelper.translateAndFormat(entry.getName(), new Object[0])), 200, 100).setPosition(50, 7);
        builder.addText(FormattedText.of((String)DungeonRegistry.getInstance().getNumStacks(entry)), 200, 100).setPosition(50, 20);
    }

    private float getLidAngle() {
        float angle = ((int)System.currentTimeMillis() / 100 - this.lidStart) % 80;
        if (angle > 50.0f || this.done) {
            this.done = true;
            angle = 50.0f;
        }
        return angle;
    }

    public void resetLid() {
        this.lidStart = (int)System.currentTimeMillis() / 100;
    }
}

