/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.mob;

import jeresources.config.Settings;
import jeresources.entry.MobEntry;
import jeresources.util.CollectionHelper;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import org.jetbrains.annotations.NotNull;

public class MobWrapper
implements IRecipeCategoryExtension<MobEntry> {
    public void drawInfo(MobEntry recipe, int recipeWidth, int recipeHeight, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        LivingEntity livingEntity = recipe.getEntity();
        float scale = this.getScale(livingEntity);
        int offsetY = this.getOffsetY(livingEntity);
        RenderHelper.renderEntity(guiGraphics, 7, 43, 66, 122, scale, 38.0 - mouseX, (double)(70 - offsetY) - mouseY, livingEntity);
    }

    public void createRecipeExtras(MobEntry recipe, IRecipeExtrasBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        String entityString;
        LivingEntity livingEntity = recipe.getEntity();
        Object mobName = recipe.getMobName();
        if (Settings.showDevData && (entityString = livingEntity.getStringUUID()) != null) {
            mobName = (String)mobName + " (" + entityString + ")";
        }
        builder.addText(FormattedText.of((String)mobName), 100, 100).setPosition(7, 2);
        String biomesLine = recipe.hasMultipleBiomes() ? TranslationHelper.translateAndFormat("jer.mob.biome", new Object[0]) : recipe.getTranslatedBiomes().findFirst().map(firstBiome -> TranslationHelper.translateAndFormat("jer.mob.spawn", new Object[0]) + " " + firstBiome).orElse("");
        builder.addText(FormattedText.of((String)biomesLine), 100, 100).setPosition(7, 12);
        builder.addText(FormattedText.of((String)recipe.getLightLevel().toString()), 100, 100).setPosition(7, 22);
        builder.addText(FormattedText.of((String)(TranslationHelper.translateAndFormat("jer.mob.exp", new Object[0]) + ": " + recipe.getExp())), 100, 100).setPosition(7, 32);
    }

    public void getTooltip(ITooltipBuilder tooltip, MobEntry recipe, double mouseX, double mouseY) {
        if (recipe.hasMultipleBiomes() && this.isOnBiome(mouseX, mouseY)) {
            tooltip.addAll(CollectionHelper.create(Component::literal, recipe.getTranslatedBiomes()));
        }
    }

    private boolean isOnBiome(double mouseX, double mouseY) {
        return 2.0 <= mouseX && mouseX < 165.0 && 12.0 <= mouseY && mouseY < 22.0;
    }

    private float getScale(LivingEntity livingEntity) {
        float height;
        float width = livingEntity.getBbWidth();
        if (width <= (height = livingEntity.getBbHeight())) {
            if ((double)height < 0.9) {
                return 50.0f;
            }
            if (height < 1.0f) {
                return 35.0f;
            }
            if ((double)height < 1.8) {
                return 33.0f;
            }
            if (height < 2.0f) {
                return 32.0f;
            }
            if (height < 3.0f) {
                return 24.0f;
            }
            if (height < 4.0f) {
                return 20.0f;
            }
            return 10.0f;
        }
        if (width < 1.0f) {
            return 38.0f;
        }
        if (width < 2.0f) {
            return 27.0f;
        }
        if (width < 3.0f) {
            return 13.0f;
        }
        return 9.0f;
    }

    private int getOffsetY(LivingEntity livingEntity) {
        int offsetY = 0;
        if (livingEntity instanceof Squid) {
            offsetY = 20;
        } else if (livingEntity instanceof Turtle) {
            offsetY = 10;
        } else if (livingEntity instanceof Witch) {
            offsetY = -5;
        } else if (livingEntity instanceof Ghast) {
            offsetY = 15;
        } else if (livingEntity instanceof WitherBoss) {
            offsetY = -15;
        } else if (livingEntity instanceof EnderDragon) {
            offsetY = 15;
        } else if (livingEntity instanceof EnderMan) {
            offsetY = -10;
        } else if (livingEntity instanceof AbstractGolem) {
            offsetY = -10;
        } else if (livingEntity instanceof Animal) {
            offsetY = -20;
        } else if (livingEntity instanceof Villager) {
            offsetY = -15;
        } else if (livingEntity instanceof Husk) {
            offsetY = -15;
        } else if (livingEntity instanceof AbstractIllager) {
            offsetY = -15;
        } else if (livingEntity instanceof WanderingTrader) {
            offsetY = -15;
        } else if (livingEntity instanceof Blaze) {
            offsetY = -10;
        } else if (livingEntity instanceof Creeper) {
            offsetY = -15;
        } else if (livingEntity instanceof AbstractPiglin) {
            offsetY = -15;
        }
        return offsetY;
    }
}

