/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.villager;

import java.util.Iterator;
import jeresources.entry.AbstractVillagerEntry;
import jeresources.reference.Resources;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VillagerWrapper
implements IRecipeCategoryExtension<AbstractVillagerEntry> {
    private IFocus<ItemStack> focus;

    public void setFocus(IFocus<ItemStack> focus) {
        this.focus = focus;
    }

    public void drawInfo(AbstractVillagerEntry recipe, int recipeWidth, int recipeHeight, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Object villager = recipe.getVillagerEntity();
        RenderHelper.renderEntity(guiGraphics, 7, 43, 66, 122, 36.0, 38.0 - mouseX, 80.0 - mouseY, villager);
        int y = 22 * (6 - recipe.getPossibleLevels(this.focus).size()) / 2;
        for (int i = 0; i < recipe.getPossibleLevels(this.focus).size(); ++i) {
            RenderHelper.drawTexture(guiGraphics, Resources.Gui.Jei.VILLAGER.getResource(), 130, y + i * 22, 0, 120, 20, 20);
            RenderHelper.drawTexture(guiGraphics, Resources.Gui.Jei.VILLAGER.getResource(), 95, y + i * 22, 22, 120, 18, 18);
            RenderHelper.drawTexture(guiGraphics, Resources.Gui.Jei.VILLAGER.getResource(), 113, y + i * 22, 22, 120, 18, 18);
            RenderHelper.drawTexture(guiGraphics, Resources.Gui.Jei.VILLAGER.getResource(), 150, y + i * 22, 22, 120, 18, 18);
        }
        if (recipe.hasPois()) {
            RenderHelper.drawTexture(guiGraphics, Resources.Gui.Jei.VILLAGER.getResource(), 49, 18, 22, 120, 18, 18);
        }
    }

    public void createRecipeExtras(AbstractVillagerEntry recipe, IRecipeExtrasBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        int i = 0;
        int y = 22 * (6 - recipe.getPossibleLevels(this.focus).size()) / 2;
        if (recipe.hasLevels()) {
            Iterator<Integer> iterator = recipe.getPossibleLevels(this.focus).iterator();
            while (iterator.hasNext()) {
                Integer oLevel;
                Integer level = oLevel = iterator.next();
                builder.addText(FormattedText.of((String)("lv. " + (level + 1))), 100, 100).setPosition(72, y + i++ * 22 + 6);
            }
        }
        builder.addText((FormattedText)recipe.getDisplayName(), 100, 100).setPosition(5, 5);
        if (recipe.hasPois()) {
            builder.addText(FormattedText.of((String)TranslationHelper.translateAndFormat("jer.villager.poi", new Object[0])), 45, 100).setPosition(5, 18);
        }
    }
}

