/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.worldgen;

import jeresources.entry.WorldGenEntry;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class WorldGenWrapper
implements IRecipeCategoryExtension<WorldGenEntry> {
    protected static final int X_OFFSET = 29;
    protected static final int Y_OFFSET = 52;
    protected static final int X_AXIS_SIZE = 128;
    protected static final int Y_AXIS_SIZE = 40;
    protected static final String ORE_SLOT_NAME = "oreSlot";

    public void drawInfo(WorldGenEntry recipe, int recipeWidth, int recipeHeight, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        float[] array = recipe.getChances();
        double max = 0.0;
        float[] fArray = array;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double d = fArray[i];
            if (!(d > max)) continue;
            max = d;
        }
        double xPrev = 29.0;
        double yPrev = 52.0;
        double space = 128.0 / ((double)(array.length - 1) * 1.0);
        for (int i = 0; i < array.length; ++i) {
            double value = array[i];
            double y = 52.0 - value / max * 40.0;
            if (i > 0) {
                double x = xPrev + space;
                RenderHelper.drawLine(guiGraphics, (int)xPrev, (int)yPrev, (int)x, (int)y, recipe.getColour());
                xPrev = x;
            }
            yPrev = y;
        }
    }

    public void createRecipeExtras(WorldGenEntry recipe, IRecipeExtrasBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        float[] array = recipe.getChances();
        double max = 0.0;
        float[] fArray = array;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double d = fArray[i];
            if (!(d > max)) continue;
            max = d;
        }
        int xPercents = 27;
        int yPercents = 48;
        String minPercent = "0%";
        int minPercentWidth = Font.small.getStringWidth("0%");
        builder.addText(FormattedText.of((String)"0%"), 100, 100).setPosition(27 - minPercentWidth, 48);
        String maxPercent = String.format("%.2f", max * 100.0) + "%";
        int maxPercentWidth = Font.small.getStringWidth(maxPercent);
        builder.addText(FormattedText.of((String)maxPercent), 100, 100).setPosition(27 - maxPercentWidth, 8);
        int yLabels = 54;
        int xLabels = 29;
        int minLabel = recipe.getMinY();
        int minLabelWidth = Font.small.getStringWidth(String.valueOf(minLabel));
        int minLabelOffset = 29 - minLabelWidth / 2;
        builder.addText(FormattedText.of((String)String.valueOf(minLabel)), 100, 100).setPosition(minLabelOffset, 54);
        int maxLabel = recipe.getMaxY();
        int maxLabelWidth = Font.small.getStringWidth(String.valueOf(maxLabel));
        int maxLabelOffset = 157 - maxLabelWidth / 2;
        builder.addText(FormattedText.of((String)String.valueOf(maxLabel)), 100, 100).setPosition(maxLabelOffset, 54);
        int midLabel = (maxLabel + minLabel) / 2;
        int midLabelWidth = Font.small.getStringWidth(String.valueOf(midLabel));
        int midLabelOffset = 93 - midLabelWidth / 2;
        builder.addText(FormattedText.of((String)String.valueOf(midLabel)), 100, 100).setPosition(midLabelOffset, 54);
        builder.addText(FormattedText.of((String)TranslationHelper.translateAndFormat("jer.worldgen.drops", new Object[0])), 100, 100).setPosition(6, 59);
        String dimension = TranslationHelper.tryDimensionTranslate(recipe.getDimension());
        builder.addText(FormattedText.of((String)dimension), 100, 100).setPosition(0, 0);
    }

    public void getTooltip(ITooltipBuilder tooltip, WorldGenEntry recipe, double mouseX, double mouseY) {
        if (this.onGraph(mouseX, mouseY)) {
            this.setLineTooltip(tooltip, recipe, mouseX);
        }
    }

    private void setLineTooltip(ITooltipBuilder tooltip, WorldGenEntry recipe, double mouseX) {
        double exactMouseX = WorldGenWrapper.getExactMouseX(mouseX);
        float[] chances = recipe.getChances();
        double space = 128.0 / ((double)chances.length * 1.0);
        int index = (int)((exactMouseX - 29.0 + 1.0) / space);
        int yValue = index + recipe.getMinY();
        if (index >= 0 && index < chances.length) {
            float chance = chances[index] * 100.0f;
            String percent = chance > 0.01f || chance == 0.0f ? String.format(" (%.2f%%)", Float.valueOf(chance)) : " <0.01%";
            tooltip.add((FormattedText)Component.literal((String)("Y: " + yValue + percent)));
        }
    }

    private static double getExactMouseX(double mouseX) {
        Minecraft mc = Minecraft.getInstance();
        int scaledWidth = mc.getWindow().getGuiScaledWidth();
        double mouseXExact = mc.mouseHandler.xpos() * (double)scaledWidth / (double)mc.getWindow().getWidth();
        double mouseXFraction = mouseXExact - Math.floor(mouseXExact);
        return mouseX + mouseXFraction;
    }

    private boolean onGraph(double mouseX, double mouseY) {
        return mouseX >= 28.0 && mouseX < 157.0 && mouseY >= 11.0 && mouseY < 52.0;
    }
}

