/*
 * Decompiled with CFR 0.152.
 */
package jeresources.registry;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import jeresources.config.Settings;
import jeresources.entry.EnchantmentEntry;
import jeresources.util.RegistryHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentRegistry {
    private Set<EnchantmentEntry> enchantments = new HashSet<EnchantmentEntry>();
    private static EnchantmentRegistry instance;

    public static EnchantmentRegistry getInstance() {
        if (instance == null) {
            instance = new EnchantmentRegistry();
            return instance;
        }
        return instance;
    }

    public EnchantmentRegistry() {
        for (Holder holder : EnchantmentRegistry.getEnchants()) {
            if (holder == null) continue;
            this.enchantments.add(new EnchantmentEntry((Holder<Enchantment>)holder));
        }
        this.removeAll(Settings.excludedEnchants);
    }

    public Set<EnchantmentEntry> getEnchantments(ItemStack itemStack) {
        HashSet<EnchantmentEntry> set = new HashSet<EnchantmentEntry>();
        for (EnchantmentEntry enchantmentEntry : this.enchantments) {
            if (!enchantmentEntry.getEnchantment().isSupportedItem(itemStack)) continue;
            set.add(enchantmentEntry);
        }
        return set;
    }

    private void excludeFormRegistry(Holder<Enchantment> enchantment) {
        this.enchantments.removeIf(enchantmentEntry -> enchantmentEntry.getEnchantment().description().getString().equals(((Enchantment)enchantment.value()).description().getString()));
    }

    private void excludeFormRegistry(String sEnchantment) {
        for (Holder holder : EnchantmentRegistry.getEnchants()) {
            if (holder == null || !((Enchantment)holder.value()).description().getString().toLowerCase().contains(sEnchantment.toLowerCase())) continue;
            this.excludeFormRegistry((Holder<Enchantment>)holder);
        }
    }

    public void removeAll(String[] excludedEnchants) {
        for (String enchant : excludedEnchants) {
            this.excludeFormRegistry(enchant);
        }
    }

    private static Set<Holder.Reference<Enchantment>> getEnchants() {
        return RegistryHelper.getRegistry(Registries.ENCHANTMENT).listElements().collect(Collectors.toSet());
    }
}

