/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import jeresources.api.render.IMobRenderHook;
import jeresources.compatibility.api.MobRegistryImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix3x2f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RenderHelper {
    public static void drawLine(GuiGraphics guiGraphics, int xBegin, int yBegin, int xEnd, int yEnd, int color) {
        guiGraphics.fill(xBegin, yBegin, xEnd += xBegin == xEnd ? 1 : 0, yEnd += yBegin == yEnd ? 1 : 0, color);
    }

    public static void renderEntity(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, double scale, double yaw, double pitch, LivingEntity livingEntity) {
        PoseStack mobPoseStack = new PoseStack();
        ScreenRectangle screenRectangle = new ScreenRectangle(x1, y1, x2 - x1, y2 - y1).transformAxisAligned((Matrix3x2f)guiGraphics.pose());
        IMobRenderHook.RenderInfo renderInfo = MobRegistryImpl.applyRenderHooks(mobPoseStack, livingEntity, new IMobRenderHook.RenderInfo(0, 0, scale, yaw, pitch));
        int x = renderInfo.x;
        int y = renderInfo.y;
        mobPoseStack.translate((float)x, (float)y, 0.0f);
        scale = renderInfo.scale;
        yaw = renderInfo.yaw;
        pitch = renderInfo.pitch;
        mobPoseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees((float)Math.atan(pitch / 40.0) * 20.0f));
        livingEntity.yo = (float)Math.atan(yaw / 40.0) * 20.0f;
        float yRot = (float)Math.atan(yaw / 40.0) * 40.0f;
        float xRot = -((float)Math.atan(pitch / 40.0)) * 20.0f;
        livingEntity.setYRot(yRot);
        livingEntity.setYRot(yRot);
        livingEntity.setXRot(xRot);
        livingEntity.yHeadRot = yRot;
        livingEntity.yHeadRotO = yRot;
        mobPoseStack.translate(0.0f, livingEntity.getBbHeight() / 2.0f, 0.0f);
        Vector3f translationVec = new Vector3f();
        mobPoseStack.last().pose().getTranslation(translationVec);
        Quaternionf rotationQuat = new Quaternionf();
        mobPoseStack.last().pose().getUnnormalizedRotation(rotationQuat);
        Quaternionf cameraQuat = new Quaternionf().rotateZ((float)Math.PI);
        cameraQuat.mul((Quaternionfc)new Quaternionf().rotateY((float)Math.PI));
        rotationQuat.mul((Quaternionfc)cameraQuat);
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (int)screenRectangle.left(), (int)screenRectangle.top(), (int)screenRectangle.right(), (int)screenRectangle.bottom(), (float)((float)scale), (Vector3f)translationVec, (Quaternionf)rotationQuat, (Quaternionf)cameraQuat, (LivingEntity)livingEntity);
    }

    public static void renderChest(GuiGraphics guiGraphics, float x, float y, float rotate, float scale, float lidAngle) {
        PoseStack poseStack = new PoseStack();
        poseStack.translate(x, y, 50.0f);
        poseStack.mulPose((Quaternionfc)new Quaternionf(-160.0f, 1.0f, 0.0f, 0.0f));
        poseStack.scale(scale, -scale, -scale);
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)new Quaternionf(rotate, 0.0f, 1.0f, 0.0f));
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        float lidAngleF = lidAngle / 180.0f;
        lidAngleF = 1.0f - lidAngleF;
        lidAngleF = 1.0f - lidAngleF * lidAngleF * lidAngleF;
    }

    public static void renderBlock(GuiGraphics guiGraphics, BlockState block, float x, float y, float z, float rotate, float scale) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = new PoseStack();
        poseStack.translate(x, y, z);
        poseStack.scale(-scale, -scale, -scale);
        poseStack.translate(-0.5f, -0.5f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-30.0f));
        poseStack.translate(0.5f, 0.0f, -0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotate));
        poseStack.translate(-0.5f, 0.0f, 0.5f);
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, -1.0f);
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        mc.getBlockRenderer().renderSingleBlock(block, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
        bufferSource.endBatch();
    }

    public static void drawTexture(GuiGraphics guiGraphics, ResourceLocation resource, int x, int y, int u, int v, int width, int height) {
        RenderHelper.drawTexturedModalRect(guiGraphics, resource, x, y, u, v, width, height);
    }

    public static void drawTexturedModalRect(GuiGraphics guiGraphics, ResourceLocation resource, int x, int y, int u, int v, int width, int height) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, resource, x, y, (float)u, (float)v, width, height, 256, 256);
    }
}

