/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit;

import de.sean.blockprot.bukkit.BlockProtAPI;
import de.sean.blockprot.bukkit.CachedProfileService;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.commands.BlockProtCommand;
import de.sean.blockprot.bukkit.config.DefaultConfig;
import de.sean.blockprot.bukkit.integrations.LandsPluginIntegration;
import de.sean.blockprot.bukkit.integrations.PlaceholderAPIIntegration;
import de.sean.blockprot.bukkit.integrations.PluginIntegration;
import de.sean.blockprot.bukkit.integrations.TownyIntegration;
import de.sean.blockprot.bukkit.integrations.WorldGuardIntegration;
import de.sean.blockprot.bukkit.listeners.BlockEventListener;
import de.sean.blockprot.bukkit.listeners.EntityEventListener;
import de.sean.blockprot.bukkit.listeners.ErrorEventListener;
import de.sean.blockprot.bukkit.listeners.ExplodeEventListener;
import de.sean.blockprot.bukkit.listeners.HopperEventListener;
import de.sean.blockprot.bukkit.listeners.InteractEventListener;
import de.sean.blockprot.bukkit.listeners.InventoryEventListener;
import de.sean.blockprot.bukkit.listeners.JoinEventListener;
import de.sean.blockprot.bukkit.listeners.PistonEventListener;
import de.sean.blockprot.bukkit.listeners.RedstoneEventListener;
import de.sean.blockprot.bukkit.metrics.IntegrationBarChart;
import de.sean.blockprot.bukkit.metrics.bukkit.Metrics;
import de.sean.blockprot.bukkit.nbt.StatHandler;
import de.sean.blockprot.bukkit.shaded.anvilgui.version.VersionMatcher;
import de.sean.blockprot.bukkit.shaded.nbtapi.utils.MinecraftVersion;
import de.sean.blockprot.bukkit.squirrelid.cache.ProfileCache;
import de.sean.blockprot.bukkit.squirrelid.cache.SQLiteCache;
import de.sean.blockprot.bukkit.squirrelid.resolver.ProfileService;
import de.sean.blockprot.bukkit.tasks.UpdateChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockProt
extends JavaPlugin {
    public static final int pluginId = 9999;
    public static final String defaultLanguageFile = "translations_en.yml";
    @Nullable
    private static BlockProt instance;
    @Nullable
    private static DefaultConfig defaultConfig;
    private final ArrayList<PluginIntegration> integrations = new ArrayList();
    @Nullable
    private static SQLiteCache playerProfileCache;
    @Nullable
    private static ProfileService playerProfileService;
    private Metrics metrics;

    @NotNull
    public static BlockProt getInstance() {
        assert (instance != null);
        return instance;
    }

    @NotNull
    public static DefaultConfig getDefaultConfig() throws AssertionError {
        assert (defaultConfig != null) : "default config should be null.";
        return defaultConfig;
    }

    public List<PluginIntegration> getIntegrations() {
        return Collections.unmodifiableList(this.integrations);
    }

    @NotNull
    public static ProfileCache getProfileCache() {
        assert (playerProfileCache != null);
        return playerProfileCache;
    }

    @NotNull
    public static ProfileService getProfileService() {
        assert (playerProfileService != null);
        return playerProfileService;
    }

    public void onLoad() {
        instance = this;
        try {
            playerProfileCache = new SQLiteCache(new File(Bukkit.getWorldContainer(), "blockprot_usercache.sqlite"));
            playerProfileService = new CachedProfileService(playerProfileCache);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open SQLite connection to usercache database", e);
        }
        try {
            this.registerIntegration(new WorldGuardIntegration());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            this.registerIntegration(new TownyIntegration());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            this.registerIntegration(new PlaceholderAPIIntegration());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            this.registerIntegration(new LandsPluginIntegration());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        for (PluginIntegration integration : this.integrations) {
            try {
                integration.load();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
    }

    public void onEnable() {
        if (this.isRunningCraftBukkit()) {
            String message = "This plugin does not support running on CraftBukkit servers! Please use any Spigot server instead!";
            this.getLogger().severe("This plugin does not support running on CraftBukkit servers! Please use any Spigot server instead!");
            this.getServer().getPluginManager().registerEvents((Listener)new ErrorEventListener("This plugin does not support running on CraftBukkit servers! Please use any Spigot server instead!"), (Plugin)this);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, (Runnable)new UpdateChecker(this.getDescription()));
        try {
            new VersionMatcher().match();
        }
        catch (IllegalStateException e) {
            String message = "This plugin does not support the current Minecraft version! Please check if there is a new update available.";
            this.getLogger().severe("This plugin does not support the current Minecraft version! Please check if there is a new update available.");
            this.getServer().getPluginManager().registerEvents((Listener)new ErrorEventListener("This plugin does not support the current Minecraft version! Please check if there is a new update available."), (Plugin)this);
            return;
        }
        MinecraftVersion.disableUpdateCheck();
        new BlockProtAPI(this);
        StatHandler.enable();
        this.saveDefaultConfig();
        this.reloadConfigAndTranslations();
        this.metrics = new Metrics(this, 9999);
        this.metrics.addCustomChart(new IntegrationBarChart());
        PluginManager pm = this.getServer().getPluginManager();
        this.registerEvent(pm, new BlockEventListener(this));
        this.registerEvent(pm, new EntityEventListener());
        this.registerEvent(pm, new ExplodeEventListener());
        this.registerEvent(pm, new HopperEventListener());
        this.registerEvent(pm, new InteractEventListener());
        this.registerEvent(pm, new InventoryEventListener());
        this.registerEvent(pm, new JoinEventListener());
        this.registerEvent(pm, new PistonEventListener());
        this.registerEvent(pm, new RedstoneEventListener());
        Objects.requireNonNull(this.getCommand("blockprot")).setExecutor((CommandExecutor)new BlockProtCommand());
        for (PluginIntegration integration : this.integrations) {
            try {
                integration.enable();
                if (!integration.isEnabled()) continue;
                this.getLogger().info(String.format("Enabled plugin integration for plugin with id '%s'", integration.name));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        super.onEnable();
    }

    public void onDisable() {
        if (!this.isRunningCraftBukkit()) {
            this.getLogger().info("Saving statistic file...");
            StatHandler.disable();
            this.getServer().getOnlinePlayers().forEach(HumanEntity::closeInventory);
        }
        super.onDisable();
    }

    public void reloadConfigAndTranslations() {
        this.reloadConfig();
        defaultConfig = new DefaultConfig(this.getConfig());
        Translator.resetTranslations();
        Translator.DEFAULT_FALLBACK = defaultConfig.getTranslationFallbackString();
        String langFolder = "lang/";
        for (String resource : Translator.DEFAULT_TRANSLATION_FILES) {
            if (new File(this.getDataFolder(), "lang/" + resource).exists()) continue;
            this.saveResource("lang/" + resource, defaultConfig.shouldReplaceTranslations());
        }
        InputStream defaultLanguageStream = this.getResource("lang/translations_en.yml");
        if (defaultLanguageStream == null) {
            throw new RuntimeException("Failed to get default language file. Possibly corrupt plugin?");
        }
        YamlConfiguration defaultLanguageConfig = YamlConfiguration.loadConfiguration((Reader)new BufferedReader(new InputStreamReader(defaultLanguageStream)));
        String fileName = defaultConfig.getLanguageFile() == null ? defaultLanguageFile : defaultConfig.getLanguageFile();
        YamlConfiguration wantedConfig = this.saveAndLoadConfigFile("lang/", fileName, defaultConfig.shouldReplaceTranslations());
        Translator.loadFromConfigs(defaultLanguageConfig, wantedConfig);
        for (PluginIntegration integration : this.integrations) {
            integration.reload();
        }
    }

    private void registerEvent(@NotNull PluginManager pm, Listener listener) {
        pm.registerEvents(listener, (Plugin)this);
    }

    void registerIntegration(@NotNull PluginIntegration integration) {
        this.integrations.add(integration);
        this.getLogger().info(String.format("Registered plugin integration for plugin with id '%s'", integration.name));
    }

    @Nullable
    public Plugin getPlugin(String pluginName) {
        return this.getServer().getPluginManager().getPlugin(pluginName);
    }

    @NotNull
    public YamlConfiguration saveAndLoadConfigFile(String folder, String name, boolean replace) {
        String path = folder + (folder.endsWith("/") ? "" : "/") + name;
        File file = new File(this.getDataFolder(), path);
        if (!file.exists()) {
            try {
                this.saveResource(path, replace);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("The configured language file does not exist: " + name);
                return new YamlConfiguration();
            }
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    private boolean isRunningCraftBukkit() {
        try {
            Class<?> clazz = Class.forName("net.md_5.bungee.api.chat.BaseComponent");
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    static {
        defaultConfig = null;
        playerProfileCache = null;
        playerProfileService = null;
    }
}

