/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.Permissions;
import de.sean.blockprot.bukkit.events.BlockAccessMenuEvent;
import de.sean.blockprot.bukkit.integrations.PluginIntegration;
import de.sean.blockprot.bukkit.inventories.BlockLockInventory;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import de.sean.blockprot.bukkit.nbt.BlockNBTHandler;
import de.sean.blockprot.bukkit.nbt.FriendHandler;
import de.sean.blockprot.bukkit.nbt.PlayerSettingsHandler;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockProtAPI {
    @Nullable
    static BlockProtAPI instance;
    private final BlockProt blockProt;

    BlockProtAPI(BlockProt blockProt) {
        this.blockProt = blockProt;
        instance = this;
    }

    @Nullable
    public static BlockProtAPI getInstance() {
        return instance;
    }

    public void registerIntegration(@NotNull PluginIntegration integration) {
        this.blockProt.registerIntegration(integration);
    }

    @NotNull
    public List<PluginIntegration> getIntegrations() {
        return this.blockProt.getIntegrations();
    }

    @NotNull
    public BlockNBTHandler getBlockHandler(@NotNull Block block) {
        return new BlockNBTHandler(block);
    }

    @NotNull
    public PlayerSettingsHandler getPlayerSettings(@NotNull Player player) {
        return new PlayerSettingsHandler(player);
    }

    @Nullable
    public Inventory getLockInventoryForBlock(@NotNull Block block, @NotNull Player player) {
        BlockAccessMenuEvent event = new BlockAccessMenuEvent(block, player);
        String playerUuid = player.getUniqueId().toString();
        BlockNBTHandler handler = new BlockNBTHandler(block);
        if (player.isOp() || player.hasPermission(Permissions.ADMIN.key())) {
            event.addPermissions(BlockAccessMenuEvent.MenuPermission.LOCK, BlockAccessMenuEvent.MenuPermission.INFO);
        } else if (player.hasPermission(Permissions.INFO.key())) {
            event.addPermission(BlockAccessMenuEvent.MenuPermission.INFO);
        }
        if (handler.isOwner(playerUuid)) {
            event.addPermissions(BlockAccessMenuEvent.MenuPermission.LOCK, BlockAccessMenuEvent.MenuPermission.INFO, BlockAccessMenuEvent.MenuPermission.MANAGER);
        } else if (handler.isNotProtected()) {
            event.addPermission(BlockAccessMenuEvent.MenuPermission.LOCK);
        } else {
            Optional<FriendHandler> friend = handler.getFriend(playerUuid);
            if (friend.isPresent() && friend.get().isManager()) {
                event.addPermission(BlockAccessMenuEvent.MenuPermission.MANAGER);
            }
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getPermissions().isEmpty()) {
            return null;
        }
        InventoryState state = new InventoryState(block);
        state.menuPermissions = event.getPermissions();
        state.friendSearchState = InventoryState.FriendSearchState.FRIEND_SEARCH;
        InventoryState.set(player.getUniqueId(), state);
        return new BlockLockInventory().fill(player, block.getType(), handler);
    }
}

