/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import de.sean.blockprot.bukkit.squirrelid.Profile;
import de.sean.blockprot.bukkit.squirrelid.cache.ProfileCache;
import de.sean.blockprot.bukkit.squirrelid.resolver.BukkitPlayerService;
import de.sean.blockprot.bukkit.squirrelid.resolver.CombinedProfileService;
import de.sean.blockprot.bukkit.squirrelid.resolver.HttpRepositoryService;
import de.sean.blockprot.bukkit.squirrelid.resolver.PaperPlayerService;
import de.sean.blockprot.bukkit.squirrelid.resolver.ProfileService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class CachedProfileService
implements ProfileService,
ProfileCache {
    private final ProfileService resolver;
    private final ProfileCache cache;

    public CachedProfileService(ProfileCache cache) {
        ArrayList services = Lists.newArrayList((Object[])new ProfileService[]{BukkitPlayerService.getInstance(), PaperPlayerService.getInstance(), HttpRepositoryService.forMinecraft()});
        services.removeIf(Objects::isNull);
        this.resolver = new CombinedProfileService(services);
        this.cache = cache;
    }

    @Override
    public int getIdealRequestLimit() {
        return this.resolver.getIdealRequestLimit();
    }

    @Override
    @Nullable
    public Profile findByName(String name) throws IOException, InterruptedException {
        Profile profile = this.resolver.findByName(name);
        if (profile != null) {
            this.put(profile);
        }
        return profile;
    }

    @Override
    public ImmutableList<Profile> findAllByName(Iterable<String> names) throws IOException, InterruptedException {
        ImmutableList<Profile> profiles = this.resolver.findAllByName(names);
        this.putAll((Iterable<Profile>)profiles);
        return profiles;
    }

    @Override
    public void findAllByName(Iterable<String> names, Predicate<Profile> predicate) throws IOException, InterruptedException {
        this.resolver.findAllByName(names, input -> {
            this.put((Profile)input);
            return predicate.test((Profile)input);
        });
    }

    @Override
    @Nullable
    public Profile findByUuid(UUID uuid) {
        Profile profile = this.getIfPresent(uuid);
        if (profile == null) {
            try {
                profile = this.resolver.findByUuid(uuid);
                if (profile != null) {
                    this.put(profile);
                }
            }
            catch (Exception e) {
                return profile;
            }
        }
        return profile;
    }

    @Override
    public ImmutableList<Profile> findAllByUuid(Iterable<UUID> uuids) {
        ImmutableMap<UUID, Profile> map = this.getAllPresent(uuids);
        if (map.isEmpty()) {
            ArrayList<Profile> profiles = new ArrayList<Profile>();
            for (UUID uuid : uuids) {
                try {
                    Profile profile = this.resolver.findByUuid(uuid);
                    this.put(profile);
                    profiles.add(profile);
                }
                catch (Exception e) {
                    return ImmutableList.copyOf(profiles);
                }
            }
            return ImmutableList.copyOf(profiles);
        }
        ArrayList<UUID> lookup = new ArrayList<UUID>();
        for (UUID uuid : uuids) {
            if (map.containsKey((Object)uuid) && map.get((Object)uuid) != null) continue;
            lookup.add(uuid);
        }
        if (!lookup.isEmpty()) {
            ArrayList<Profile> profiles = new ArrayList<Profile>((Collection<Profile>)map.values());
            for (UUID uuid : lookup) {
                try {
                    Profile profile = this.resolver.findByUuid(uuid);
                    this.put(profile);
                    profiles.add(profile);
                }
                catch (Exception e) {
                    return ImmutableList.copyOf(profiles);
                }
            }
            return ImmutableList.copyOf(profiles);
        }
        return map.values().asList();
    }

    @Override
    public void findAllByUuid(Iterable<UUID> uuids, Predicate<Profile> predicate) throws IOException, InterruptedException {
        this.resolver.findAllByUuid(uuids, input -> {
            this.put((Profile)input);
            return predicate.test((Profile)input);
        });
    }

    @Override
    public void put(Profile profile) {
        this.cache.put(profile);
    }

    @Override
    public void putAll(Iterable<Profile> iterable) {
        this.cache.putAll(iterable);
    }

    @Override
    @Nullable
    public Profile getIfPresent(UUID uuid) {
        return this.cache.getIfPresent(uuid);
    }

    @Override
    public ImmutableMap<UUID, Profile> getAllPresent(Iterable<UUID> iterable) {
        return this.cache.getAllPresent(iterable);
    }
}

