/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit;

import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TranslationValue {
    @NotNull
    public static final String UNKNOWN_TRANSLATION = "Unknown Translation";
    @NotNull
    public static final TranslationValue UNKNOWN_TRANSLATION_VALUE = new TranslationValue("Unknown Translation");
    @NotNull
    private final String defaultValue;
    @NotNull
    private String translatedValue;

    TranslationValue(@NotNull String defaultValue) {
        this.defaultValue = defaultValue;
        this.translatedValue = UNKNOWN_TRANSLATION;
    }

    TranslationValue(@NotNull String defaultValue, @Nullable String translatedValue) {
        this.defaultValue = defaultValue;
        this.translatedValue = translatedValue == null ? UNKNOWN_TRANSLATION : translatedValue;
    }

    @NotNull
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public String getTranslatedValue() {
        return this.translatedValue;
    }

    void setTranslatedValue(@NotNull String value) {
        this.translatedValue = value;
    }

    @NotNull
    public String getValue() {
        return this.translatedValue.equals(UNKNOWN_TRANSLATION) ? this.getDefaultValue() : this.translatedValue;
    }

    @NotNull
    public String toString() {
        return new StringJoiner(" | ", TranslationValue.class.getSimpleName() + "[", "]").add("defaultValue=" + this.defaultValue).add("translatedValue=" + this.translatedValue).toString();
    }
}

