/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit;

import com.google.common.collect.Sets;
import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.TranslationValue;
import de.sean.blockprot.nbt.LockReturnValue;
import de.sean.blockprot.util.BlockProtUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public final class Translator {
    public static final HashSet<String> DEFAULT_TRANSLATION_FILES = Sets.newHashSet(BlockProtUtil.parseStringList("[translations_cs.yml, translations_fr.yml, translations_sk.yml, translations_de.yml, translations_ja.yml, translations_zh-CN.yml, translations_en.yml, translations_pl.yml, translations_pt-br.yml, translations_it.yml, translations_ko.yml, translations_ru.yml, translations_es.yml, translations_tr.yml, translations_zh-TW.yml]"));
    @NotNull
    public static final Locale defaultLocale = Locale.UK;
    @NotNull
    private static final HashMap<TranslationKey, TranslationValue> values = new HashMap();
    @NotNull
    private static Locale locale = defaultLocale;
    static String DEFAULT_FALLBACK = "";

    private Translator() {
    }

    public static void loadFromConfigs(@NotNull YamlConfiguration defaultConfig, @NotNull YamlConfiguration config) {
        TranslationKey[] translations;
        String locale = config.getString("locale");
        Translator.locale = locale == null ? Locale.ROOT : new Locale(locale);
        long missingValues = 0L;
        long totallyMissingValues = 0L;
        for (TranslationKey translation : translations = TranslationKey.values()) {
            String translationKey = translation.toString();
            if (!defaultConfig.contains(translationKey, true) && !config.contains(translationKey, true)) {
                values.put(translation, TranslationValue.UNKNOWN_TRANSLATION_VALUE);
                ++totallyMissingValues;
                continue;
            }
            Object defaultValue = defaultConfig.get(translationKey);
            TranslationValue translatedValue = defaultValue instanceof String ? new TranslationValue((String)defaultValue) : TranslationValue.UNKNOWN_TRANSLATION_VALUE;
            Object newTranslatedValue = config.get(translationKey);
            if (newTranslatedValue instanceof String) {
                translatedValue.setTranslatedValue((String)newTranslatedValue);
            } else {
                ++missingValues;
            }
            values.put(translation, translatedValue);
        }
        if (missingValues > 0L) {
            BlockProt.getInstance().getLogger().warning("At least " + missingValues + " translations have not been found in config: " + BlockProt.getDefaultConfig().getLanguageFile());
        }
        if (totallyMissingValues > 0L) {
            BlockProt.getInstance().getLogger().warning("At least " + totallyMissingValues + " translations have not been found in any config.");
        }
    }

    @NotNull
    public static String get(@NotNull TranslationKey key) {
        TranslationValue value = values.get((Object)key);
        return value == null ? DEFAULT_FALLBACK : value.getValue();
    }

    @NotNull
    public static String get(@NotNull LockReturnValue.Reason reason) {
        return switch (reason) {
            default -> throw new IncompatibleClassChangeError();
            case LockReturnValue.Reason.NO_PERMISSION -> Translator.get(TranslationKey.MESSAGES__NO_PERMISSION);
            case LockReturnValue.Reason.EXCEEDED_MAX_BLOCK_COUNT -> Translator.get(TranslationKey.MESSAGES__EXCEEDED_MAX_BLOCK_COUNT);
        };
    }

    @NotNull
    public static Locale getLocale() {
        return locale;
    }

    public static void resetTranslations() {
        values.clear();
    }
}

