/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.commands;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.commands.CommandExecutor;
import java.util.List;
import java.util.regex.Pattern;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AboutCommand
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        ComponentBuilder builder = new ComponentBuilder();
        PluginDescriptionFile description = BlockProt.getInstance().getDescription();
        builder.append("\u00a7x\u00a7a\u00a73\u00a7c\u00a76\u00a7e\u00a7bBlockProt v" + description.getVersion() + " - Spigot Plugin\n");
        builder.append("Author: " + Pattern.compile("[\\[\\]]").matcher(description.getAuthors().toString()).replaceAll("") + "\n");
        builder.append((BaseComponent)this.createUrlComponent("\u00a7x\u00a7c\u00a73\u00a7e\u00a7e\u00a7a\u00a77Click here to report issues or for suggestions", "https://github.com/spnda/BlockProt/issues", "You can report issues to me here!"));
        sender.spigot().sendMessage(builder.create());
        return true;
    }

    @NotNull
    private TextComponent createUrlComponent(@NotNull String text, @NotNull String url, String hoverText) {
        TextComponent component = new TextComponent(text);
        component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        if (hoverText != null) {
            component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(hoverText)}));
        }
        return component;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return null;
    }
}

