/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.commands;

import de.sean.blockprot.bukkit.commands.AboutCommand;
import de.sean.blockprot.bukkit.commands.CommandExecutor;
import de.sean.blockprot.bukkit.commands.DebugCommand;
import de.sean.blockprot.bukkit.commands.HintsCommand;
import de.sean.blockprot.bukkit.commands.IntegrationsCommand;
import de.sean.blockprot.bukkit.commands.ReloadCommand;
import de.sean.blockprot.bukkit.commands.SettingsCommand;
import de.sean.blockprot.bukkit.commands.StatisticsCommand;
import de.sean.blockprot.bukkit.commands.UpdateCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.NotNull;

public final class BlockProtCommand
implements TabExecutor {
    static Map<String, CommandExecutor> tabExecutors = new HashMap<String, CommandExecutor>();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            return false;
        }
        CommandExecutor executor = tabExecutors.get(args[0]);
        if (executor != null) {
            return executor.onCommand(sender, command, label, args);
        }
        return false;
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        List completions;
        if (args.length <= 1) {
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry<String, CommandExecutor> entry : tabExecutors.entrySet()) {
                if (!entry.getValue().canUseCommand(sender)) continue;
                list.add(entry.getKey());
            }
            return list;
        }
        CommandExecutor executor = tabExecutors.get(args[0]);
        if (executor != null && (completions = executor.onTabComplete(sender, command, alias, args)) != null) {
            return completions;
        }
        return Collections.emptyList();
    }

    static {
        StatisticsCommand statsCommand = new StatisticsCommand();
        tabExecutors.put("stats", statsCommand);
        tabExecutors.put("statistics", statsCommand);
        tabExecutors.put("settings", new SettingsCommand());
        tabExecutors.put("about", new AboutCommand());
        tabExecutors.put("update", new UpdateCommand());
        tabExecutors.put("reload", new ReloadCommand());
        tabExecutors.put("integrations", new IntegrationsCommand());
        tabExecutors.put("debug", new DebugCommand());
        tabExecutors.put("disablehints", new HintsCommand());
    }
}

