/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.config;

import de.sean.blockprot.bukkit.BlockProt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public abstract class BlockProtConfig {
    @NotNull
    protected final FileConfiguration config;

    public BlockProtConfig(@NotNull FileConfiguration config) {
        this.config = config;
    }

    protected boolean listContainsIgnoreCase(@NotNull List<String> list, @NotNull String query) {
        for (String item : list) {
            if (!item.equalsIgnoreCase(query)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected <T extends Enum<?>> Set<T> loadEnumValuesByName(@NotNull T[] enumValues, @NotNull ArrayList<String> names) {
        HashSet<T> ret = new HashSet<T>();
        for (T value : enumValues) {
            if (!this.listContainsIgnoreCase(names, ((Enum)value).name())) continue;
            ret.add(value);
            names.remove(((Enum)value).name());
        }
        if (!names.isEmpty()) {
            BlockProt.getInstance().getLogger().warning("Failed to map following values to enum: " + String.valueOf(names));
        }
        return ret;
    }
}

