/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.config;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.config.BlockProtConfig;
import de.sean.blockprot.bukkit.shaded.nbtapi.utils.MinecraftVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.DoubleChest;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultConfig
extends BlockProtConfig {
    private final ArrayList<Material> lockableTileEntities = new ArrayList();
    private final ArrayList<Material> shulkerBoxes = new ArrayList();
    private final ArrayList<Material> lockableBlocks = new ArrayList();
    private final ArrayList<Material> lockableDoors = new ArrayList();
    private final ArrayList<InventoryType> lockableInventories = new ArrayList<InventoryType>(Arrays.asList(InventoryType.CHEST, InventoryType.FURNACE, InventoryType.SMOKER, InventoryType.BLAST_FURNACE, InventoryType.HOPPER, InventoryType.BARREL, InventoryType.BREWING, InventoryType.SHULKER_BOX, InventoryType.ANVIL, InventoryType.DISPENSER, InventoryType.DROPPER, InventoryType.LECTERN));
    private final HashSet<Material> knownGoodTileEntities = new HashSet<Material>(Arrays.asList(Material.CHEST, Material.TRAPPED_CHEST, Material.FURNACE, Material.SMOKER, Material.BLAST_FURNACE, Material.HOPPER, Material.BARREL, Material.BREWING_STAND, Material.DISPENSER, Material.DROPPER, Material.LECTERN, Material.BEEHIVE, Material.BEE_NEST, Material.OAK_SIGN, Material.OAK_WALL_SIGN, Material.SPRUCE_SIGN, Material.SPRUCE_WALL_SIGN, Material.BIRCH_SIGN, Material.BIRCH_WALL_SIGN, Material.JUNGLE_SIGN, Material.JUNGLE_WALL_SIGN, Material.ACACIA_SIGN, Material.ACACIA_WALL_SIGN, Material.DARK_OAK_SIGN, Material.DARK_OAK_WALL_SIGN, Material.CRIMSON_SIGN, Material.CRIMSON_WALL_SIGN, Material.WARPED_SIGN, Material.WARPED_WALL_SIGN));
    private final List<String> excludedWorlds;

    public DefaultConfig(@NotNull FileConfiguration config) {
        super(config);
        this.excludedWorlds = config.getStringList("excluded_worlds");
        this.removeBlockDefaults();
        this.loadBlocksFromConfig();
    }

    private <T extends Enum<?>> void loadBlockListFromConfig(@NotNull String key, @NotNull ArrayList<T> list, @NotNull T[] enumValues, Function<T, Boolean> validateCallback) {
        List configList = this.config.getList(key);
        if (configList == null) {
            return;
        }
        ArrayList stringList = configList.stream().filter(String.class::isInstance).map(String.class::cast).distinct().collect(Collectors.toCollection(ArrayList::new));
        Set newEnumValues = this.loadEnumValuesByName((Enum[])enumValues, stringList);
        newEnumValues.removeIf(value -> {
            if (!((Boolean)validateCallback.apply(value)).booleanValue()) {
                BlockProt.getInstance().getLogger().warning("Caught invalid value passed to " + key + ": " + value.toString());
                return true;
            }
            return false;
        });
        list.addAll(newEnumValues);
    }

    private void loadBlocksFromConfig() {
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_19_R1)) {
            this.knownGoodTileEntities.addAll(List.of(Material.MANGROVE_SIGN, Material.MANGROVE_WALL_SIGN));
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R1)) {
            this.knownGoodTileEntities.add(Material.CHISELED_BOOKSHELF);
            this.knownGoodTileEntities.addAll(List.of(Material.OAK_WALL_HANGING_SIGN, Material.OAK_HANGING_SIGN));
            this.knownGoodTileEntities.addAll(List.of(Material.SPRUCE_WALL_HANGING_SIGN, Material.SPRUCE_HANGING_SIGN));
            this.knownGoodTileEntities.addAll(List.of(Material.BIRCH_WALL_HANGING_SIGN, Material.BIRCH_HANGING_SIGN));
            this.knownGoodTileEntities.addAll(List.of(Material.JUNGLE_WALL_HANGING_SIGN, Material.JUNGLE_HANGING_SIGN));
            this.knownGoodTileEntities.addAll(List.of(Material.ACACIA_WALL_HANGING_SIGN, Material.ACACIA_HANGING_SIGN));
            this.knownGoodTileEntities.addAll(List.of(Material.DARK_OAK_WALL_HANGING_SIGN, Material.DARK_OAK_HANGING_SIGN));
            this.knownGoodTileEntities.addAll(List.of(Material.CRIMSON_WALL_HANGING_SIGN, Material.CRIMSON_HANGING_SIGN));
            this.knownGoodTileEntities.addAll(List.of(Material.WARPED_WALL_HANGING_SIGN, Material.WARPED_HANGING_SIGN));
            this.knownGoodTileEntities.addAll(List.of(Material.MANGROVE_HANGING_SIGN, Material.MANGROVE_WALL_HANGING_SIGN));
            this.knownGoodTileEntities.addAll(List.of(Material.CHERRY_SIGN, Material.CHERRY_WALL_SIGN, Material.CHERRY_HANGING_SIGN, Material.CHERRY_WALL_HANGING_SIGN));
            this.knownGoodTileEntities.addAll(List.of(Material.BAMBOO_SIGN, Material.BAMBOO_WALL_SIGN, Material.BAMBOO_HANGING_SIGN, Material.BAMBOO_WALL_HANGING_SIGN));
        }
        this.loadBlockListFromConfig("lockable_tile_entities", this.lockableTileEntities, (Enum[])Material.values(), this.knownGoodTileEntities::contains);
        this.loadBlockListFromConfig("lockable_shulker_boxes", this.shulkerBoxes, (Enum[])Material.values(), material -> material.toString().contains("SHULKER_BOX"));
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_16_R3)) {
            this.loadBlockListFromConfig("lockable_blocks", this.lockableBlocks, (Enum[])Material.values(), material -> !this.knownGoodTileEntities.contains(material));
            this.loadBlockListFromConfig("lockable_doors", this.lockableDoors, (Enum[])Material.values(), material -> material.toString().contains("DOOR"));
            this.lockableBlocks.addAll(this.lockableDoors);
        }
    }

    @Nullable
    public String getLanguageFile() {
        return this.config.getString("language_file");
    }

    public boolean shouldReplaceTranslations() {
        if (!this.config.contains("replace_translations")) {
            return true;
        }
        return this.config.getBoolean("replace_translations");
    }

    public boolean shouldNotifyOpOfUpdates() {
        if (!this.config.contains("notify_op_of_updates")) {
            return false;
        }
        return this.config.getBoolean("notify_op_of_updates");
    }

    public boolean disallowRedstoneOnPlace() {
        if (this.config.contains("redstone_disallowed_by_default")) {
            return this.config.getBoolean("redstone_disallowed_by_default");
        }
        return true;
    }

    public boolean isWorldExcluded(World world) {
        return this.listContainsIgnoreCase(this.excludedWorlds, world.getName());
    }

    public boolean isWorldExcluded(InventoryHolder holder) {
        try {
            if (holder instanceof DoubleChest) {
                @Nullable World world = ((DoubleChest)holder).getWorld();
                if (world == null) {
                    return true;
                }
                return this.listContainsIgnoreCase(this.excludedWorlds, world.getName());
            }
            return this.isWorldExcluded(((BlockInventoryHolder)holder).getBlock().getWorld());
        }
        catch (ClassCastException e) {
            return true;
        }
    }

    public boolean lockOnPlaceByDefault() {
        if (!this.config.contains("lock_on_place_by_default")) {
            return true;
        }
        return this.config.getBoolean("lock_on_place_by_default");
    }

    public boolean publicIsFriendByDefault() {
        if (!this.config.contains("public_is_friend_by_default")) {
            return false;
        }
        return this.config.getBoolean("public_is_friend_by_default");
    }

    @Nullable
    public String getTranslationFallbackString() {
        if (!this.config.contains("fallback_string")) {
            return "";
        }
        return this.config.getString("fallback_string");
    }

    @Nullable
    public Integer getMaxLockedBlockCount() {
        if (!this.config.contains("player_max_locked_block_count")) {
            return null;
        }
        int val = this.config.getInt("player_max_locked_block_count");
        return val > 0 ? Integer.valueOf(val) : null;
    }

    public void removeBlockDefaults() {
        Configuration defaults = this.config.getDefaults();
        if (defaults != null) {
            defaults.set("lockable_tile_entities", null);
            defaults.set("lockable_shulker_boxes", null);
            defaults.set("lockable_blocks", null);
            defaults.set("lockable_doors", null);
            this.config.setDefaults(defaults);
        }
    }

    public long getLockHintCooldown() {
        if (!this.config.contains("lock_hint_cooldown_in_seconds")) {
            return 10L;
        }
        return this.config.getLong("lock_hint_cooldown_in_seconds");
    }

    public double getFriendSearchSimilarityPercentage() {
        if (!this.config.contains("friend_search_similarity")) {
            return 0.5;
        }
        return this.config.getDouble("friend_search_similarity");
    }

    public boolean isFriendFunctionalityDisabled() {
        if (!this.config.contains("disable_friend_functionality")) {
            return false;
        }
        return this.config.getBoolean("disable_friend_functionality");
    }

    public boolean isLockable(Material type) {
        return this.isLockableBlock(type) || this.isLockableTileEntity(type);
    }

    public boolean isLockableBlock(Material type) {
        return this.lockableBlocks.contains(type);
    }

    public boolean isLockableTileEntity(Material type) {
        return this.lockableTileEntities.contains(type) || this.shulkerBoxes.contains(type);
    }

    public boolean isLockableDoor(Material type) {
        return this.lockableDoors.contains(type);
    }

    public boolean isLockableShulkerBox(Material type) {
        return this.shulkerBoxes.contains(type);
    }

    public boolean isLockableInventory(InventoryType type) {
        return this.lockableInventories.contains(type);
    }
}

