/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.events;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.jetbrains.annotations.NotNull;

public final class BlockAccessMenuEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();
    @NotNull
    private final Player player;
    @NotNull
    private final Set<MenuPermission> permissions = new HashSet<MenuPermission>();
    private boolean isCancelled = false;

    public BlockAccessMenuEvent(@NotNull Block block, @NotNull Player player) {
        super(block);
        this.player = player;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Set<MenuPermission> getPermissions() {
        return this.permissions;
    }

    public void addPermission(@NotNull MenuPermission permission) {
        this.permissions.add(permission);
    }

    public void addPermissions(MenuPermission ... permissions) {
        this.permissions.addAll(Arrays.asList(permissions));
    }

    public void removePermission(@NotNull MenuPermission permission) {
        this.permissions.remove((Object)permission);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancel) {
        this.isCancelled = cancel;
    }

    public static enum MenuPermission {
        INFO,
        LOCK,
        MANAGER;

    }
}

