/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.integrations;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.events.BlockAccessMenuEvent;
import de.sean.blockprot.bukkit.events.BlockLockOnPlaceEvent;
import de.sean.blockprot.bukkit.integrations.PluginIntegration;
import java.util.ArrayList;
import java.util.UUID;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.exceptions.FlagConflictException;
import me.angeschossen.lands.api.flags.enums.FlagTarget;
import me.angeschossen.lands.api.flags.enums.RoleFlagCategory;
import me.angeschossen.lands.api.flags.type.NaturalFlag;
import me.angeschossen.lands.api.flags.type.RoleFlag;
import me.angeschossen.lands.api.land.Area;
import me.angeschossen.lands.api.role.Role;
import me.angeschossen.lands.api.role.enums.RoleType;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LandsPluginIntegration
extends PluginIntegration
implements Listener {
    @Nullable
    private Plugin landsPlugin = null;
    @Nullable
    private LandsIntegration integration = null;
    @Nullable
    private RoleFlag protectContainersFlag = null;
    @Nullable
    private NaturalFlag requireProtectForFriendFlag = null;
    private static final String LOCK_CONTAINER_FLAG_ID = "bp_lock_containers";
    private static final String REQUIRE_PROTECT_FOR_FRIEND_FLAG = "bp_friend_req_prot";
    private static final String ALLOW_PROTECTING_CONTAINERS_IN_WILDERNESS = "allow_protecting_containers_in_wilderness";
    private boolean enabled = false;

    public LandsPluginIntegration() {
        super("lands");
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void load() {
        super.load();
        this.landsPlugin = this.getPlugin();
        if (this.landsPlugin == null) {
            return;
        }
        this.integration = LandsIntegration.of((Plugin)BlockProt.getInstance());
        try {
            this.protectContainersFlag = RoleFlag.of((LandsIntegration)this.integration, (FlagTarget)FlagTarget.PLAYER, (RoleFlagCategory)RoleFlagCategory.ACTION, (String)LOCK_CONTAINER_FLAG_ID);
            this.requireProtectForFriendFlag = NaturalFlag.of((LandsIntegration)this.integration, (FlagTarget)FlagTarget.PLAYER, (String)REQUIRE_PROTECT_FOR_FRIEND_FLAG);
            ((RoleFlag)((RoleFlag)((RoleFlag)((RoleFlag)((RoleFlag)this.protectContainersFlag.setApplyInSubareas(true)).setAlwaysAllowInWilderness(this.allowProtectingContainersInWilderness())).setIcon(new ItemStack(Material.CHEST))).setDisplay(true)).setDescription(Translator.get(TranslationKey.INTEGRATIONS__LANDS__PROTECT_CONTAINERS_DESC))).setDisplayName(Translator.get(TranslationKey.INTEGRATIONS__LANDS__PROTECT_CONTAINERS_FLAG_NAME));
            ((NaturalFlag)((NaturalFlag)((NaturalFlag)this.requireProtectForFriendFlag.setIcon(new ItemStack(Material.ENDER_PEARL))).setDisplay(true)).setDescription(Translator.get(TranslationKey.INTEGRATIONS__LANDS__REQUIRE_PROTECT_FOR_FRIENDS_DESC))).setDisplayName(Translator.get(TranslationKey.INTEGRATIONS__LANDS__REQUIRE_PROTECT_FOR_FRIENDS_FLAG_NAME));
        }
        catch (IllegalArgumentException | FlagConflictException e) {
            BlockProt.getInstance().getLogger().warning("LandsIntegration: Failed to register flag(s).");
            e.printStackTrace();
        }
    }

    @Override
    public void enable() {
        if (this.landsPlugin == null || !this.landsPlugin.isEnabled()) {
            return;
        }
        this.registerListener(this);
        this.enabled = true;
    }

    @Override
    public void reload() {
        super.reload();
        if (this.protectContainersFlag == null || this.requireProtectForFriendFlag == null) {
            return;
        }
        ((RoleFlag)this.protectContainersFlag.setDescription(Translator.get(TranslationKey.INTEGRATIONS__LANDS__PROTECT_CONTAINERS_DESC))).setDisplayName(Translator.get(TranslationKey.INTEGRATIONS__LANDS__PROTECT_CONTAINERS_FLAG_NAME));
        ((NaturalFlag)this.requireProtectForFriendFlag.setDescription(Translator.get(TranslationKey.INTEGRATIONS__LANDS__REQUIRE_PROTECT_FOR_FRIENDS_DESC))).setDisplayName(Translator.get(TranslationKey.INTEGRATIONS__LANDS__REQUIRE_PROTECT_FOR_FRIENDS_FLAG_NAME));
    }

    @Override
    @Nullable
    public Plugin getPlugin() {
        return BlockProt.getInstance().getPlugin("Lands");
    }

    @Override
    protected void filterFriendsInternal(@NotNull ArrayList<OfflinePlayer> friends, @NotNull Player player, @NotNull Block block) {
        assert (this.integration != null);
        if (this.landsPlugin == null || this.requireProtectForFriendFlag == null) {
            return;
        }
        Area area = this.integration.getArea(block.getLocation());
        if (area == null) {
            return;
        }
        friends.removeIf(p -> {
            Role role = area.getRole(p.getUniqueId());
            return role.getType() == RoleType.VISITOR || area.hasNaturalFlag(this.requireProtectForFriendFlag) && role.hasFlag(this.protectContainersFlag);
        });
    }

    @Override
    protected boolean filterFriendByUuid(@NotNull UUID friend, @NotNull Player player, @NotNull Block block) {
        assert (this.integration != null);
        if (this.landsPlugin == null || this.requireProtectForFriendFlag == null) {
            return true;
        }
        Area area = this.integration.getArea(block.getLocation());
        if (area == null) {
            return true;
        }
        Role role = area.getRole(player.getUniqueId());
        if (role.getType() == RoleType.VISITOR) {
            return false;
        }
        if (area.hasNaturalFlag(this.requireProtectForFriendFlag)) {
            return role.hasFlag(this.protectContainersFlag);
        }
        return true;
    }

    private boolean allowProtectingContainersInWilderness() {
        return this.configuration.contains(ALLOW_PROTECTING_CONTAINERS_IN_WILDERNESS) && this.configuration.getBoolean(ALLOW_PROTECTING_CONTAINERS_IN_WILDERNESS);
    }

    @EventHandler
    public void onAccessEditMenu(@NotNull BlockAccessMenuEvent event) {
        assert (this.integration != null);
        Area area = this.integration.getArea(event.getBlock().getLocation());
        if (area == null) {
            if (!this.allowProtectingContainersInWilderness()) {
                event.removePermission(BlockAccessMenuEvent.MenuPermission.LOCK);
                event.removePermission(BlockAccessMenuEvent.MenuPermission.MANAGER);
            }
            return;
        }
        Role role = area.getRole(event.getPlayer().getUniqueId());
        if (!role.hasFlag(this.protectContainersFlag) || role.getType() == RoleType.VISITOR) {
            event.removePermission(BlockAccessMenuEvent.MenuPermission.LOCK);
            event.removePermission(BlockAccessMenuEvent.MenuPermission.MANAGER);
        }
    }

    @EventHandler
    public void onLockOnPlace(@NotNull BlockLockOnPlaceEvent event) {
        assert (this.integration != null);
        Area area = this.integration.getArea(event.getBlock().getLocation());
        if (area == null) {
            if (!this.allowProtectingContainersInWilderness()) {
                event.setCancelled(true);
            }
            return;
        }
        Role role = area.getRole(event.getPlayer().getUniqueId());
        if (!role.hasFlag(this.protectContainersFlag) || role.getType() == RoleType.VISITOR) {
            event.setCancelled(true);
        }
    }
}

