/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.integrations;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.integrations.PluginIntegration;
import de.sean.blockprot.bukkit.nbt.FriendHandler;
import de.sean.blockprot.bukkit.nbt.PlayerSettingsHandler;
import de.sean.blockprot.bukkit.nbt.StatHandler;
import de.sean.blockprot.bukkit.nbt.stats.BlockCountStatistic;
import de.sean.blockprot.bukkit.nbt.stats.PlayerBlocksStatistic;
import java.util.List;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlaceholderAPIIntegration
extends PluginIntegration {
    private BlockProtExpansion expansion;
    private boolean enabled = false;

    public PlaceholderAPIIntegration() {
        super("placeholderapi");
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void enable() {
        Plugin papi = this.getPlugin();
        if (papi == null || !papi.isEnabled()) {
            return;
        }
        this.expansion = new BlockProtExpansion();
        this.expansion.register();
        if (this.expansion.isRegistered()) {
            this.enabled = true;
        }
    }

    @Override
    @Nullable
    public Plugin getPlugin() {
        return BlockProt.getInstance().getPlugin("PlaceholderAPI");
    }

    private static final class BlockProtExpansion
    extends PlaceholderExpansion {
        private BlockProtExpansion() {
        }

        public boolean persist() {
            return true;
        }

        @NotNull
        public String getIdentifier() {
            return "blockprot";
        }

        @NotNull
        public String getAuthor() {
            return BlockProt.getInstance().getDescription().getAuthors().toString();
        }

        @NotNull
        public String getVersion() {
            return BlockProt.getInstance().getDescription().getVersion();
        }

        public String onRequest(OfflinePlayer player, @NotNull String identifier) {
            if (player == null) {
                return "";
            }
            switch (identifier) {
                case "global_block_count": {
                    BlockCountStatistic blockCountStatistic = new BlockCountStatistic();
                    StatHandler.getStatistic(blockCountStatistic);
                    return blockCountStatistic.get().toString();
                }
            }
            return null;
        }

        public String onPlaceholderRequest(Player player, @NotNull String identifier) {
            if (player == null) {
                return null;
            }
            switch (identifier) {
                case "default_friends": {
                    List<FriendHandler> players = new PlayerSettingsHandler(player).getFriends();
                    return players.stream().map(FriendHandler::getName).toList().toString();
                }
                case "own_block_count": {
                    PlayerBlocksStatistic playerBlocksStatistic = new PlayerBlocksStatistic();
                    StatHandler.getStatistic(playerBlocksStatistic, player);
                    return playerBlocksStatistic.get().toString();
                }
            }
            return null;
        }
    }
}

