/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.integrations;

import de.sean.blockprot.bukkit.BlockProt;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.CheckReturnValue;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PluginIntegration {
    @NotNull
    protected YamlConfiguration configuration;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    public final String name;

    public PluginIntegration(@NotNull String name) {
        this.name = name;
        this.configuration = BlockProt.getInstance().saveAndLoadConfigFile("integrations/", name + ".yml", false);
        this.pluginManager = BlockProt.getInstance().getServer().getPluginManager();
    }

    @CheckReturnValue
    @Deprecated
    @NotNull
    public static ArrayList<OfflinePlayer> filterFriends(@NotNull ArrayList<OfflinePlayer> friendsInput, @NotNull Player player, @NotNull Block block) {
        ArrayList<OfflinePlayer> friends = new ArrayList<OfflinePlayer>(friendsInput);
        for (PluginIntegration integration : BlockProt.getInstance().getIntegrations()) {
            if (!integration.isEnabled()) continue;
            try {
                Class<?> clazz = integration.getClass();
                if (clazz.equals(clazz.getMethod("filterFriendsByUUID", ArrayList.class, Player.class, Block.class).getDeclaringClass())) {
                    friends = new ArrayList<OfflinePlayer>(friends.stream().filter(p -> integration.filterFriendByUuid(p.getUniqueId(), player, block)).toList());
                    continue;
                }
                integration.filterFriendsInternal(friends, player, block);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return friends;
    }

    public static boolean filterFriendByUuidForAll(@NotNull UUID friend, @NotNull Player player, @NotNull Block block) {
        for (PluginIntegration integration : BlockProt.getInstance().getIntegrations()) {
            if (!integration.isEnabled() || integration.filterFriendByUuid(friend, player, block)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isEnabled();

    public void load() {
    }

    public abstract void enable();

    public void reload() {
        this.configuration = BlockProt.getInstance().saveAndLoadConfigFile("integrations/", this.name + ".yml", false);
    }

    @Nullable
    public abstract Plugin getPlugin();

    @Deprecated
    protected void filterFriendsInternal(@NotNull ArrayList<OfflinePlayer> friends, @NotNull Player player, @NotNull Block block) {
    }

    protected boolean filterFriendByUuid(@NotNull UUID friend, @NotNull Player player, @NotNull Block block) {
        return true;
    }

    protected void registerListener(@NotNull Listener listener) {
        this.pluginManager.registerEvents(listener, (Plugin)BlockProt.getInstance());
    }
}

