/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.integrations;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.PlotClearEvent;
import com.palmergames.bukkit.towny.event.town.TownRuinedEvent;
import com.palmergames.bukkit.towny.event.town.TownUnclaimEvent;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.events.BlockAccessEvent;
import de.sean.blockprot.bukkit.events.BlockAccessMenuEvent;
import de.sean.blockprot.bukkit.events.BlockLockOnPlaceEvent;
import de.sean.blockprot.bukkit.integrations.PluginIntegration;
import de.sean.blockprot.bukkit.nbt.BlockNBTHandler;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TownyIntegration
extends PluginIntegration
implements Listener {
    private static final String CLEANUP_PLOTS_AFTER_UNCLAIM = "cleanup_plots_after_unclaim";
    private static final String RESTRICT_ACCESS_TO_RESIDENTS = "restrict_access_to_residents";
    private static final String ALLOW_MAYOR_TO_SEE_BLOCK_INFO = "allow_mayor_to_see_block_info";
    private static final String BYPASS_PROTECTIONS_IN_RUINED_TOWNS = "bypass_protection_in_ruined_towns";
    @Nullable
    private Towny towny;
    private boolean enabled = false;

    public TownyIntegration() {
        super("towny");
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void enable() {
        Plugin plugin = this.getPlugin();
        if (plugin == null || !plugin.isEnabled()) {
            return;
        }
        this.towny = (Towny)plugin;
        this.registerListener(this);
        this.enabled = true;
    }

    @Override
    public Plugin getPlugin() {
        return BlockProt.getInstance().getPlugin("Towny");
    }

    @Override
    protected void filterFriendsInternal(@NotNull ArrayList<OfflinePlayer> friends, @NotNull Player player, @NotNull Block block) {
        if (this.towny == null || TownyAPI.getInstance().isWilderness(block) || !this.shouldRestrictAccessToResidents()) {
            return;
        }
        Town town = TownyAPI.getInstance().getTown(block.getLocation());
        if (town == null) {
            return;
        }
        friends.removeIf(friend -> {
            Resident resident = TownyAPI.getInstance().getResident(friend.getUniqueId());
            return resident == null || !town.hasResident(resident);
        });
    }

    @Override
    protected boolean filterFriendByUuid(@NotNull UUID friend, @NotNull Player player, @NotNull Block block) {
        if (this.towny == null || TownyAPI.getInstance().isWilderness(block) || !this.shouldRestrictAccessToResidents()) {
            return true;
        }
        Town town = TownyAPI.getInstance().getTown(block.getLocation());
        if (town == null) {
            return true;
        }
        Resident resident = TownyAPI.getInstance().getResident(friend);
        return resident != null && town.hasResident(resident);
    }

    private boolean shouldRestrictAccessToResidents() {
        return this.configuration.contains(RESTRICT_ACCESS_TO_RESIDENTS) && this.configuration.getBoolean(RESTRICT_ACCESS_TO_RESIDENTS);
    }

    private boolean shouldAllowMayorToSeeBlockInfo() {
        return this.configuration.contains(ALLOW_MAYOR_TO_SEE_BLOCK_INFO) && this.configuration.getBoolean(ALLOW_MAYOR_TO_SEE_BLOCK_INFO);
    }

    private boolean shouldCleanupAfterUnclaim() {
        return this.configuration.contains(CLEANUP_PLOTS_AFTER_UNCLAIM) || this.configuration.getBoolean(CLEANUP_PLOTS_AFTER_UNCLAIM);
    }

    private boolean shouldBypassProtectionsInRuinedTowns() {
        return this.configuration.contains(BYPASS_PROTECTIONS_IN_RUINED_TOWNS) || this.configuration.getBoolean(BYPASS_PROTECTIONS_IN_RUINED_TOWNS);
    }

    private boolean residentEqualsPlayer(@Nullable Resident resident, @Nullable Player player) {
        if (resident == null && player == null) {
            return true;
        }
        if (resident == null || resident.getPlayer() == null || player == null) {
            return false;
        }
        return resident.getPlayer().equals(player);
    }

    private void removeAllProtections(@Nullable WorldCoord worldCoord) {
        if (worldCoord == null) {
            return;
        }
        World world = worldCoord.getBukkitWorld();
        int height = world.getMaxHeight() - 1;
        int size = TownySettings.getTownBlockSize();
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                for (int y = height; y > 0; --y) {
                    int blockX = worldCoord.getX() * size + x;
                    int blockZ = worldCoord.getZ() * size + z;
                    Block block = world.getBlockAt(blockX, y, blockZ);
                    if (!BlockProt.getDefaultConfig().isLockable(block.getType())) continue;
                    BlockNBTHandler handler = new BlockNBTHandler(block);
                    handler.clear();
                }
            }
        }
    }

    @EventHandler
    public void onAccess(@NotNull BlockAccessEvent event) {
        if (this.towny == null) {
            return;
        }
        Block block = event.getBlock();
        if (TownyAPI.getInstance().isWilderness(block)) {
            return;
        }
        Town town = TownyAPI.getInstance().getTown(block.getLocation());
        if (town == null) {
            return;
        }
        if (this.shouldRestrictAccessToResidents()) {
            Resident resident = TownyAPI.getInstance().getResident(event.getPlayer().getUniqueId());
            if (resident == null || !town.hasResident(resident)) {
                event.setCancelled(true);
            }
        } else if (this.shouldBypassProtectionsInRuinedTowns() && town.isRuined()) {
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onAccessEditMenu(@NotNull BlockAccessMenuEvent event) {
        if (this.towny == null) {
            return;
        }
        Block block = event.getBlock();
        if (TownyAPI.getInstance().isWilderness(block)) {
            return;
        }
        if (!PlayerCacheUtil.getCachePermission((Player)event.getPlayer(), (Location)block.getLocation(), (Material)block.getType(), (TownyPermission.ActionType)TownyPermission.ActionType.DESTROY)) {
            event.setCancelled(true);
            return;
        }
        Town town = TownyAPI.getInstance().getTown(block.getLocation());
        if (town == null) {
            return;
        }
        if (this.residentEqualsPlayer(town.getMayor(), event.getPlayer()) && this.shouldAllowMayorToSeeBlockInfo()) {
            event.addPermission(BlockAccessMenuEvent.MenuPermission.INFO);
        } else if (town.isRuined()) {
            event.setCancelled(!this.shouldBypassProtectionsInRuinedTowns());
        }
    }

    @EventHandler
    public void onLockOnPlace(@NotNull BlockLockOnPlaceEvent event) {
        Resident resident;
        Town town;
        if (this.towny == null) {
            return;
        }
        Block block = event.getBlock();
        if (TownyAPI.getInstance().isWilderness(block)) {
            return;
        }
        if (this.shouldRestrictAccessToResidents() && (town = TownyAPI.getInstance().getTown(block.getLocation())) != null && ((resident = TownyAPI.getInstance().getResident(event.getPlayer().getUniqueId())) == null || town.hasResident(resident))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlotClear(@NotNull PlotClearEvent event) {
        if (!this.shouldCleanupAfterUnclaim() || event.getTownBlock() == null) {
            return;
        }
        this.removeAllProtections(event.getTownBlock().getWorldCoord());
    }

    @EventHandler
    public void onTownRuin(@NotNull TownRuinedEvent event) {
        if (!this.shouldCleanupAfterUnclaim()) {
            return;
        }
        for (TownBlock townBlock : new ArrayList(event.getTown().getTownBlocks())) {
            this.removeAllProtections(townBlock.getWorldCoord());
        }
    }

    @EventHandler
    public void onTownUnclaim(@NotNull TownUnclaimEvent event) {
        if (!this.shouldCleanupAfterUnclaim()) {
            return;
        }
        this.removeAllProtections(event.getWorldCoord());
    }
}

